/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.network;

import java.util.function.Supplier;
import net.gigabit101.shrink.api.ShrinkAPI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketShrink {
    private final CompoundNBT nbt;
    private final int entityID;

    public PacketShrink(int entityID, CompoundNBT nbt) {
        this.nbt = nbt;
        this.entityID = entityID;
    }

    public static void encode(PacketShrink msg, PacketBuffer buf) {
        buf.writeInt(msg.entityID);
        buf.func_150786_a(msg.nbt);
    }

    public static PacketShrink decode(PacketBuffer buf) {
        return new PacketShrink(buf.readInt(), buf.func_150793_b());
    }

    public static class Handler {
        public static void handle(PacketShrink message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity;
                ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                if (world != null && (entity = world.func_73045_a(message.entityID)) instanceof LivingEntity) {
                    entity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                        iShrinkProvider.deserializeNBT((INBT)message.nbt);
                        entity.func_213323_x_();
                        entity.func_70107_b(entity.func_213303_ch().field_72450_a, entity.func_213303_ch().field_72448_b, entity.func_213303_ch().field_72449_c);
                        if (!(entity instanceof PlayerEntity)) {
                            if (iShrinkProvider.isShrunk()) {
                                entity.field_213325_aI = new EntitySize(iShrinkProvider.scale(), iShrinkProvider.scale() * 2.0f, true);
                                entity.field_213326_aJ = iShrinkProvider.defaultEyeHeight() * iShrinkProvider.scale();
                            } else {
                                entity.field_213325_aI = iShrinkProvider.defaultEntitySize();
                                entity.field_213326_aJ = iShrinkProvider.defaultEyeHeight();
                            }
                        }
                    });
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

