/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.charginggadgets.common.container;

import com.direwolf20.charginggadgets.common.blocks.ModBlocks;
import com.direwolf20.charginggadgets.common.tiles.ChargingStationTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ChargingStationContainer
extends Container {
    private static final int SLOTS = 2;
    public final IIntArray data;
    public ItemStackHandler handler;
    private ChargingStationTile tile;

    public ChargingStationContainer(int windowId, PlayerInventory playerInventory, PacketBuffer extraData) {
        this((ChargingStationTile)playerInventory.field_70458_d.field_70170_p.func_175625_s(extraData.func_179259_c()), (IIntArray)new IntArray(4), windowId, playerInventory, new ItemStackHandler(2));
    }

    public ChargingStationContainer(@Nullable ChargingStationTile tile, IIntArray chargingStationData, int windowId, PlayerInventory playerInventory, ItemStackHandler handler) {
        super((ContainerType)ModBlocks.CHARGING_STATION_CONTAINER.get(), windowId);
        this.handler = handler;
        this.tile = tile;
        this.data = chargingStationData;
        this.setup(playerInventory);
        this.func_216961_a(chargingStationData);
    }

    public void setup(PlayerInventory inventory) {
        int row;
        this.func_75146_a((Slot)new RestrictedSlot((IItemHandler)this.handler, 0, 65, 43));
        this.func_75146_a((Slot)new RestrictedSlot((IItemHandler)this.handler, 1, 119, 43));
        for (row = 0; row < 9; ++row) {
            int x = 8 + row * 18;
            int y = 142;
            this.func_75146_a(new Slot((IInventory)inventory, row, x, y));
        }
        for (row = 1; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = row * 18 + 66;
                this.func_75146_a(new Slot((IInventory)inventory, col + row * 9, x, y));
            }
        }
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack currentStack = slot.func_75211_c();
            itemstack = currentStack.func_77946_l();
            if (index < 2 ? !this.func_75135_a(currentStack, 2, this.field_75151_b.size(), false) : !this.func_75135_a(currentStack, 0, 2, false)) {
                return ItemStack.field_190927_a;
            }
            if (currentStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_75145_c(PlayerEntity playerIn) {
        BlockPos pos = this.tile.func_174877_v();
        if (this.tile == null) return false;
        if (this.tile.func_145837_r()) return false;
        Vector3d vector3d = new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        if (!(playerIn.func_195048_a(vector3d.func_72441_c(0.5, 0.5, 0.5)) <= 64.0)) return false;
        return true;
    }

    public int getMaxPower() {
        return this.data.func_221476_a(1) * 32;
    }

    public int getEnergy() {
        return this.data.func_221476_a(0) * 32;
    }

    public int getMaxBurn() {
        return this.data.func_221476_a(3);
    }

    public int getRemaining() {
        return this.data.func_221476_a(2);
    }

    static class RestrictedSlot
    extends SlotItemHandler {
        public RestrictedSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            if (this.getSlotIndex() == ChargingStationTile.Slots.CHARGE.getId()) {
                return stack.getCapability(CapabilityEnergy.ENERGY).isPresent();
            }
            if (this.getSlotIndex() == ChargingStationTile.Slots.FUEL.getId()) {
                return ForgeHooks.getBurnTime((ItemStack)stack) != 0;
            }
            return super.func_75214_a(stack);
        }
    }
}

