/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.immersiveengineering;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public abstract class IERecipeJS
extends RecipeJS {
    public JsonElement serializeIngredientStack(IngredientStackJS in) {
        if (in.getCount() == 1) {
            return in.ingredient.toJson();
        }
        JsonObject o = new JsonObject();
        o.addProperty("count", (Number)in.getCount());
        o.add("base_ingredient", in.ingredient.toJson());
        return o;
    }

    public IngredientJS convertReplacedInput(int index, IngredientJS oldIngredient, IngredientJS newIngredient) {
        return newIngredient.asIngredientStack();
    }

    public IngredientStackJS parseIngredientItemIE(JsonElement json) {
        if (json.isJsonObject() && json.getAsJsonObject().has("base_ingredient")) {
            int c = json.getAsJsonObject().has("count") ? json.getAsJsonObject().get("count").getAsInt() : 1;
            return IngredientJS.of((Object)json.getAsJsonObject().get("base_ingredient")).withCount(c).asIngredientStack();
        }
        return IngredientJS.of((Object)json).asIngredientStack();
    }

    public IERecipeJS time(int t) {
        this.json.addProperty("time", (Number)t);
        this.save();
        return this;
    }

    public IERecipeJS energy(int e) {
        this.json.addProperty("energy", (Number)e);
        this.save();
        return this;
    }

    public ItemStackJS parseResultItem(@Nullable Object o) {
        JsonObject json;
        if (o instanceof JsonElement && ((JsonElement)o).isJsonObject() && ((json = ((JsonElement)o).getAsJsonObject()).has("base_ingredient") || json.has("tag"))) {
            return ItemStackJS.of((Object)IEApi.getPreferredStackbyMod((ItemStack[])IngredientWithSize.deserialize((JsonElement)json).getMatchingStacks()));
        }
        return super.parseResultItem(o);
    }
}

