/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.guis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.Controller;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.structure.CostList;
import me.towdium.jecalculation.data.structure.Recipe;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.guis.Gui;
import me.towdium.jecalculation.gui.guis.GuiLabel;
import me.towdium.jecalculation.gui.widgets.WButton;
import me.towdium.jecalculation.gui.widgets.WButtonIcon;
import me.towdium.jecalculation.gui.widgets.WButtonText;
import me.towdium.jecalculation.gui.widgets.WHelp;
import me.towdium.jecalculation.gui.widgets.WIcon;
import me.towdium.jecalculation.gui.widgets.WLabel;
import me.towdium.jecalculation.gui.widgets.WLabelScroll;
import me.towdium.jecalculation.gui.widgets.WLine;
import me.towdium.jecalculation.gui.widgets.WOverlay;
import me.towdium.jecalculation.gui.widgets.WPanel;
import me.towdium.jecalculation.gui.widgets.WSearch;
import me.towdium.jecalculation.gui.widgets.WSwitcher;
import me.towdium.jecalculation.gui.widgets.WText;
import me.towdium.jecalculation.gui.widgets.WTextField;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Pair;
import me.towdium.jecalculation.utils.wrappers.Trio;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class GuiRecipe
extends Gui {
    Pair<String, Integer> dest;
    WSwitcher group = new WSwitcher(7, 7, 162, Controller.getGroups()).setListener(i -> this.refresh());
    WTextField text = new WTextField(49, 25, 119);
    WLabelScroll catalyst = new WLabelScroll(25, 101, 7, 1, true).setLsnrScroll(GuiRecipe::handleLabelScroll);
    WLabelScroll input = new WLabelScroll(25, 123, 7, 2, true).setLsnrScroll(GuiRecipe::handleLabelScroll);
    WLabelScroll output = new WLabelScroll(25, 61, 7, 2, true).setLsnrScroll(GuiRecipe::handleLabelScroll);
    WButton clear = new WButtonIcon(64, 25, 20, 20, Resource.BTN_DEL, "recipe.clear").setListener(i -> this.reset());
    WButton copy = new WButtonIcon(83, 25, 20, 20, Resource.BTN_COPY, "recipe.copy").setListener(i -> {
        Controller.addRecipe(this.group.getText(), this.toRecipe());
        JecaGui.displayParent();
    });
    WButton label = new WButtonIcon(45, 25, 20, 20, Resource.BTN_LABEL, "recipe.label").setListener(i -> JecaGui.displayGui(new GuiLabel(l -> {
        JecaGui.displayParent();
        JecaGui.getCurrent().hand = l;
    })));
    WButton save = new WButtonIcon(26, 25, 20, 20, Resource.BTN_SAVE, "recipe.save").setDisabled(true).setListener(i -> {
        if (this.dest == null) {
            Controller.addRecipe(this.group.getText(), this.toRecipe());
        } else {
            String group = this.group.getText();
            if (group.equals(this.dest.one)) {
                Controller.setRecipe((String)this.dest.one, (Integer)this.dest.two, this.toRecipe());
            } else {
                Controller.setRecipe(group, (String)this.dest.one, (Integer)this.dest.two, this.toRecipe());
            }
        }
        JecaGui.displayParent();
    });
    WButton yes = new WButtonIcon(7, 25, 20, 20, Resource.BTN_YES, "recipe.confirm").setDisabled(true).setListener(i -> {
        this.group.setText(this.text.getText());
        this.text.setText("");
        this.setNewGroup(false);
        this.refresh();
    });
    WButton no = new WButtonIcon(26, 25, 20, 20, Resource.BTN_NO, "common.cancel").setListener(i -> this.setNewGroup(false));
    WButton neu = new WButtonIcon(7, 25, 20, 20, Resource.BTN_NEW, "recipe.new").setListener(i -> this.setNewGroup(true));
    EnumMap<Recipe.IO, Map<Integer, List<ILabel>>> disamb = new EnumMap(Recipe.IO.class);

    public GuiRecipe(String group, int index) {
        this();
        this.dest = new Pair<String, Integer>(group, index);
        Recipe r = Controller.getRecipe(group, index);
        for (Recipe.IO i : Recipe.IO.values()) {
            this.getWidget(i).setLabels(r.getLabel(i).stream().map(ILabel::copy).collect(Collectors.toList()));
        }
        this.group.setIndex(Controller.getGroups().indexOf(group));
        this.refresh();
    }

    public GuiRecipe() {
        for (Recipe.IO j : Recipe.IO.values()) {
            this.getWidget(j).setFmtAmount(i -> i.getAmountString(false)).setFmtTooltip((i, k) -> i.getToolTip((List<String>)k, true)).setLsnrClick((i, v) -> {
                ILabel l = i.get((int)v).getLabel();
                if (l != ILabel.EMPTY) {
                    this.setOverlay(new WAmount(j, (int)v));
                }
            }).setLsnrUpdate((i, v) -> {
                this.refresh();
                this.removeDisamb(j, (int)v);
            });
        }
        this.add(new WHelp("recipe"), new WPanel());
        this.add(new WIcon(7, 61, 18, 36, Resource.ICN_OUTPUT, "common.output"));
        this.add(new WIcon(7, 101, 18, 18, Resource.ICN_CATALYST, "common.catalyst"));
        this.add(new WIcon(7, 123, 18, 36, Resource.ICN_INPUT, "common.input"));
        this.add(new WLine(52));
        this.add(this.catalyst, this.input, this.output, this.group);
        if (this.group.getTexts().isEmpty()) {
            this.group.setText(Utilities.I18n.get("gui.common.default", new Object[0]));
        }
        String last = Controller.getLast();
        int index = -1;
        if (last != null) {
            index = this.group.getTexts().indexOf(last);
        }
        if (index != -1) {
            this.group.setIndex(index);
        }
        this.setNewGroup(false);
        this.copy.setDisabled(true);
        this.text.setListener(i -> this.yes.setDisabled(i.getText().isEmpty()));
    }

    public WLabelScroll getWidget(Recipe.IO type) {
        return Recipe.get(type, this.input, this.output, this.catalyst);
    }

    @Override
    public boolean onKeyPressed(JecaGui gui, int key, int modifier) {
        if (key == 256 && this.contains(this.text)) {
            this.setNewGroup(false);
            return true;
        }
        return super.onKeyPressed(gui, key, modifier);
    }

    @Override
    public boolean acceptsTransfer() {
        return true;
    }

    @Override
    public boolean acceptsLabel() {
        return true;
    }

    public void setNewGroup(boolean b) {
        if (b) {
            this.remove(this.neu, this.label, this.clear, this.copy, this.save);
            this.add(this.yes, this.no, this.text);
        } else {
            this.add(this.neu, this.label, this.clear, this.copy, this.save);
            this.remove(this.yes, this.no, this.text);
            this.text.setText("");
            this.yes.setDisabled(true);
        }
    }

    public void reset() {
        for (Recipe.IO i : Recipe.IO.values()) {
            this.getWidget(i).setLabels(new ArrayList<ILabel>());
        }
        this.disamb.clear();
        this.refresh();
    }

    public void transfer(EnumMap<Recipe.IO, List<Trio<ILabel, CostList, CostList>>> recipe, Class<?> context) {
        this.disamb.clear();
        for (Recipe.IO i : Recipe.IO.values()) {
            this.getWidget(i).setLabels(this.extract(recipe, i, context));
        }
        this.refresh();
    }

    private ArrayList<ILabel> extract(EnumMap<Recipe.IO, List<Trio<ILabel, CostList, CostList>>> src, Recipe.IO type, Class<?> context) {
        List<Trio<ILabel, CostList, CostList>> l = src.get((Object)type);
        ArrayList<ILabel> ret = new ArrayList<ILabel>();
        if (l == null) {
            return ret;
        }
        for (int i = 0; i < l.size(); ++i) {
            Trio<ILabel, CostList, CostList> p = l.get(i);
            ret.add((ILabel)p.one);
            if (((CostList)p.two).getLabels().size() <= 1) continue;
            List<ILabel> raw = ((CostList)p.two).getLabels();
            ArrayList<ILabel> suggest = new ArrayList<ILabel>();
            suggest.addAll((Collection)ILabel.CONVERTER.guess(raw, context).one);
            suggest.addAll(raw);
            this.disamb.computeIfAbsent(type, j -> new HashMap()).put(i, suggest);
        }
        return ret;
    }

    private List<ILabel> trim(List<ILabel> ls) {
        for (int i = ls.size() - 1; i >= 0; --i) {
            if (ls.get(i) != ILabel.EMPTY) continue;
            ls.remove(i);
        }
        return ls;
    }

    private Recipe toRecipe() {
        return new Recipe(this.trim(this.input.getLabels()), this.trim(this.catalyst.getLabels()), this.trim(this.output.getLabels()));
    }

    void refresh() {
        try {
            Recipe r = this.toRecipe();
            boolean d = this.dest == null ? Controller.hasDuplicate(r) : Controller.hasDuplicate(r, (String)this.dest.one, (Integer)this.dest.two);
            this.save.setDisabled(d);
            if (this.dest != null) {
                this.copy.setDisabled(d);
            }
        }
        catch (IllegalArgumentException e) {
            this.save.setDisabled(true);
            this.copy.setDisabled(true);
        }
    }

    private void removeDisamb(Recipe.IO type, int index) {
        Map<Integer, List<ILabel>> entry = this.disamb.get((Object)type);
        if (entry != null) {
            entry.remove(index);
        }
    }

    static boolean handleLabelScroll(WLabel w, int diff) {
        ILabel l = w.getLabel();
        for (int i = 0; i < Math.abs(diff); ++i) {
            l = diff > 0 ? l.increaseAmount() : l.decreaseAmount();
        }
        w.setLabel(l, true);
        return true;
    }

    class WDisamb
    extends WOverlay {
        WLabel temp;
        WLabelScroll content;
        WTextField search;

        public WDisamb(Recipe.IO type, int idx) {
            WLabelScroll list = GuiRecipe.this.getWidget(type);
            WLabel ref = list.get(idx);
            int x = ref.xPos;
            int y = ref.yPos;
            this.add(new WPanel(x - 7, y - 46, 111, 71));
            this.temp = new WLabel(x - 1, y - 1, 20, 20, false);
            this.temp.setLabel(ref.getLabel().copy());
            this.content = new WLabelScroll(x + 8, y - 40, 4, 2, false).setLabels(GuiRecipe.this.disamb.get((Object)type).get(idx)).setLsnrClick((i, v) -> {
                list.setLabel(idx, i.get((int)v).getLabel().copy().multiply(-1.0f));
                GuiRecipe.this.setOverlay(null);
                GuiRecipe.this.refresh();
            });
            this.add(new WIcon(x + 22, y - 1, 20, 20, Resource.ICN_TEXT, "common.search"));
            this.search = new WSearch(x + 42, y - 1, 56, this.content);
            this.add(this.temp, this.content, this.search);
        }
    }

    class WAmount
    extends WOverlay {
        WLabel temp;
        WButton number;
        WTextField text;
        WButton percent;
        WButton pick;
        WButton yes;
        WButton no;
        WButton disamb;
        WLabel ref;

        public WAmount(Recipe.IO type, int idx) {
            this.ref = GuiRecipe.this.getWidget(type).get(idx);
            int x = this.ref.xPos;
            int y = this.ref.yPos;
            this.number = new WButtonText(x + 78, y - 1, 20, 20, "#", "recipe.to_percent").setListener(i -> {
                this.temp.getLabel().setPercent(true);
                this.update();
            });
            this.percent = new WButtonText(x + 78, y - 1, 20, 20, "%", "recipe.to_amount").setListener(i -> {
                this.temp.getLabel().setPercent(false);
                this.update();
            });
            this.temp = new WLabel(x - 1, y - 1, 20, 20, true).setLsnrUpdate((i, v) -> this.update());
            this.temp.setLabel(this.ref.getLabel().copy());
            this.add(new WPanel(x - 7, y - 30, 111, 55));
            this.add(new WText(x + 21, y + 5, JecaGui.Font.PLAIN, "x"));
            this.text = new WTextField(x + 28, y + 9 - 10, 50);
            this.pick = new WButtonIcon(x + 21, y - 24, 20, 20, Resource.BTN_PICK, "recipe.pick").setListener(i -> {
                JecaGui.getCurrent().hand = this.temp.getLabel();
                this.set(ILabel.EMPTY, type, idx);
            });
            this.yes = new WButtonIcon(x + 59, y - 24, 20, 20, Resource.BTN_YES, "recipe.confirm").setListener(i -> this.set(this.temp.getLabel(), type, idx));
            this.no = new WButtonIcon(x + 78, y - 24, 20, 20, Resource.BTN_NO, "recipe.delete").setListener(i -> this.set(ILabel.EMPTY, type, idx));
            this.disamb = new WButtonIcon(x + 40, y - 24, 20, 20, Resource.BTN_DISAMB, "recipe.disamb");
            Map<Integer, List<ILabel>> entry = GuiRecipe.this.disamb.get((Object)type);
            if (entry != null && entry.containsKey(idx)) {
                this.disamb.setListener(i -> GuiRecipe.this.setOverlay(new WDisamb(type, idx)));
            } else {
                this.disamb.setDisabled(true);
            }
            this.add(this.temp, this.text, this.pick, this.yes, this.no, this.disamb);
            this.text.setListener(i -> {
                boolean acceptable;
                long amount;
                try {
                    amount = Long.parseLong(this.text.getText());
                    boolean bl = acceptable = amount > 0L;
                    if (!acceptable) {
                        amount = 1L;
                    }
                }
                catch (NumberFormatException e) {
                    acceptable = this.text.getText().isEmpty();
                    amount = 1L;
                }
                this.text.setColor(acceptable ? 0xFFFFFF : 0xFF0000);
                this.yes.setDisabled(!acceptable);
                this.temp.setLabel(this.temp.getLabel().setAmount(amount));
            });
            this.update();
        }

        private void set(ILabel l, Recipe.IO type, int idx) {
            this.ref.setLabel(l, true);
            GuiRecipe.this.removeDisamb(type, idx);
            GuiRecipe.this.setOverlay(null);
        }

        private void update() {
            this.number.setDisabled(!this.temp.getLabel().acceptPercent());
            if (this.temp.getLabel().isPercent()) {
                this.remove(this.number);
                this.add(this.percent);
            } else {
                this.remove(this.percent);
                this.add(this.number);
            }
            this.text.setText(Long.toString(this.temp.getLabel().getAmount()));
        }
    }
}

