/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class Recipe {
    public static final String KEY_INPUT = "input";
    public static final String KEY_CATALYST = "catalyst";
    public static final String KEY_OUTPUT = "output";
    List<ILabel> input;
    List<ILabel> catalyst;
    List<ILabel> output;

    public Recipe(CompoundNBT nbt) {
        this(Recipe.readNbtList(nbt.func_150295_c(KEY_INPUT, 10)), Recipe.readNbtList(nbt.func_150295_c(KEY_CATALYST, 10)), Recipe.readNbtList(nbt.func_150295_c(KEY_OUTPUT, 10)));
    }

    public Recipe(List<ILabel> input, List<ILabel> catalyst, List<ILabel> output) {
        boolean a = Stream.of(input, output, catalyst).anyMatch(i -> !i.isEmpty() && i.get(i.size() - 1) == ILabel.EMPTY);
        boolean b = Stream.of(input, output).anyMatch(i -> i.stream().allMatch(j -> j == ILabel.EMPTY));
        if (a || b) {
            throw new IllegalArgumentException("Invalid recipe");
        }
        this.input = input;
        this.catalyst = catalyst;
        this.output = output;
    }

    private static List<ILabel> readNbtList(ListNBT list) {
        return list.stream().filter(n -> n instanceof CompoundNBT).map(n -> ILabel.SERIALIZER.deserialize((CompoundNBT)n)).collect(Collectors.toList());
    }

    public int hashCode() {
        int[] hash = new int[1];
        Consumer<List> hasher = ls -> ls.stream().filter(Objects::nonNull).forEach(i -> {
            hash[0] = hash[0] ^ i.hashCode();
        });
        hasher.accept(this.input);
        hasher.accept(this.catalyst);
        hasher.accept(this.output);
        return hash[0];
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Recipe)) {
            return false;
        }
        Recipe r = (Recipe)obj;
        BiPredicate<List, List> p = (i, j) -> {
            if (i.size() != j.size()) {
                return false;
            }
            for (int k = 0; k < i.size(); ++k) {
                if (((ILabel)i.get(k)).equals(j.get(k))) continue;
                return false;
            }
            return true;
        };
        return p.test(this.input, r.input) && p.test(this.catalyst, r.catalyst) && p.test(this.output, r.output);
    }

    public List<ILabel> getLabel(IO type) {
        return Recipe.get(type, this.input, this.output, this.catalyst);
    }

    public static <T> T get(IO type, T input, T output, T catalyst) {
        switch (type) {
            case INPUT: {
                return input;
            }
            case OUTPUT: {
                return output;
            }
            case CATALYST: {
                return catalyst;
            }
        }
        throw new RuntimeException("Internal error");
    }

    public ILabel getRep() {
        for (int i = 0; i < 8; ++i) {
            if (this.output.get(i) == ILabel.EMPTY) continue;
            return this.output.get(i);
        }
        return ILabel.EMPTY;
    }

    public CompoundNBT serialize() {
        CompoundNBT ret = new CompoundNBT();
        Function<List, ListNBT> convert = ls -> {
            ArrayList labels = new ArrayList();
            boolean start = false;
            for (int i = ls.size() - 1; i >= 0; --i) {
                if (!start && ls.get(i) == ILabel.EMPTY) continue;
                labels.add(ls.get(i));
                start = true;
            }
            ListNBT r = new ListNBT();
            new Utilities.ReversedIterator(labels).stream().forEach(l -> r.add((Object)ILabel.SERIALIZER.serialize((ILabel)l)));
            return r;
        };
        ret.func_218657_a(KEY_INPUT, (INBT)convert.apply(this.input));
        ret.func_218657_a(KEY_CATALYST, (INBT)convert.apply(this.catalyst));
        ret.func_218657_a(KEY_OUTPUT, (INBT)convert.apply(this.output));
        return ret;
    }

    public Optional<ILabel> matches(ILabel label) {
        return this.output.stream().filter(i -> ILabel.MERGER.merge(label, (ILabel)i).isPresent()).findAny();
    }

    public long multiplier(ILabel label) {
        return this.output.stream().filter(i -> ILabel.MERGER.merge(label, (ILabel)i).isPresent()).findAny().map(i -> {
            long amountA = label.getAmount();
            if (!label.isPercent()) {
                amountA = Math.multiplyExact(amountA, 100L);
            }
            long amountB = i.getAmount();
            if (!i.isPercent()) {
                amountB = Math.multiplyExact(amountB, 100L);
            }
            return (amountB + Math.abs(amountA) - 1L) / amountB;
        }).orElse(0L);
    }

    public static enum IO {
        INPUT,
        OUTPUT,
        CATALYST;


        public static IO isInput(boolean b) {
            return b ? INPUT : OUTPUT;
        }
    }
}

