/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label.labels;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.label.labels.LContext;
import me.towdium.jecalculation.data.label.labels.LItemStack;
import me.towdium.jecalculation.data.label.labels.LStack;
import me.towdium.jecalculation.utils.wrappers.Wrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class LTag<T>
extends LContext<T> {
    public static final String KEY_NAME = "name";
    protected ResourceLocation name;

    public LTag(ResourceLocation name) {
        this(name, 1L);
    }

    public LTag(ResourceLocation name, long amount) {
        super(amount, false);
        this.name = name;
    }

    public LTag(LTag<T> lt) {
        super(lt);
        this.name = lt.name;
    }

    public LTag(CompoundNBT nbt) {
        super(nbt);
        this.name = new ResourceLocation(nbt.func_74779_i(KEY_NAME));
    }

    public static boolean mergeSame(ILabel a, ILabel b) {
        if (a instanceof LTag && b instanceof LTag) {
            LTag lodA = (LTag)a;
            LTag lodB = (LTag)b;
            return lodA.getName().equals(lodB.getName()) && lodA.getContext() == lodB.getContext();
        }
        return false;
    }

    public static boolean mergeFuzzy(ILabel a, ILabel b) {
        if (a instanceof LTag && b instanceof LStack) {
            LTag lt = (LTag)a;
            LStack ls = (LStack)b;
            return lt.getAmount() * ls.getAmount() < 0L && lt.getContext().matches(lt.name, ls);
        }
        return false;
    }

    public static List<ILabel> suggest(List<ILabel> is, @Nullable Class<?> context) {
        return LTag.convert(is, true);
    }

    private static <T> List<ILabel> convert(List<ILabel> is, boolean biDir) {
        List iss = is.stream().filter(i -> i instanceof LStack).map(i -> (LStack)i).collect(Collectors.toList());
        if (iss.isEmpty() || iss.size() != is.size()) {
            return Collections.emptyList();
        }
        LStack lis = (LStack)iss.get(0);
        if (iss.stream().anyMatch(i -> i.getContext() != ((LStack)iss.get(0)).getContext())) {
            return Collections.emptyList();
        }
        HashSet<ResourceLocation> ids = new HashSet<ResourceLocation>();
        long amount = lis.getAmount();
        for (ResourceLocation i2 : lis.getContext().discover(lis)) {
            if (!LTag.check(i2, iss, biDir)) continue;
            ids.add(i2);
        }
        return ids.stream().map(i -> lis.getContext().create((ResourceLocation)i, amount)).collect(Collectors.toList());
    }

    public static List<ILabel> fallback(List<ILabel> is, @Nullable Class<?> context) {
        return LTag.convert(is, false);
    }

    private static <T> boolean check(ResourceLocation id, List<LStack<T>> labels, boolean biDir) {
        Stream<LStack<LStack>> ores = labels.get(0).getContext().discover(id);
        ITag tag = ItemTags.func_199903_a().func_199910_a(id);
        if (tag == null) {
            return false;
        }
        Wrapper<Boolean> acceptable = new Wrapper<Boolean>(true);
        if (biDir) {
            ores.filter(ore -> labels.stream().noneMatch(ore::matches)).findAny().ifPresent(i -> {
                acceptable.value = false;
                Object cfr_ignored_0 = acceptable.value;
            });
        }
        labels.stream().filter(label -> label instanceof LItemStack).filter(label -> !tag.func_230235_a_((Object)((LItemStack)label).item)).findAny().ifPresent(i -> {
            acceptable.value = false;
            Object cfr_ignored_0 = acceptable.value;
        });
        return (Boolean)acceptable.value;
    }

    @Override
    public Object getRepresentation() {
        List list = this.getContext().discover(this.name).collect(Collectors.toList());
        if (list.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        long index = System.currentTimeMillis() / 1500L;
        return ((LStack)list.get((int)(index % (long)list.size()))).getRepresentation();
    }

    @Override
    public boolean matches(Object l) {
        if (!(l instanceof LTag)) {
            return false;
        }
        LTag tag = (LTag)l;
        return tag.getContext() == this.getContext() && tag.name.equals((Object)this.name) && super.matches(l);
    }

    @Override
    public abstract LTag<T> copy();

    @Override
    public CompoundNBT toNbt() {
        CompoundNBT ret = super.toNbt();
        ret.func_74778_a(KEY_NAME, this.name.toString());
        return ret;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getToolTip(List<String> existing, boolean detailed) {
        super.getToolTip(existing, detailed);
        existing.add("\u00a79\u00a7oJust Enough Calculation");
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() ^ super.hashCode();
    }

    public String getName() {
        return this.name.toString();
    }
}

