/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label.labels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.label.labels.Context;
import me.towdium.jecalculation.data.label.labels.LStack;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LFluidStack
extends LStack<Fluid> {
    public static final String IDENTIFIER = "fluidStack";
    public static final String KEY_FLUID = "fluid";
    public static final String KEY_NBT = "nbt";
    Fluid fluid;
    CompoundNBT nbt;
    FluidStack temp;
    private static final String TIC_CLASS = "slimeknights.tconstruct.plugin.jei.casting.CastingRecipeCategory";

    public FluidStack getRepresentation() {
        return this.temp;
    }

    @Override
    public boolean acceptPercent() {
        return false;
    }

    public LFluidStack(FluidStack fs) {
        this(fs.getAmount(), fs.getFluid(), fs.getTag());
    }

    public LFluidStack(long amount, Fluid fluid) {
        this(amount, fluid, null);
    }

    public LFluidStack(long amount, Fluid fluid, @Nullable CompoundNBT nbt) {
        super(amount, false);
        this.init(fluid, nbt);
    }

    public LFluidStack(CompoundNBT nbt) {
        super(nbt);
        String id = nbt.func_74779_i(KEY_FLUID);
        Fluid f = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(id));
        if (f == null) {
            throw new ILabel.Serializer.SerializationException("Fluid " + id + " cannot be resolved, ignoring");
        }
        this.init(f, nbt.func_74764_b(KEY_NBT) ? nbt.func_74775_l(KEY_NBT) : null);
    }

    @Override
    public Fluid get() {
        return this.fluid;
    }

    @Override
    public Context<Fluid> getContext() {
        return Context.FLUID;
    }

    private void init(Fluid fluid, @Nullable CompoundNBT nbt) {
        this.fluid = fluid;
        this.nbt = nbt;
        this.temp = new FluidStack(fluid, 1, nbt);
    }

    public LFluidStack(LFluidStack lfs) {
        super(lfs);
        this.fluid = lfs.fluid;
        this.nbt = lfs.nbt;
        this.temp = lfs.temp;
    }

    @Override
    protected int getMultiplier() {
        return 100;
    }

    @Override
    public String getAmountString(boolean round) {
        return LFluidStack.format(this.amount);
    }

    public static String format(long amount) {
        return amount >= 1000L ? Utilities.cutNumber((float)amount / 1000.0f, 4) + "B" : amount + "mB";
    }

    @Override
    public String getDisplayName() {
        return this.temp.getDisplayName().getString();
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean matches(Object l) {
        if (l instanceof LFluidStack) {
            LFluidStack lfs = (LFluidStack)l;
            return Objects.equals(this.nbt, lfs.nbt) && this.fluid == lfs.fluid;
        }
        return false;
    }

    @Override
    public LFluidStack copy() {
        return new LFluidStack(this);
    }

    @Override
    public CompoundNBT toNbt() {
        CompoundNBT ret = super.toNbt();
        ret.func_74778_a(KEY_FLUID, ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)this.fluid).toString());
        if (this.nbt != null) {
            ret.func_218657_a(KEY_NBT, (INBT)this.nbt);
        }
        return ret;
    }

    @Override
    public void getToolTip(List<String> existing, boolean detailed) {
        existing.add("\u00a79\u00a7o" + Utilities.getModName(this.fluid));
    }

    @Override
    public void drawLabel(JecaGui gui) {
        gui.drawResource(Resource.LBL_FLUID, 0, 0);
        gui.drawFluid(this.fluid, 2, 2, 12, 12);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.fluid.getRegistryName().hashCode() ^ (this.nbt == null ? 0 : this.nbt.hashCode());
    }

    public static List<ILabel> suggest(List<ILabel> iss, @Nullable Class<?> context) {
        if (context != null && context.getName().equals(TIC_CLASS) && iss.get(0) instanceof LFluidStack) {
            return Collections.singletonList(iss.get(0).copy().multiply(0.5f));
        }
        return new ArrayList<ILabel>();
    }

    public static boolean merge(ILabel a, ILabel b) {
        if (a instanceof LFluidStack && b instanceof LFluidStack) {
            return a.matches(b);
        }
        return false;
    }
}

