/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label.labels;

import java.util.Collection;
import java.util.stream.Stream;
import me.towdium.jecalculation.data.label.labels.LFluidStack;
import me.towdium.jecalculation.data.label.labels.LFluidTag;
import me.towdium.jecalculation.data.label.labels.LItemStack;
import me.towdium.jecalculation.data.label.labels.LItemTag;
import me.towdium.jecalculation.data.label.labels.LStack;
import me.towdium.jecalculation.data.label.labels.LTag;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public interface Context<T> {
    public static final Context<Item> ITEM = new Context<Item>(){

        @Override
        public LStack<Item> create(Item item) {
            return new LItemStack(new ItemStack((IItemProvider)item));
        }

        @Override
        public ITagCollection<Item> tags() {
            return ItemTags.func_199903_a();
        }

        @Override
        public LTag<Item> create(ResourceLocation rl) {
            return new LItemTag(rl);
        }

        @Override
        public LTag<Item> create(ResourceLocation rl, long amount) {
            return new LItemTag(rl, amount);
        }
    };
    public static final Context<Fluid> FLUID = new Context<Fluid>(){

        @Override
        public LStack<Fluid> create(Fluid fluid) {
            return new LFluidStack(new FluidStack(fluid, 1000));
        }

        @Override
        public ITagCollection<Fluid> tags() {
            return FluidTags.func_226157_a_();
        }

        @Override
        public LTag<Fluid> create(ResourceLocation rl) {
            return new LFluidTag(rl);
        }

        @Override
        public LTag<Fluid> create(ResourceLocation rl, long amount) {
            return new LFluidTag(rl, amount);
        }
    };

    public LStack<T> create(T var1);

    public ITagCollection<T> tags();

    public LTag<T> create(ResourceLocation var1);

    public LTag<T> create(ResourceLocation var1, long var2);

    default public Collection<ResourceLocation> discover(LStack<T> s) {
        return this.tags().func_199913_a(s.get());
    }

    default public Stream<LStack<T>> discover(ResourceLocation tag) {
        ITag records = this.tags().func_199910_a(tag);
        return records == null ? Stream.empty() : records.func_230236_b_().stream().map(this::create);
    }

    default public boolean matches(ResourceLocation tag, LStack<?> t) {
        ITag records = this.tags().func_199910_a(tag);
        return records != null && t.getContext() == this && records.func_230235_a_(t.get());
    }
}

