/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITargetedTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TranslationTextComponentFormatException;

public class TranslationTextComponent
extends TextComponent
implements ITargetedTextComponent {
    private static final Object[] field_240753_d_ = new Object[0];
    private static final ITextProperties field_240754_e_ = ITextProperties.func_240652_a_("%");
    private static final ITextProperties field_240755_f_ = ITextProperties.func_240652_a_("null");
    private final String field_150276_d;
    private final Object[] field_150277_e;
    @Nullable
    private LanguageMap field_240756_i_;
    private final List<ITextProperties> field_150278_b = Lists.newArrayList();
    private static final Pattern field_150279_c = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public TranslationTextComponent(String string) {
        this.field_150276_d = string;
        this.field_150277_e = field_240753_d_;
    }

    public TranslationTextComponent(String string, Object ... objectArray) {
        this.field_150276_d = string;
        this.field_150277_e = objectArray;
    }

    private void func_150270_g() {
        LanguageMap languageMap = LanguageMap.func_74808_a();
        if (languageMap == this.field_240756_i_) {
            return;
        }
        this.field_240756_i_ = languageMap;
        this.field_150278_b.clear();
        String \u26032 = languageMap.func_230503_a_(this.field_150276_d);
        try {
            this.func_240758_a_(\u26032);
        }
        catch (TranslationTextComponentFormatException \u26033) {
            this.field_150278_b.clear();
            this.field_150278_b.add(ITextProperties.func_240652_a_(\u26032));
        }
    }

    private void func_240758_a_(String string) {
        Matcher matcher = field_150279_c.matcher(string);
        try {
            int n;
            int n2 = 0;
            n = 0;
            while (matcher.find(n)) {
                int n3;
                String \u26032;
                \u2603 = matcher.start();
                n3 = matcher.end();
                if (\u2603 > n) {
                    \u26032 = string.substring(n, \u2603);
                    if (\u26032.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    this.field_150278_b.add(ITextProperties.func_240652_a_(\u26032));
                }
                \u26032 = matcher.group(2);
                String \u26033 = string.substring(\u2603, n3);
                if ("%".equals(\u26032) && "%%".equals(\u26033)) {
                    this.field_150278_b.add(field_240754_e_);
                } else if ("s".equals(\u26032)) {
                    String string2 = matcher.group(1);
                    int n4 = \u2603 = string2 != null ? Integer.parseInt(string2) - 1 : n2++;
                    if (\u2603 < this.field_150277_e.length) {
                        this.field_150278_b.add(this.func_240757_a_(\u2603));
                    }
                } else {
                    throw new TranslationTextComponentFormatException(this, "Unsupported format: '" + \u26033 + "'");
                }
                n = n3;
            }
            if (n < string.length()) {
                String string3 = string.substring(n);
                if (string3.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                this.field_150278_b.add(ITextProperties.func_240652_a_(string3));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TranslationTextComponentFormatException(this, (Throwable)illegalArgumentException);
        }
    }

    private ITextProperties func_240757_a_(int n) {
        if (n >= this.field_150277_e.length) {
            throw new TranslationTextComponentFormatException(this, n);
        }
        Object object = this.field_150277_e[n];
        if (object instanceof ITextComponent) {
            return (ITextComponent)object;
        }
        return object == null ? field_240755_f_ : ITextProperties.func_240652_a_(object.toString());
    }

    @Override
    public TranslationTextComponent func_230531_f_() {
        return new TranslationTextComponent(this.field_150276_d, this.field_150277_e);
    }

    @Override
    public <T> Optional<T> func_230533_b_(ITextProperties.ITextAcceptor<T> iTextAcceptor) {
        this.func_150270_g();
        for (ITextProperties iTextProperties : this.field_150278_b) {
            Optional<T> optional = iTextProperties.func_230438_a_(iTextAcceptor);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public IFormattableTextComponent func_230535_a_(@Nullable CommandSource commandSource, @Nullable Entity entity, int n) throws CommandSyntaxException {
        Object[] objectArray = new Object[this.field_150277_e.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = this.field_150277_e[i];
            objectArray[i] = object instanceof ITextComponent ? TextComponentUtils.func_240645_a_(commandSource, (ITextComponent)object, entity, n) : object;
        }
        return new TranslationTextComponent(this.field_150276_d, objectArray);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TranslationTextComponent) {
            TranslationTextComponent translationTextComponent = (TranslationTextComponent)object;
            return Arrays.equals(this.field_150277_e, translationTextComponent.field_150277_e) && this.field_150276_d.equals(translationTextComponent.field_150276_d) && super.equals(object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.field_150276_d.hashCode();
        n = 31 * n + Arrays.hashCode(this.field_150277_e);
        return n;
    }

    @Override
    public String toString() {
        return "TranslatableComponent{key='" + this.field_150276_d + '\'' + ", args=" + Arrays.toString(this.field_150277_e) + ", siblings=" + this.field_150264_a + ", style=" + this.func_150256_b() + '}';
    }

    public String func_150268_i() {
        return this.field_150276_d;
    }

    public Object[] func_150271_j() {
        return this.field_150277_e;
    }

    @Override
    public /* synthetic */ TextComponent func_230531_f_() {
        return this.func_230531_f_();
    }

    @Override
    public /* synthetic */ IFormattableTextComponent func_230531_f_() {
        return this.func_230531_f_();
    }
}

