/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.profiler.IProfileResult;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugCommand {
    private static final Logger field_225390_a = LogManager.getLogger();
    private static final SimpleCommandExceptionType field_198338_b = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.debug.notRunning"));
    private static final SimpleCommandExceptionType field_198339_c = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.debug.alreadyRunning"));
    @Nullable
    private static final FileSystemProvider field_225391_d = FileSystemProvider.installedProviders().stream().filter(fileSystemProvider -> fileSystemProvider.getScheme().equalsIgnoreCase("jar")).findFirst().orElse(null);

    public static void func_198330_a(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("debug").requires(commandSource -> commandSource.func_197034_c(3))).then(Commands.func_197057_a("start").executes(commandContext -> DebugCommand.func_198335_a((CommandSource)commandContext.getSource())))).then(Commands.func_197057_a("stop").executes(commandContext -> DebugCommand.func_198336_b((CommandSource)commandContext.getSource())))).then(Commands.func_197057_a("report").executes(commandContext -> DebugCommand.func_225389_c((CommandSource)commandContext.getSource()))));
    }

    private static int func_198335_a(CommandSource commandSource) throws CommandSyntaxException {
        MinecraftServer minecraftServer = commandSource.func_197028_i();
        if (minecraftServer.func_240789_aP_()) {
            throw field_198339_c.create();
        }
        minecraftServer.func_240790_aQ_();
        commandSource.func_197030_a(new TranslationTextComponent("commands.debug.started", "Started the debug profiler. Type '/debug stop' to stop it."), true);
        return 0;
    }

    private static int func_198336_b(CommandSource commandSource) throws CommandSyntaxException {
        MinecraftServer minecraftServer = commandSource.func_197028_i();
        if (!minecraftServer.func_240789_aP_()) {
            throw field_198338_b.create();
        }
        IProfileResult \u26032 = minecraftServer.func_240791_aR_();
        File \u26033 = new File(minecraftServer.func_71209_f("debug"), "profile-results-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + ".txt");
        \u26032.func_219919_a(\u26033);
        float \u26034 = (float)\u26032.func_219924_f() / 1.0E9f;
        float \u26035 = (float)\u26032.func_219925_g() / \u26034;
        commandSource.func_197030_a(new TranslationTextComponent("commands.debug.stopped", String.format(Locale.ROOT, "%.2f", Float.valueOf(\u26034)), \u26032.func_219925_g(), String.format("%.2f", Float.valueOf(\u26035))), true);
        return MathHelper.func_76141_d(\u26035);
    }

    private static int func_225389_c(CommandSource commandSource2) {
        MinecraftServer minecraftServer = commandSource2.func_197028_i();
        String \u26032 = "debug-report-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
        try {
            CommandSource commandSource2;
            Path path = minecraftServer.func_71209_f("debug").toPath();
            Files.createDirectories(path, new FileAttribute[0]);
            if (SharedConstants.field_206244_b || field_225391_d == null) {
                \u2603 = path.resolve(\u26032);
                minecraftServer.func_223711_a(\u2603);
            } else {
                \u2603 = path.resolve(\u26032 + ".zip");
                try (FileSystem fileSystem = field_225391_d.newFileSystem(\u2603, (Map<String, ?>)ImmutableMap.of((Object)"create", (Object)"true"));){
                    minecraftServer.func_223711_a(fileSystem.getPath("/", new String[0]));
                }
            }
            commandSource2.func_197030_a(new TranslationTextComponent("commands.debug.reportSaved", \u26032), false);
            return 1;
        }
        catch (IOException iOException) {
            field_225390_a.error("Failed to save debug dump", (Throwable)iOException);
            commandSource2.func_197021_a(new TranslationTextComponent("commands.debug.reportFailed"));
            return 0;
        }
    }
}

