/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.enviroenergyapi.impl.storage;

import com.valkyrieofnight.enviroenergyapi.api.Energy;
import com.valkyrieofnight.enviroenergyapi.api.storage.IEEStorage;
import net.minecraft.nbt.CompoundNBT;

public class DynamicEnergyStorage
implements IEEStorage {
    protected final int voltage;
    protected int current;
    protected int currentCapacity;
    protected int currentReceiveMax;
    protected int currentExtractMax;

    public DynamicEnergyStorage(int voltage) {
        this(voltage, 1, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public DynamicEnergyStorage(int voltage, int maxCurrent) {
        this(voltage, maxCurrent, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public DynamicEnergyStorage(int voltage, int maxCurrent, int maxTransferCurrent) {
        this(voltage, maxCurrent, maxTransferCurrent, maxTransferCurrent);
    }

    public DynamicEnergyStorage(int voltage, int maxCurrent, int maxCurrentReceive, int maxCurrentExtract) {
        this.voltage = voltage;
        this.current = 0;
        this.currentCapacity = maxCurrent;
        this.currentReceiveMax = maxCurrentReceive;
        this.currentExtractMax = maxCurrentExtract;
    }

    @Override
    public Energy extractEnergy(Energy requested, boolean sim) {
        if (requested == null || requested.getVoltage() != this.voltage) {
            return Energy.ZERO;
        }
        Energy req = Energy.minCurrent(new Energy(this.voltage, this.current), requested);
        if (!sim) {
            this.current -= req.getCurrent();
        }
        return req;
    }

    @Override
    public Energy getMaxExtract() {
        return new Energy(this.voltage, Math.min(this.getCurrentStored(), this.currentExtractMax));
    }

    @Override
    public int getExtractVoltage() {
        return this.voltage;
    }

    @Override
    public Energy receiveEnergy(Energy provided, boolean sim) {
        if (provided == null || provided.getVoltage() != this.voltage) {
            return Energy.ZERO;
        }
        Energy pro = Energy.minCurrent(new Energy(this.voltage, this.getCurrentRoom()), provided);
        if (!sim) {
            this.current += pro.getCurrent();
        }
        return pro;
    }

    @Override
    public Energy getMaxReceive() {
        return new Energy(this.voltage, Math.min(this.getCurrentRoom(), this.currentReceiveMax));
    }

    @Override
    public int getReceiveVoltage() {
        return this.voltage;
    }

    @Override
    public int getCurrentStored() {
        return this.current;
    }

    @Override
    public int getCurrentCapacity() {
        return this.currentCapacity;
    }

    public void setCurrentCapacity(int currentCapacity) {
        this.currentCapacity = currentCapacity;
    }

    public void setCurrentTransferRate(int transferRate) {
        this.currentReceiveMax = transferRate;
        this.currentExtractMax = transferRate;
    }

    public void setCurrentTransferRate(int receiveMax, int extractMax) {
        this.currentReceiveMax = receiveMax;
        this.currentExtractMax = extractMax;
    }

    @Override
    public void deserializeNBT(CompoundNBT tag) {
        this.current = tag.func_74764_b("stored") ? tag.func_74762_e("stored") : this.current;
        this.currentCapacity = tag.func_74764_b("capacity") ? tag.func_74762_e("capacity") : this.currentCapacity;
        this.currentReceiveMax = tag.func_74764_b("receive") ? tag.func_74762_e("receive") : this.currentReceiveMax;
        this.currentExtractMax = tag.func_74764_b("extract") ? tag.func_74762_e("extract") : this.currentExtractMax;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("stored", this.current);
        tag.func_74768_a("capacity", this.currentCapacity);
        tag.func_74768_a("receive", this.currentReceiveMax);
        tag.func_74768_a("extract", this.currentExtractMax);
        return tag;
    }

    @Override
    public int getCurrentRoom() {
        return this.currentCapacity - this.current;
    }
}

