/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.m_machines.m_assembler.datapack;

import com.google.common.collect.Lists;
import com.valkyrieofnight.envirocore.integration.jei.IJEIProviderBlock;
import com.valkyrieofnight.envirocore.integration.jei.categories.AssemblerRecipeCategory;
import com.valkyrieofnight.envirocore.m_machines.m_assembler.datapack.AssemblerRecipe;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.modloader.util.SideUtil;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.recipe.VLRecipeRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class AssemblerRecipeRegistry
extends VLRecipeRegistry<AssemblerRecipe> {
    private List<AssemblerRecipe> recipeList = Lists.newCopyOnWriteArrayList();

    public AssemblerRecipeRegistry() {
        super("envirocore", "assembler", AssemblerRecipe.class);
    }

    protected void clearForNewData() {
        this.recipeList = Lists.newCopyOnWriteArrayList();
    }

    public Collection<AssemblerRecipe> getAllRecipes(VLID vlid) {
        return this.recipeList;
    }

    public Collection<AssemblerRecipe> getRecipesWithInput(VLID vlid, ConditionContainerProvider conditionContainerProvider, Object o) {
        ArrayList recipes = Lists.newArrayList();
        if (o instanceof ItemStack) {
            ItemStack i = (ItemStack)o;
            Block b = Block.func_149634_a((Item)i.func_77973_b());
            if (b instanceof IJEIProviderBlock && AssemblerRecipeCategory.ID.equals((Object)((IJEIProviderBlock)b).getCategoryID())) {
                return this.recipeList;
            }
            for (AssemblerRecipe r : this.getAllRecipes(vlid)) {
                if (!r.isPossibleInput(conditionContainerProvider, i)) continue;
                recipes.add(r);
            }
        }
        return recipes;
    }

    public Collection<AssemblerRecipe> getRecipesWithOutput(VLID vlid, ConditionContainerProvider conditionContainerProvider, Object o) {
        ArrayList recipes = Lists.newArrayList();
        if (o instanceof ItemStack) {
            ItemStack i = (ItemStack)o;
            for (AssemblerRecipe r : this.getAllRecipes(vlid)) {
                if (!r.isPossibleOut(conditionContainerProvider, i)) continue;
                recipes.add(r);
            }
        }
        return recipes;
    }

    public boolean hasRecipeWithInput(VLID vlid, ConditionContainerProvider conditionContainerProvider, Object o) {
        if (o instanceof ItemStack[]) {
            ItemStack[] ins = (ItemStack[])o;
            for (ItemStack i : ins) {
                Block b = Block.func_149634_a((Item)i.func_77973_b());
                if (!(b instanceof IJEIProviderBlock) || !AssemblerRecipeCategory.ID.equals((Object)((IJEIProviderBlock)b).getCategoryID())) continue;
                return true;
            }
            if (ins.length == 5) {
                for (AssemblerRecipe r : this.getAllRecipes(vlid)) {
                    if (!r.testPopulatedInputs(conditionContainerProvider, ins[0], ins[1], ins[2], ins[3], ins[4])) continue;
                    return true;
                }
            }
        }
        if (o instanceof ItemStack) {
            ItemStack i = (ItemStack)o;
            for (AssemblerRecipe r : this.getAllRecipes(vlid)) {
                if (!r.isPossibleInput(conditionContainerProvider, i)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRecipeWithOutput(VLID vlid, ConditionContainerProvider conditionContainerProvider, Object o) {
        if (o instanceof ItemStack) {
            ItemStack i = (ItemStack)o;
            for (AssemblerRecipe r : this.getAllRecipes(vlid)) {
                if (!r.isPossibleOut(conditionContainerProvider, i)) continue;
                return true;
            }
        }
        return false;
    }

    protected void loadDataIntoRegistry(Map<VLID, AssemblerRecipe> map) {
        if (SideUtil.isClient()) {
            // empty if block
        }
        if (map == null || map.isEmpty()) {
            return;
        }
        map.values().stream().filter(mwr -> mwr != null).forEach(this.recipeList::add);
    }

    protected AssemblerRecipe mergeNoOverride(AssemblerRecipe assemblerRecipe, AssemblerRecipe recipe_type1) {
        return assemblerRecipe;
    }

    public AssemblerRecipe getRecipe(ConditionContainerProvider conditionProvider, ItemStack stackInSlot, ItemStack stackInSlot1, ItemStack stackInSlot2, ItemStack stackInSlot3, ItemStack stackInSlot4) {
        for (AssemblerRecipe ar : this.recipeList) {
            if (!ar.testInputs(conditionProvider, stackInSlot, stackInSlot1, stackInSlot2, stackInSlot3, stackInSlot4)) continue;
            return ar;
        }
        return null;
    }

    public Collection<AssemblerRecipe> getRecipes() {
        return this.recipeList;
    }
}

