/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.core.types.cat_list_machine.ui.client;

import com.google.common.collect.Maps;
import com.valkyrieofnight.envirocore.EnviroCore;
import com.valkyrieofnight.envirocore.core.tile.machine.ECEnergyReceiverTile;
import com.valkyrieofnight.envirocore.core.types.cat_list_machine.dp.cat.AbstractCategoryData;
import com.valkyrieofnight.envirocore.core.types.cat_list_machine.dp.cat.AbstractCategoryDataRegistry;
import com.valkyrieofnight.envirocore.core.types.cat_list_machine.dp.rec.AbstractCatListRecipe;
import com.valkyrieofnight.envirocore.core.types.cat_list_machine.dp.rec.AbstractCatListRecipeRegistry;
import com.valkyrieofnight.envirocore.core.types.cat_list_machine.nw.SetModePacket;
import com.valkyrieofnight.envirocore.core.types.cat_list_machine.nw.SetRecipePacket;
import com.valkyrieofnight.envirocore.core.types.cat_list_machine.obj.AbstractCatListMachineTile;
import com.valkyrieofnight.envirocore.core.types.cat_list_machine.ui.AbstractCatListMachineContainer;
import com.valkyrieofnight.envirocore.m_machines.ECMachinesModule;
import com.valkyrieofnight.envirocore.m_resources.m_1litherite.RLitheriteModule;
import com.valkyrieofnight.vlib.core.network.VLPacket;
import com.valkyrieofnight.vlib.core.ui.client.VLTileInventoryScreen;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.IndexElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.VLElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizableBGElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizablePanelElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.ContainerButtonElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.scroll.VScrollContainerElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.guage.ImageProgressBarElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.image.ImageElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.image.MaxScaledImageElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.image.SequenceImageElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.inventory.SlotsArrayElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.stack.ItemStackSequenceElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.text.LabelElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.HAlignment;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.ProgressionDirection;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.VAlignment;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.StandardThemeAssets;
import com.valkyrieofnight.vlib.core.util.StyleUtil;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Provider;
import com.valkyrieofnight.vlib.core.util.tooltip.ITooltipBuilder;
import com.valkyrieofnight.vlib.core.util.tooltip.QuickTooltips;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class AbstractCatListMachineGui<TILE extends AbstractCatListMachineTile, CONTAINER extends AbstractCatListMachineContainer<TILE>>
extends VLTileInventoryScreen<TILE, CONTAINER> {
    protected TILE catListTile;
    private ImageProgressBarElement energyGuage;
    private ImageProgressBarElement progress;
    private QuickTooltips.Map energyGuageTooltips = QuickTooltips.createMap();
    private BackButton back;
    private ModeButton mode;
    private IndexElement index;
    private Map<VLID, Category> catMap = Maps.newHashMap();
    protected int scrollBoxBGX;
    protected int scrollBoxBGW = 138;
    protected int scrollBoxH = 60;
    protected int scrollBarBGW = 8;

    public AbstractCatListMachineGui(CONTAINER container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.field_230711_n_ = true;
        this.setGuiSize(200, 180);
        this.catListTile = (AbstractCatListMachineTile)container.getTile();
    }

    protected abstract AbstractCategoryDataRegistry getCategoryRegistry();

    protected abstract AbstractCatListRecipeRegistry getCatListRecipeRegistry();

    protected void addElements() {
        this.index = new IndexElement("index"){

            public void addIndices() {
                AbstractCatListMachineGui.this.catMap = Maps.newHashMap();
                this.addIndex((IElement)new Home(this, AbstractCatListMachineGui.this.scrollBoxBGW + AbstractCatListMachineGui.this.scrollBarBGW, AbstractCatListMachineGui.this.scrollBoxH, AbstractCatListMachineGui.this.scrollBoxBGW - 2, (Provider<AbstractCatListRecipe>)((Provider)() -> AbstractCatListMachineGui.this.getCurrent()), (Provider<AbstractCategoryDataRegistry>)((Provider)AbstractCatListMachineGui.this::getCategoryRegistry)));
                Collection categories = AbstractCatListMachineGui.this.getCategoryRegistry().getAll(AbstractCatListMachineGui.this.getCategoryRegistry().getID());
                for (AbstractCategoryData cat : categories) {
                    Category catCat = new Category((AbstractCatListMachineTile)AbstractCatListMachineGui.this.catListTile, cat, this, AbstractCatListMachineGui.this.scrollBoxBGW + AbstractCatListMachineGui.this.scrollBarBGW, AbstractCatListMachineGui.this.scrollBoxH, AbstractCatListMachineGui.this.scrollBoxBGW - 2, (Provider<AbstractCatListRecipe>)((Provider)() -> AbstractCatListMachineGui.this.getCurrent()), (Provider<AbstractCatListRecipeRegistry>)((Provider)AbstractCatListMachineGui.this::getCatListRecipeRegistry));
                    this.addIndex((IElement)catCat);
                    AbstractCatListMachineGui.this.catMap.put(cat.getRecipeID(), catCat);
                }
            }
        };
        this.addElement((IElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_CONTAINER), 0, 0);
        LabelElement title = new LabelElement("title", this.catListTile.func_145748_c_(), StandardThemeAssets.COL_CONTAINER_TITLE_TEXT);
        title.setHorizontalAlignment(HAlignment.CENTER);
        this.addElement((IElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_CONTAINER), 0, 0);
        this.addElement((IElement)title, this.field_146999_f / 2, 6);
        LabelElement inv = new LabelElement("inventory", this.field_213127_e.func_145748_c_(), StandardThemeAssets.COL_CONTAINER_TITLE_TEXT);
        this.addElement((IElement)inv, 8, this.field_147000_g - 96 + 3);
        int x = 6;
        int mainBGWidth = 188;
        int spacing = 2;
        int energyw = 10;
        int energyy = 23;
        int backw = 10;
        int scrollS = 19;
        int scrollE = scrollS + this.scrollBoxH;
        this.addElement((IElement)new SizablePanelElement("main_bg", ECMachinesModule.GSB_DARK_PANEL, mainBGWidth, 68), x, 16);
        this.addElement((IElement)new SizablePanelElement("energy_bg", ECMachinesModule.GSB_DARK_INNER_PANEL, energyw, 38), x += spacing + 1, scrollS + 12);
        this.energyGuage = new ImageProgressBarElement("energy", ECMachinesModule.ENERGY_BAR_08X36, ProgressionDirection.UPWARD, this::getEnergy);
        this.addElement((IElement)this.energyGuage, x + 1, scrollS + 13);
        this.energyGuage.setToolTips((ITooltipBuilder)this.energyGuageTooltips);
        this.energyGuageTooltips.set(0, (ITextComponent)new TranslationTextComponent("label.envirocore.energy.storage").func_230530_a_(StyleUtil.create((Color4)Color4.AZURE)));
        this.addElement((IElement)new SizablePanelElement("back_btn", ECMachinesModule.GSB_DARK_INNER_PANEL, 10, 10), x, scrollS);
        this.back = new BackButton(this.index);
        this.addElement((IElement)this.back, x + 1, scrollS + 1);
        this.addElement((IElement)new SizablePanelElement("mode_bg", ECMachinesModule.GSB_DARK_INNER_PANEL, 10, 10), x, scrollE - 8);
        this.mode = new ModeButton((AbstractCatListMachineTile)this.catListTile);
        this.addElement((IElement)this.mode, x + 1, scrollE - 7);
        this.addElement((IElement)new SizablePanelElement("list_bg", ECMachinesModule.GSB_DARK_INNER_PANEL, this.scrollBoxBGW, this.scrollBoxH + 2), x += backw + spacing, scrollS);
        this.scrollBoxBGX = x + 1;
        this.addElement((IElement)new SizablePanelElement("scroll_bg", ECMachinesModule.GSB_DARK_INNER_PANEL, this.scrollBarBGW, this.scrollBoxH + 2), x += this.scrollBoxBGW + spacing, scrollS);
        this.addElement((IElement)new SizablePanelElement("item_in", ECMachinesModule.GSB_DARK_INNER_PANEL, 20, 20), x += this.scrollBarBGW + spacing, scrollS);
        this.addElement((IElement)new SizablePanelElement("item_out", ECMachinesModule.GSB_DARK_INNER_PANEL, 20, 20), x, scrollE - 18);
        this.addElement((IElement)new ImageElement("progress", this.getProgressBG()), x + 1, scrollS + 23);
        this.progress = new ImageProgressBarElement("progress", this.getProgressBar(), ProgressionDirection.DOWNWARD, this::getProgress);
        this.addElement((IElement)this.progress, x + 1, scrollS + 23);
        SlotsArrayElement sae = new SlotsArrayElement("slots", this.field_147002_h, StandardThemeAssets.TEX_VANILLA_SLOT);
        this.addElement((IElement)sae, 0, 0);
        this.addElement((IElement)this.index, this.scrollBoxBGX, scrollS + 1);
    }

    protected abstract AssetID getProgressBG();

    protected abstract AssetID getProgressBar();

    public void update() {
        String itemNBT = new ItemStack((IItemProvider)RLitheriteModule.LITHERITE).serializeNBT().toString();
        this.energyGuageTooltips.set(1, (ITextComponent)new TranslationTextComponent("label.envirocore.capacity").func_230530_a_(StyleUtil.create((Color4)Color4.DARK_RED)).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)new StringTextComponent(String.format("%,d", ((AbstractCatListMachineTile)this.tile).getFECapacity()))));
        this.energyGuageTooltips.set(2, (ITextComponent)new TranslationTextComponent("label.envirocore.stored").func_230530_a_(StyleUtil.create((Color4)Color4.DARK_RED)).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)new StringTextComponent(String.format("%,d", ((AbstractCatListMachineTile)this.tile).getFEStored()))));
        super.update();
    }

    private float getEnergy() {
        return ((ECEnergyReceiverTile)this.catListTile).getEnergyScaled();
    }

    private float getProgress() {
        return ((AbstractCatListMachineTile)this.catListTile).getProgressScale();
    }

    private void onRecipeChanged(IElement button, AbstractCatListRecipe current) {
    }

    private AbstractCatListRecipe getCurrent() {
        return ((AbstractCatListMachineTile)this.catListTile).getCurrentRecipe();
    }

    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
        super.mouseClickedResponse(element, mouseX, mouseY, mouseButton);
        if (element == null) {
            return;
        }
        if (((Object)((Object)this.back)).equals(element)) {
            this.index.setIndex("home");
        }
        if (element instanceof CatButton) {
            this.index.setIndex(element.getRawID());
        }
        if (element instanceof LensButton) {
            EnviroCore.NETWORK_HANDLER.sendToServer((VLPacket)new SetRecipePacket(((AbstractCatListMachineTile)this.tile).func_174877_v(), ((LensButton)element).getRecipeID()));
        }
        if (element instanceof ModeButton) {
            EnviroCore.NETWORK_HANDLER.sendToServer((VLPacket)new SetModePacket(((AbstractCatListMachineTile)this.tile).func_174877_v(), this.mode.getMode()));
        }
    }

    public static class Category
    extends VScrollContainerElement {
        private AbstractCatListMachineTile tile;
        private AbstractCategoryData category;
        private IndexElement index;
        private int buttonWidth;
        private Provider<AbstractCatListRecipe> getCurrent;
        private Map<VLID, LensButton> buttonMap = Maps.newHashMap();
        private Provider<AbstractCatListRecipeRegistry> getRegistry;

        public Category(AbstractCatListMachineTile tile, AbstractCategoryData category, IndexElement index, int totalWidth, int totalHeight, int buttonWidth, Provider<AbstractCatListRecipe> getCurrent, Provider<AbstractCatListRecipeRegistry> getRegistry) {
            super(category.getRecipeID().toString(), totalWidth, totalHeight, 6, 15, StandardThemeAssets.TEX_VANILLA_SCROLL_TAB_6X15_V_ENA, StandardThemeAssets.TEX_VANILLA_SCROLL_TAB_6X15_V_DIS, 4);
            this.tile = tile;
            this.category = category;
            this.index = index;
            this.buttonWidth = buttonWidth;
            this.getCurrent = getCurrent;
            this.getRegistry = getRegistry;
        }

        public void onRecipeChanged(AbstractCatListRecipe nlgr) {
            if (nlgr == null) {
                return;
            }
            for (LensButton lb : this.buttonMap.values()) {
                lb.setEnabled(true);
            }
            if (this.buttonMap.containsKey(nlgr.getRecipeID())) {
                this.buttonMap.get(nlgr.getRecipeID()).setEnabled(false);
            }
        }

        public void addElementsInContainer() {
            List recipes = ((AbstractCatListRecipeRegistry)((Object)this.getRegistry.request())).getAllForCategory(this.category.getRecipeID());
            int y = 0;
            if (recipes == null) {
                return;
            }
            for (AbstractCatListRecipe recipe : recipes) {
                if (recipe == null) continue;
                LensButton lb = new LensButton(this.tile, recipe, this.buttonWidth);
                this.buttonMap.put(recipe.getRecipeID(), lb);
                this.addElement((IElement)lb, 0, y);
                y += 20;
            }
        }
    }

    public static class Home
    extends VScrollContainerElement {
        private IndexElement index;
        private int y = 0;
        private int buttonWidth;
        private Provider<AbstractCatListRecipe> getCurrent;
        private Provider<AbstractCategoryDataRegistry> getRegistry;

        public Home(IndexElement index, int totalWidth, int totalHeight, int buttonWidth, Provider<AbstractCatListRecipe> getCurrent, Provider<AbstractCategoryDataRegistry> getRegistry) {
            super("home", totalWidth, totalHeight, 6, 15, StandardThemeAssets.TEX_VANILLA_SCROLL_TAB_6X15_V_ENA, StandardThemeAssets.TEX_VANILLA_SCROLL_TAB_6X15_V_DIS, 4);
            this.index = index;
            this.buttonWidth = buttonWidth;
            this.getCurrent = getCurrent;
            this.getRegistry = getRegistry;
        }

        public void addElementsInContainer() {
            Collection categories = ((AbstractCategoryDataRegistry)((Object)this.getRegistry.request())).getAll(((AbstractCategoryDataRegistry)((Object)this.getRegistry.request())).getID());
            for (AbstractCategoryData cat : categories) {
                CatButton cb = new CatButton(cat, this.buttonWidth);
                this.addElement((IElement)cb, 0, this.y);
                this.y += 20;
            }
        }
    }

    public static class LensButton
    extends ContainerButtonElement {
        private AbstractCatListMachineTile tile;
        private final AbstractCatListRecipe recipe;

        public LensButton(AbstractCatListMachineTile tile, AbstractCatListRecipe recipe, int xSize) {
            super(recipe.getRecipeID().toString(), xSize, 20);
            this.tile = tile;
            this.recipe = recipe;
        }

        public void addElements() {
            this.addElementEnabled((VLElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_BEACON_BUTTON_ENA), 0, 0);
            this.addElementDisabled((VLElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_BEACON_BUTTON_DIS), 0, 0);
            this.addElementFocused((VLElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_BEACON_BUTTON_SEL), 0, 0);
            this.addElementHover((VLElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_BEACON_BUTTON_HOV), 0, 0);
            this.addElementAllStates((VLElement)new ItemStackSequenceElement("icon", this.recipe.getOutput(this.tile.getConditionProvider())), 2, 2);
            LabelElement title = new LabelElement("test", (ITextComponent)new TranslationTextComponent(this.recipe.getUnlocalizedTitle()), StandardThemeAssets.COL_CONTAINER_TITLE_TEXT);
            title.setVerticalAlignment(VAlignment.CENTER);
            this.addElementAllStates((VLElement)title, 20, 10);
        }

        public VLID getRecipeID() {
            return this.recipe.getRecipeID();
        }
    }

    public static class CatButton
    extends ContainerButtonElement {
        private final AbstractCategoryData category;

        public CatButton(AbstractCategoryData cat, int xSize) {
            super(cat.getRecipeID().toString(), xSize, 20);
            this.category = cat;
        }

        public void addElements() {
            this.addElementEnabled((VLElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_BEACON_BUTTON_ENA), 0, 0);
            this.addElementDisabled((VLElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_BEACON_BUTTON_DIS), 0, 0);
            this.addElementFocused((VLElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_BEACON_BUTTON_SEL), 0, 0);
            this.addElementHover((VLElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_BEACON_BUTTON_HOV), 0, 0);
            this.addElementAllStates((VLElement)new ItemStackSequenceElement("icon", this.category.getItems()), 2, 2);
            LabelElement title = new LabelElement("test", (ITextComponent)new TranslationTextComponent(this.category.getUnlocalized()), StandardThemeAssets.COL_CONTAINER_TITLE_TEXT);
            title.setVerticalAlignment(VAlignment.CENTER);
            this.addElementAllStates((VLElement)title, 20, 10);
        }
    }

    public class BackButton
    extends ContainerButtonElement {
        private IndexElement indexElement;

        public BackButton(IndexElement index) {
            super("bacl", 8, 8);
            this.indexElement = index;
        }

        public void addElements() {
            this.addElementEnabled((VLElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_BEACON_BUTTON_ENA), 0, 0);
            this.addElementDisabled((VLElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_BEACON_BUTTON_DIS), 0, 0);
            this.addElementFocused((VLElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_BEACON_BUTTON_SEL), 0, 0);
            this.addElementHover((VLElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_BEACON_BUTTON_HOV), 0, 0);
            int ix = this.xSize / 2;
            int iy = this.ySize / 2;
            MaxScaledImageElement ei = new MaxScaledImageElement("ic", StandardThemeAssets.TEX_SYM_FLAT_14_ARROW_LEFT, ix + 2, iy + 2);
            MaxScaledImageElement di = new MaxScaledImageElement("ic", StandardThemeAssets.TEX_SYM_FLAT_14_ARROW_LEFT, ix + 2, iy + 2);
            MaxScaledImageElement hi = new MaxScaledImageElement("ic", StandardThemeAssets.TEX_SYM_FLAT_14_ARROW_LEFT, ix + 2, iy + 2, StandardThemeAssets.COL_BUTTON_ICON_HOVER);
            MaxScaledImageElement si = new MaxScaledImageElement("ic", StandardThemeAssets.TEX_SYM_FLAT_14_ARROW_LEFT, ix + 2, iy + 2, StandardThemeAssets.COL_BUTTON_ICON_HOVER);
            VAlignment va = VAlignment.CENTER;
            HAlignment ha = HAlignment.CENTER;
            this.addElementEach((VLElement)ei, (VLElement)di, (VLElement)hi, (VLElement)si, ix, iy);
            ei.setHorizontalAlignment(ha);
            ei.setVerticalAlignment(va);
            di.setHorizontalAlignment(ha);
            di.setVerticalAlignment(va);
            hi.setHorizontalAlignment(ha);
            hi.setVerticalAlignment(va);
            si.setHorizontalAlignment(ha);
            si.setVerticalAlignment(va);
        }

        public void update() {
            if (this.indexElement.getNumberIndex() == 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            super.update();
        }
    }

    public static class ModeButton
    extends ContainerButtonElement {
        private AbstractCatListMachineTile tile;
        private SequenceImageElement mode;

        public ModeButton(AbstractCatListMachineTile tile) {
            super("mode", 8, 8);
            this.tile = tile;
        }

        public void addElements() {
            this.addElementEnabled((VLElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_BEACON_BUTTON_ENA), 0, 0);
            this.addElementDisabled((VLElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_BEACON_BUTTON_DIS), 0, 0);
            this.addElementFocused((VLElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_BEACON_BUTTON_SEL), 0, 0);
            this.addElementHover((VLElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_BEACON_BUTTON_HOV), 0, 0);
            this.mode = new SequenceImageElement("mode", 4, 4, new AssetID[]{ECMachinesModule.TEX_MODE_SINGLE, ECMachinesModule.TEX_MODE_STACK, ECMachinesModule.TEX_MODE_CONTINUOUS});
            this.addElementAllStates((VLElement)this.mode, 2, 2);
        }

        public void update() {
            super.update();
            int tm = this.tile.getMode().ordinal();
            if (this.mode.getIndex() != tm) {
                this.mode.setIndex(tm);
            }
        }

        public AbstractCatListMachineTile.Mode getMode() {
            return AbstractCatListMachineTile.Mode.getFromOrdinal(this.mode.getIndex() + 1);
        }
    }
}

