/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.item;

import cofh.core.item.InventoryContainerItem;
import cofh.lib.item.IAugmentableItem;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.AugmentableHelper;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.IntSupplier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class InventoryContainerItemAugmentable
extends InventoryContainerItem
implements IAugmentableItem {
    protected IntSupplier numSlots = () -> 0;
    protected BiPredicate<ItemStack, List<ItemStack>> augValidator = (e, f) -> true;

    public InventoryContainerItemAugmentable(Item.Properties builder, int slots) {
        super(builder, slots);
    }

    public InventoryContainerItemAugmentable setNumSlots(IntSupplier numSlots) {
        this.numSlots = numSlots;
        return this;
    }

    public InventoryContainerItemAugmentable setAugValidator(BiPredicate<ItemStack, List<ItemStack>> augValidator) {
        this.augValidator = augValidator;
        return this;
    }

    public int getItemEnchantability(ItemStack stack) {
        return Math.round((float)super.getItemEnchantability(stack) * this.getBaseMod(stack));
    }

    protected float getBaseMod(ItemStack stack) {
        return AugmentableHelper.getPropertyWithDefault((ItemStack)stack, (String)"BaseMod", (float)1.0f);
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundNBT augmentData) {
        CompoundNBT subTag = container.func_179543_a("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentMax((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"BaseMod");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"ItemMax");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"ItemCre");
    }

    public int getContainerSlots(ItemStack container) {
        float base = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"BaseMod", (float)1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"ItemMax", (float)1.0f);
        return Math.round((float)this.slots * mod * base);
    }

    public int getAugmentSlots(ItemStack augmentable) {
        return this.numSlots.getAsInt();
    }

    public boolean validAugment(ItemStack augmentable, ItemStack augment, List<ItemStack> augments) {
        return this.augValidator.test(augment, augments);
    }

    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        container.func_196082_o().func_218657_a("Properties", (INBT)new CompoundNBT());
        for (ItemStack augment : augments) {
            CompoundNBT augmentData = AugmentDataHelper.getAugmentData((ItemStack)augment);
            if (augmentData == null) continue;
            this.setAttributesFromAugment(container, augmentData);
        }
    }
}

