/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.recipes.machine;

import cofh.lib.fluid.FluidIngredient;
import cofh.lib.util.recipes.RecipeJsonUtils;
import cofh.thermal.lib.util.recipes.MachineRecipeSerializer;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class InsolatorRecipeSerializer<T extends ThermalRecipe>
extends MachineRecipeSerializer<T> {
    protected final int defaultWater;

    public InsolatorRecipeSerializer(MachineRecipeSerializer.IFactory<T> recipeFactory, int defaultEnergy, int defaultWater) {
        super(recipeFactory, defaultEnergy);
        this.defaultWater = defaultWater;
    }

    @Override
    public T fromJson(ResourceLocation recipeId, JsonObject json) {
        int energy = this.defaultEnergy;
        int water = this.defaultWater;
        float experience = 0.0f;
        ArrayList<Ingredient> inputItems = new ArrayList<Ingredient>();
        ArrayList<FluidIngredient> inputFluids = new ArrayList<FluidIngredient>();
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
        ArrayList<Float> outputItemChances = new ArrayList<Float>();
        ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>();
        if (json.has("ingredient")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("ingredient"));
        } else if (json.has("ingredients")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("ingredients"));
        } else if (json.has("input")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("input"));
        } else if (json.has("inputs")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("inputs"));
        }
        if (json.has("result")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("result"));
        } else if (json.has("results")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("results"));
        } else if (json.has("output")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("output"));
        } else if (json.has("outputs")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("outputs"));
        }
        if (json.has("energy")) {
            energy = json.get("energy").getAsInt();
        }
        if (json.has("energy_mod")) {
            energy = (int)((float)energy * json.get("energy_mod").getAsFloat());
        }
        if (json.has("experience")) {
            experience = json.get("experience").getAsFloat();
        }
        if (json.has("water")) {
            water = json.get("water").getAsInt();
        }
        if (json.has("water_mod")) {
            water = (int)((float)water * json.get("water_mod").getAsFloat());
        }
        if (inputFluids.isEmpty()) {
            inputFluids.add(FluidIngredient.of((FluidStack[])new FluidStack[]{new FluidStack((Fluid)Fluids.field_204546_a, water)}));
        }
        return this.factory.create(recipeId, energy, experience, inputItems, inputFluids, outputItems, outputItemChances, outputFluids);
    }
}

