/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.machine;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidStackHolder;
import cofh.lib.fluid.IFluidStackAccess;
import cofh.lib.inventory.IItemStackAccess;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.lib.util.managers.AbstractManager;
import cofh.thermal.lib.util.managers.IRecipeManager;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.SimpleMachineRecipe;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraftforge.fluids.FluidStack;

public class RefineryRecipeManager
extends AbstractManager
implements IRecipeManager {
    private static final RefineryRecipeManager INSTANCE = new RefineryRecipeManager();
    protected static final int DEFAULT_ENERGY = 8000;
    protected Map<Integer, IMachineRecipe> recipeMap = new Object2ObjectOpenHashMap();
    protected int maxOutputItems = 1;
    protected int maxOutputFluids = 2;

    public static RefineryRecipeManager instance() {
        return INSTANCE;
    }

    private RefineryRecipeManager() {
        super(8000);
    }

    public void addRecipe(ThermalRecipe recipe) {
        for (FluidStack fluidInput : recipe.getInputFluids().get(0).getFluids()) {
            this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.emptyList(), Collections.singletonList(fluidInput), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
        }
    }

    public boolean validRecipe(FluidStack input) {
        return this.getRecipe(input) != null;
    }

    protected void clear() {
        this.recipeMap.clear();
    }

    protected IMachineRecipe getRecipe(FluidStack input) {
        return this.getRecipe(Collections.emptyList(), Collections.singletonList(new FluidStackHolder(input)));
    }

    protected IMachineRecipe getRecipe(List<? extends IItemStackAccess> inputSlots, List<? extends IFluidStackAccess> inputTanks) {
        if (inputTanks.isEmpty() || inputTanks.get(0).isEmpty()) {
            return null;
        }
        FluidStack inputFluid = inputTanks.get(0).getFluidStack();
        return this.recipeMap.get(FluidHelper.fluidHashcode((FluidStack)inputFluid));
    }

    protected IMachineRecipe addRecipe(int energy, float experience, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids) {
        if (inputFluids.isEmpty() || outputItems.isEmpty() && outputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        FluidStack input = inputFluids.get(0);
        if (input.isEmpty()) {
            return null;
        }
        for (ItemStack itemStack : outputItems) {
            if (!itemStack.func_190926_b()) continue;
            return null;
        }
        for (FluidStack fluidStack : outputFluids) {
            if (!fluidStack.isEmpty()) continue;
            return null;
        }
        energy = (int)((float)energy * this.getDefaultScale());
        SimpleMachineRecipe recipe = new SimpleMachineRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.recipeMap.put(FluidHelper.fluidHashcode((FluidStack)input), recipe);
        return recipe;
    }

    @Override
    public IMachineRecipe getRecipe(IThermalInventory inventory) {
        return this.getRecipe(inventory.inputSlots(), inventory.inputTanks());
    }

    @Override
    public List<IMachineRecipe> getRecipeList() {
        return new ArrayList<IMachineRecipe>(this.recipeMap.values());
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map recipes = recipeManager.func_215366_a(TCoreRecipeTypes.RECIPE_REFINERY);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((ThermalRecipe)((Object)entry.getValue()));
        }
    }
}

