/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.machine;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.IFluidStackAccess;
import cofh.lib.inventory.IItemStackAccess;
import cofh.lib.util.ComparableItemStack;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.item.SlotSealItem;
import cofh.thermal.lib.util.managers.AbstractManager;
import cofh.thermal.lib.util.managers.IRecipeManager;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.SimpleMachineRecipe;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraftforge.fluids.FluidStack;

public class ChillerRecipeManager
extends AbstractManager
implements IRecipeManager {
    private static final ChillerRecipeManager INSTANCE = new ChillerRecipeManager();
    protected static final int DEFAULT_ENERGY = 4000;
    protected Map<List<Integer>, IMachineRecipe> recipeMap = new Object2ObjectOpenHashMap();
    protected Set<Fluid> validFluids = new ObjectOpenHashSet();
    protected Set<ComparableItemStack> validItems = new ObjectOpenHashSet();
    protected int maxOutputItems = 1;
    protected int maxOutputFluids = 0;

    public static ChillerRecipeManager instance() {
        return INSTANCE;
    }

    private ChillerRecipeManager() {
        super(4000);
    }

    public void addRecipe(ThermalRecipe recipe) {
        if (!recipe.getInputFluids().isEmpty()) {
            for (FluidStack fluidInput : recipe.getInputFluids().get(0).getFluids()) {
                if (!recipe.getInputItems().isEmpty()) {
                    for (ItemStack recipeInput : recipe.getInputItems().get(0).func_193365_a()) {
                        this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.singletonList(recipeInput), Collections.singletonList(fluidInput), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                    }
                    continue;
                }
                this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.emptyList(), Collections.singletonList(fluidInput), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
            }
        } else {
            for (ItemStack recipeInput : recipe.getInputItems().get(0).func_193365_a()) {
                this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.singletonList(recipeInput), Collections.emptyList(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
            }
        }
    }

    public boolean validItem(ItemStack item) {
        return this.validItems.contains(ChillerRecipeManager.convert(item));
    }

    public boolean validFluid(FluidStack fluid) {
        return this.validFluids.contains(fluid.getFluid());
    }

    protected void clear() {
        this.recipeMap.clear();
        this.validFluids.clear();
        this.validItems.clear();
    }

    protected IMachineRecipe getRecipe(List<? extends IItemStackAccess> inputSlots, List<? extends IFluidStackAccess> inputTanks) {
        if (inputSlots.isEmpty() && inputTanks.isEmpty() || inputSlots.get(0).isEmpty() && inputTanks.get(0).isEmpty()) {
            return null;
        }
        if (inputTanks.isEmpty() || inputTanks.get(0).isEmpty()) {
            ItemStack inputItem = inputSlots.get(0).getItemStack();
            return this.recipeMap.get(Collections.singletonList(ChillerRecipeManager.convert(inputItem).hashCode()));
        }
        if (inputSlots.isEmpty() || inputSlots.get(0).isEmpty() || inputSlots.get(0).getItemStack().func_77973_b() instanceof SlotSealItem) {
            FluidStack inputFluid = inputTanks.get(0).getFluidStack();
            return this.recipeMap.get(Collections.singletonList(FluidHelper.fluidHashcode((FluidStack)inputFluid)));
        }
        ItemStack inputItem = inputSlots.get(0).getItemStack();
        FluidStack inputFluid = inputTanks.get(0).getFluidStack();
        return this.recipeMap.get(Arrays.asList(ChillerRecipeManager.convert(inputItem).hashCode(), FluidHelper.fluidHashcode((FluidStack)inputFluid)));
    }

    protected IMachineRecipe addRecipe(int energy, float experience, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids) {
        List<Integer> key;
        Object inputItem;
        if (inputItems.isEmpty() && inputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        if (inputFluids.isEmpty()) {
            inputItem = inputItems.get(0);
            if (inputItem.func_190926_b()) {
                return null;
            }
            this.validItems.add(ChillerRecipeManager.convert((ItemStack)inputItem));
            key = Collections.singletonList(ChillerRecipeManager.convert((ItemStack)inputItem).hashCode());
        } else if (inputItems.isEmpty()) {
            FluidStack inputFluid = inputFluids.get(0);
            if (inputFluid.isEmpty()) {
                return null;
            }
            this.validFluids.add(inputFluid.getFluid());
            key = Collections.singletonList(FluidHelper.fluidHashcode((FluidStack)inputFluid));
        } else {
            inputItem = inputItems.get(0);
            if (inputItem.func_190926_b()) {
                return null;
            }
            FluidStack inputFluid = inputFluids.get(0);
            if (inputFluid.isEmpty()) {
                return null;
            }
            this.validItems.add(ChillerRecipeManager.convert((ItemStack)inputItem));
            this.validFluids.add(inputFluid.getFluid());
            key = Arrays.asList(ChillerRecipeManager.convert((ItemStack)inputItem).hashCode(), FluidHelper.fluidHashcode((FluidStack)inputFluid));
        }
        for (ItemStack stack : outputItems) {
            if (!stack.func_190926_b()) continue;
            return null;
        }
        energy = (int)((float)energy * this.getDefaultScale());
        SimpleMachineRecipe recipe = new SimpleMachineRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.recipeMap.put(key, recipe);
        return recipe;
    }

    @Override
    public IMachineRecipe getRecipe(IThermalInventory inventory) {
        return this.getRecipe(inventory.inputSlots(), inventory.inputTanks());
    }

    @Override
    public List<IMachineRecipe> getRecipeList() {
        return new ArrayList<IMachineRecipe>(this.recipeMap.values());
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map recipes = recipeManager.func_215366_a(TCoreRecipeTypes.RECIPE_CHILLER);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((ThermalRecipe)((Object)entry.getValue()));
        }
    }
}

