/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.init;

import cofh.core.item.EnergyContainerItem;
import cofh.core.item.GrenadeItem;
import cofh.core.item.ItemCoFH;
import cofh.lib.entity.AbstractGrenadeEntity;
import cofh.lib.item.ArmorMaterialCoFH;
import cofh.lib.item.impl.SpawnEggItemCoFH;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.constants.ToolTypes;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.entity.item.EarthTNTEntity;
import cofh.thermal.core.entity.item.EnderTNTEntity;
import cofh.thermal.core.entity.item.FireTNTEntity;
import cofh.thermal.core.entity.item.GlowstoneTNTEntity;
import cofh.thermal.core.entity.item.IceTNTEntity;
import cofh.thermal.core.entity.item.LightningTNTEntity;
import cofh.thermal.core.entity.item.NukeTNTEntity;
import cofh.thermal.core.entity.item.PhytoTNTEntity;
import cofh.thermal.core.entity.item.RedstoneTNTEntity;
import cofh.thermal.core.entity.item.SlimeTNTEntity;
import cofh.thermal.core.entity.projectile.EarthGrenadeEntity;
import cofh.thermal.core.entity.projectile.EnderGrenadeEntity;
import cofh.thermal.core.entity.projectile.ExplosiveGrenadeEntity;
import cofh.thermal.core.entity.projectile.FireGrenadeEntity;
import cofh.thermal.core.entity.projectile.GlowstoneGrenadeEntity;
import cofh.thermal.core.entity.projectile.IceGrenadeEntity;
import cofh.thermal.core.entity.projectile.LightningGrenadeEntity;
import cofh.thermal.core.entity.projectile.NukeGrenadeEntity;
import cofh.thermal.core.entity.projectile.PhytoGrenadeEntity;
import cofh.thermal.core.entity.projectile.RedstoneGrenadeEntity;
import cofh.thermal.core.entity.projectile.SlimeGrenadeEntity;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.item.BeekeeperArmorItem;
import cofh.thermal.core.item.DetonatorItem;
import cofh.thermal.core.item.DivingArmorItem;
import cofh.thermal.core.item.EarthChargeItem;
import cofh.thermal.core.item.HazmatArmorItem;
import cofh.thermal.core.item.IceChargeItem;
import cofh.thermal.core.item.LightningChargeItem;
import cofh.thermal.core.item.LockItem;
import cofh.thermal.core.item.PhytoGroItem;
import cofh.thermal.core.item.RedprintItem;
import cofh.thermal.core.item.SatchelItem;
import cofh.thermal.core.item.WrenchItem;
import cofh.thermal.core.item.XpCrystalItem;
import cofh.thermal.core.util.RegistrationHelper;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalFlags;
import cofh.thermal.lib.common.ThermalItemGroups;
import cofh.thermal.lib.item.AugmentItem;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Foods;
import net.minecraft.item.HoneyBottleItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.IEnergyStorage;

public class TCoreItems {
    public static final ArmorMaterialCoFH BEEKEEPER = new ArmorMaterialCoFH("thermal:beekeeper", 4, new int[]{1, 2, 3, 1}, 16, SoundEvents.field_191258_p, 0.0f, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ThermalCore.ITEMS.get("beekeeper_fabric")}));
    public static final ArmorMaterialCoFH DIVING = new ArmorMaterialCoFH("thermal:diving", 12, new int[]{1, 4, 5, 2}, 20, SoundEvents.field_187713_n, 0.0f, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ThermalCore.ITEMS.get("diving_fabric")}));
    public static final ArmorMaterialCoFH HAZMAT = new ArmorMaterialCoFH("thermal:hazmat", 6, new int[]{1, 4, 5, 2}, 15, SoundEvents.field_187728_s, 0.0f, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ThermalCore.ITEMS.get("hazmat_fabric")}));

    private TCoreItems() {
    }

    public static void register() {
        TCoreItems.registerResources();
        TCoreItems.registerParts();
        TCoreItems.registerAugments();
        TCoreItems.registerMaterials();
        TCoreItems.registerTools();
        TCoreItems.registerArmor();
        TCoreItems.registerSpawnEggs();
    }

    public static void setup() {
        DetonatorItem.registerTNT(Blocks.field_150335_W, TNTEntity::new);
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("slime_tnt"), SlimeTNTEntity::new);
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("redstone_tnt"), RedstoneTNTEntity::new);
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("glowstone_tnt"), GlowstoneTNTEntity::new);
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("ender_tnt"), EnderTNTEntity::new);
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("phyto_tnt"), PhytoTNTEntity::new);
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("fire_tnt"), FireTNTEntity::new);
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("earth_tnt"), EarthTNTEntity::new);
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("ice_tnt"), IceTNTEntity::new);
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("lightning_tnt"), LightningTNTEntity::new);
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("nuke_tnt"), NukeTNTEntity::new);
        ((DivingArmorItem)ThermalCore.ITEMS.get("diving_helmet")).setup();
        ((DivingArmorItem)ThermalCore.ITEMS.get("diving_chestplate")).setup();
        ((DivingArmorItem)ThermalCore.ITEMS.get("diving_leggings")).setup();
        ((DivingArmorItem)ThermalCore.ITEMS.get("diving_boots")).setup();
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("rs_control_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("side_config_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("xp_storage_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("upgrade_augment_1"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("upgrade_augment_2"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("upgrade_augment_3"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("rf_coil_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("rf_coil_storage_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("rf_coil_xfer_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("rf_coil_creative_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("fluid_tank_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("fluid_tank_creative_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("item_filter_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("machine_efficiency_creative_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("machine_catalyst_creative_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("machine_cycle_augment"));
    }

    private static void registerResources() {
        ItemGroup group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("sawdust", group);
        RegistrationHelper.registerItem("coal_coke", () -> new ItemCoFH(new Item.Properties().func_200916_a(group)).setBurnTime(3200));
        RegistrationHelper.registerItem("bitumen", () -> new ItemCoFH(new Item.Properties().func_200916_a(group)).setBurnTime(1600));
        RegistrationHelper.registerItem("tar", () -> new ItemCoFH(new Item.Properties().func_200916_a(group)).setBurnTime(800));
        RegistrationHelper.registerItem("rosin", () -> new ItemCoFH(new Item.Properties().func_200916_a(group)).setBurnTime(800));
        RegistrationHelper.registerItem("rubber", group);
        RegistrationHelper.registerItem("cured_rubber", group);
        RegistrationHelper.registerItem("slag", group);
        RegistrationHelper.registerItem("rich_slag", group);
        RegistrationHelper.registerItem("syrup_bottle", () -> new HoneyBottleItem(new Item.Properties().func_200916_a(ThermalItemGroups.THERMAL_FOODS).func_200919_a(Items.field_151069_bo).func_221540_a(Foods.field_226604_w_).func_200917_a(16)));
        RegistrationHelper.registerItem("basalz_rod", group);
        RegistrationHelper.registerItem("basalz_powder", group);
        RegistrationHelper.registerItem("blitz_rod", group);
        RegistrationHelper.registerItem("blitz_powder", group);
        RegistrationHelper.registerItem("blizz_rod", group);
        RegistrationHelper.registerItem("blizz_powder", group);
        RegistrationHelper.registerItem("beekeeper_fabric", () -> new ItemCoFH(new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_BEEKEEPER_ARMOR)));
        RegistrationHelper.registerItem("diving_fabric", () -> new ItemCoFH(new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_DIVING_ARMOR)));
        RegistrationHelper.registerItem("hazmat_fabric", () -> new ItemCoFH(new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_HAZMAT_ARMOR)));
        RegistrationHelper.registerItem("apatite", group);
        RegistrationHelper.registerItem("apatite_dust", group);
        RegistrationHelper.registerItem("cinnabar", group);
        RegistrationHelper.registerItem("cinnabar_dust", group);
        RegistrationHelper.registerItem("niter", group);
        RegistrationHelper.registerItem("niter_dust", group);
        RegistrationHelper.registerItem("sulfur", () -> new ItemCoFH(new Item.Properties().func_200916_a(group)).setBurnTime(1200));
        RegistrationHelper.registerItem("sulfur_dust", () -> new ItemCoFH(new Item.Properties().func_200916_a(group)).setBurnTime(1200));
    }

    private static void registerParts() {
        ItemGroup group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("redstone_servo", group);
        RegistrationHelper.registerItem("rf_coil", group);
        RegistrationHelper.registerItem("drill_head", () -> new ItemCoFH(new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_TOOL_COMPONENTS)));
        RegistrationHelper.registerItem("saw_blade", () -> new ItemCoFH(new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_TOOL_COMPONENTS)));
        RegistrationHelper.registerItem("laser_diode", () -> new ItemCoFH(new Item.Properties().func_200916_a(group)).setShowInGroups(Constants.FALSE));
    }

    private static void registerMaterials() {
        ItemGroup group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("ender_pearl_dust", group);
        RegistrationHelper.registerVanillaMetalSet("iron", group);
        RegistrationHelper.registerVanillaMetalSet("gold", group);
        RegistrationHelper.registerVanillaMetalSet("netherite", group);
        RegistrationHelper.registerVanillaGemSet("lapis", group);
        RegistrationHelper.registerVanillaGemSet("diamond", group);
        RegistrationHelper.registerVanillaGemSet("emerald", group);
        RegistrationHelper.registerVanillaGemSet("quartz", group);
        RegistrationHelper.registerMetalSet("copper", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_COPPER));
        RegistrationHelper.registerMetalSet("tin", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_TIN));
        RegistrationHelper.registerMetalSet("lead", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_LEAD));
        RegistrationHelper.registerMetalSet("silver", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SILVER));
        RegistrationHelper.registerMetalSet("nickel", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NICKEL));
        RegistrationHelper.registerAlloySet("bronze", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_BRONZE));
        RegistrationHelper.registerAlloySet("electrum", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_ELECTRUM));
        RegistrationHelper.registerAlloySet("invar", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_INVAR));
        RegistrationHelper.registerAlloySet("constantan", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_CONSTANTAN));
        Rarity rarity = Rarity.UNCOMMON;
        RegistrationHelper.registerAlloySet("signalum", group, rarity);
        RegistrationHelper.registerAlloySet("lumium", group, rarity);
        RegistrationHelper.registerAlloySet("enderium", group, rarity);
        RegistrationHelper.registerGemSet("ruby", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_RUBY));
        RegistrationHelper.registerGemSet("sapphire", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SAPPHIRE));
    }

    private static void registerTools() {
        ItemGroup group = ThermalItemGroups.THERMAL_TOOLS;
        RegistrationHelper.registerItem("wrench", () -> new WrenchItem(new Item.Properties().func_200917_a(1).func_200916_a(group).addToolType(ToolTypes.WRENCH, 1)).setShowInGroups(ThermalFlags.getFlag("wrench")));
        RegistrationHelper.registerItem("redprint", () -> new RedprintItem(new Item.Properties().func_200917_a(1).func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag("redprint")));
        RegistrationHelper.registerItem("rf_potato", () -> new EnergyContainerItem(new Item.Properties().func_200917_a(1).func_200916_a(group), 100000, 40){

            public Capability<? extends IEnergyStorage> getEnergyCapability() {
                return ThermalEnergyHelper.getBaseEnergySystem();
            }
        }.setShowInGroups(ThermalFlags.getFlag("rf_potato")));
        RegistrationHelper.registerItem("xp_crystal", () -> new XpCrystalItem(new Item.Properties().func_200917_a(1).func_200916_a(group), 10000).setShowInGroups(ThermalFlags.getFlag("xp_crystal")));
        RegistrationHelper.registerItem("lock", () -> new LockItem(new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag("lock")));
        RegistrationHelper.registerItem("satchel", () -> new SatchelItem(new Item.Properties().func_200917_a(1).func_200916_a(group), 9).setShowInGroups(ThermalFlags.getFlag("satchel")));
        RegistrationHelper.registerItem("phytogro", () -> new PhytoGroItem(new Item.Properties().func_200916_a(group)));
        RegistrationHelper.registerItem("junk_net", () -> new ItemCoFH(new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag("device_fisher")));
        RegistrationHelper.registerItem("aquachow", () -> new ItemCoFH(new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag("device_fisher")));
        RegistrationHelper.registerItem("deep_aquachow", () -> new ItemCoFH(new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag("device_fisher")));
        RegistrationHelper.registerItem("earth_charge", () -> new EarthChargeItem(new Item.Properties().func_200916_a(group)));
        RegistrationHelper.registerItem("ice_charge", () -> new IceChargeItem(new Item.Properties().func_200916_a(group)));
        RegistrationHelper.registerItem("lightning_charge", () -> new LightningChargeItem(new Item.Properties().func_200916_a(group)));
        RegistrationHelper.registerItem("detonator", () -> new DetonatorItem(new Item.Properties().func_200917_a(1).func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag("detonator")));
        RegistrationHelper.registerItem("explosive_grenade", () -> new GrenadeItem((GrenadeItem.IGrenadeFactory)new GrenadeItem.IGrenadeFactory<AbstractGrenadeEntity>(){

            public AbstractGrenadeEntity createGrenade(World world, LivingEntity living) {
                return new ExplosiveGrenadeEntity(world, living);
            }

            public AbstractGrenadeEntity createGrenade(World world, double posX, double posY, double posZ) {
                return new ExplosiveGrenadeEntity(world, posX, posY, posZ);
            }
        }, new Item.Properties().func_200916_a(group).func_200917_a(16)));
        RegistrationHelper.registerItem("slime_grenade", () -> new GrenadeItem((GrenadeItem.IGrenadeFactory)new GrenadeItem.IGrenadeFactory<AbstractGrenadeEntity>(){

            public AbstractGrenadeEntity createGrenade(World world, LivingEntity living) {
                return new SlimeGrenadeEntity(world, living);
            }

            public AbstractGrenadeEntity createGrenade(World world, double posX, double posY, double posZ) {
                return new SlimeGrenadeEntity(world, posX, posY, posZ);
            }
        }, new Item.Properties().func_200916_a(group).func_200917_a(16)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_BASIC_EXPLOSIVES)));
        RegistrationHelper.registerItem("redstone_grenade", () -> new GrenadeItem((GrenadeItem.IGrenadeFactory)new GrenadeItem.IGrenadeFactory<AbstractGrenadeEntity>(){

            public AbstractGrenadeEntity createGrenade(World world, LivingEntity living) {
                return new RedstoneGrenadeEntity(world, living);
            }

            public AbstractGrenadeEntity createGrenade(World world, double posX, double posY, double posZ) {
                return new RedstoneGrenadeEntity(world, posX, posY, posZ);
            }
        }, new Item.Properties().func_200916_a(group).func_200917_a(16)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_BASIC_EXPLOSIVES)));
        RegistrationHelper.registerItem("glowstone_grenade", () -> new GrenadeItem((GrenadeItem.IGrenadeFactory)new GrenadeItem.IGrenadeFactory<AbstractGrenadeEntity>(){

            public AbstractGrenadeEntity createGrenade(World world, LivingEntity living) {
                return new GlowstoneGrenadeEntity(world, living);
            }

            public AbstractGrenadeEntity createGrenade(World world, double posX, double posY, double posZ) {
                return new GlowstoneGrenadeEntity(world, posX, posY, posZ);
            }
        }, new Item.Properties().func_200916_a(group).func_200917_a(16)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_BASIC_EXPLOSIVES)));
        RegistrationHelper.registerItem("ender_grenade", () -> new GrenadeItem((GrenadeItem.IGrenadeFactory)new GrenadeItem.IGrenadeFactory<AbstractGrenadeEntity>(){

            public AbstractGrenadeEntity createGrenade(World world, LivingEntity living) {
                return new EnderGrenadeEntity(world, living);
            }

            public AbstractGrenadeEntity createGrenade(World world, double posX, double posY, double posZ) {
                return new EnderGrenadeEntity(world, posX, posY, posZ);
            }
        }, new Item.Properties().func_200916_a(group).func_200917_a(16)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_BASIC_EXPLOSIVES)));
        RegistrationHelper.registerItem("phyto_grenade", () -> new GrenadeItem((GrenadeItem.IGrenadeFactory)new GrenadeItem.IGrenadeFactory<AbstractGrenadeEntity>(){

            public AbstractGrenadeEntity createGrenade(World world, LivingEntity living) {
                return new PhytoGrenadeEntity(world, living);
            }

            public AbstractGrenadeEntity createGrenade(World world, double posX, double posY, double posZ) {
                return new PhytoGrenadeEntity(world, posX, posY, posZ);
            }
        }, new Item.Properties().func_200916_a(group).func_200917_a(16)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_PHYTOGRO_EXPLOSIVES)));
        RegistrationHelper.registerItem("earth_grenade", () -> new GrenadeItem((GrenadeItem.IGrenadeFactory)new GrenadeItem.IGrenadeFactory<AbstractGrenadeEntity>(){

            public AbstractGrenadeEntity createGrenade(World world, LivingEntity living) {
                return new EarthGrenadeEntity(world, living);
            }

            public AbstractGrenadeEntity createGrenade(World world, double posX, double posY, double posZ) {
                return new EarthGrenadeEntity(world, posX, posY, posZ);
            }
        }, new Item.Properties().func_200916_a(group).func_200917_a(16)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES)));
        RegistrationHelper.registerItem("fire_grenade", () -> new GrenadeItem((GrenadeItem.IGrenadeFactory)new GrenadeItem.IGrenadeFactory<AbstractGrenadeEntity>(){

            public AbstractGrenadeEntity createGrenade(World world, LivingEntity living) {
                return new FireGrenadeEntity(world, living);
            }

            public AbstractGrenadeEntity createGrenade(World world, double posX, double posY, double posZ) {
                return new FireGrenadeEntity(world, posX, posY, posZ);
            }
        }, new Item.Properties().func_200916_a(group).func_200917_a(16)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES)));
        RegistrationHelper.registerItem("ice_grenade", () -> new GrenadeItem((GrenadeItem.IGrenadeFactory)new GrenadeItem.IGrenadeFactory<AbstractGrenadeEntity>(){

            public AbstractGrenadeEntity createGrenade(World world, LivingEntity living) {
                return new IceGrenadeEntity(world, living);
            }

            public AbstractGrenadeEntity createGrenade(World world, double posX, double posY, double posZ) {
                return new IceGrenadeEntity(world, posX, posY, posZ);
            }
        }, new Item.Properties().func_200916_a(group).func_200917_a(16)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES)));
        RegistrationHelper.registerItem("lightning_grenade", () -> new GrenadeItem((GrenadeItem.IGrenadeFactory)new GrenadeItem.IGrenadeFactory<AbstractGrenadeEntity>(){

            public AbstractGrenadeEntity createGrenade(World world, LivingEntity living) {
                return new LightningGrenadeEntity(world, living);
            }

            public AbstractGrenadeEntity createGrenade(World world, double posX, double posY, double posZ) {
                return new LightningGrenadeEntity(world, posX, posY, posZ);
            }
        }, new Item.Properties().func_200916_a(group).func_200917_a(16)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES)));
        RegistrationHelper.registerItem("nuke_grenade", () -> new GrenadeItem((GrenadeItem.IGrenadeFactory)new GrenadeItem.IGrenadeFactory<AbstractGrenadeEntity>(){

            public AbstractGrenadeEntity createGrenade(World world, LivingEntity living) {
                return new NukeGrenadeEntity(world, living);
            }

            public AbstractGrenadeEntity createGrenade(World world, double posX, double posY, double posZ) {
                return new NukeGrenadeEntity(world, posX, posY, posZ);
            }
        }, new Item.Properties().func_200916_a(group).func_208103_a(Rarity.UNCOMMON).func_200917_a(16)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_NUCLEAR_EXPLOSIVES)));
    }

    private static void registerArmor() {
        ItemGroup group = ThermalItemGroups.THERMAL_TOOLS;
        ThermalCore.ITEMS.register("beekeeper_helmet", () -> new BeekeeperArmorItem((IArmorMaterial)BEEKEEPER, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_BEEKEEPER_ARMOR)));
        ThermalCore.ITEMS.register("beekeeper_chestplate", () -> new BeekeeperArmorItem((IArmorMaterial)BEEKEEPER, EquipmentSlotType.CHEST, new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_BEEKEEPER_ARMOR)));
        ThermalCore.ITEMS.register("beekeeper_leggings", () -> new BeekeeperArmorItem((IArmorMaterial)BEEKEEPER, EquipmentSlotType.LEGS, new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_BEEKEEPER_ARMOR)));
        ThermalCore.ITEMS.register("beekeeper_boots", () -> new BeekeeperArmorItem((IArmorMaterial)BEEKEEPER, EquipmentSlotType.FEET, new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_BEEKEEPER_ARMOR)));
        ThermalCore.ITEMS.register("diving_helmet", () -> new DivingArmorItem((IArmorMaterial)DIVING, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_DIVING_ARMOR)));
        ThermalCore.ITEMS.register("diving_chestplate", () -> new DivingArmorItem((IArmorMaterial)DIVING, EquipmentSlotType.CHEST, new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_DIVING_ARMOR)));
        ThermalCore.ITEMS.register("diving_leggings", () -> new DivingArmorItem((IArmorMaterial)DIVING, EquipmentSlotType.LEGS, new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_DIVING_ARMOR)));
        ThermalCore.ITEMS.register("diving_boots", () -> new DivingArmorItem((IArmorMaterial)DIVING, EquipmentSlotType.FEET, new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_DIVING_ARMOR)));
        ThermalCore.ITEMS.register("hazmat_helmet", () -> new HazmatArmorItem((IArmorMaterial)HAZMAT, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_HAZMAT_ARMOR)));
        ThermalCore.ITEMS.register("hazmat_chestplate", () -> new HazmatArmorItem((IArmorMaterial)HAZMAT, EquipmentSlotType.CHEST, new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_HAZMAT_ARMOR)));
        ThermalCore.ITEMS.register("hazmat_leggings", () -> new HazmatArmorItem((IArmorMaterial)HAZMAT, EquipmentSlotType.LEGS, new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_HAZMAT_ARMOR)));
        ThermalCore.ITEMS.register("hazmat_boots", () -> new HazmatArmorItem((IArmorMaterial)HAZMAT, EquipmentSlotType.FEET, new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_HAZMAT_ARMOR)));
    }

    private static void registerAugments() {
        TCoreItems.registerUpgradeAugments();
        TCoreItems.registerFeatureAugments();
        TCoreItems.registerStorageAugments();
        TCoreItems.registerFilterAugments();
        TCoreItems.registerMachineAugments();
        TCoreItems.registerDynamoAugments();
        TCoreItems.registerAreaAugments();
        TCoreItems.registerPotionAugments();
    }

    private static void registerUpgradeAugments() {
        ItemGroup group = ThermalItemGroups.THERMAL_ITEMS;
        float[] upgradeMods = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 6.0f, 8.5f};
        for (int i = 1; i <= 3; ++i) {
            int tier = i;
            RegistrationHelper.registerItem("upgrade_augment_" + i, () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().type("Upgrade").mod("BaseMod", upgradeMods[tier]).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_UPGRADE_AUGMENTS)));
        }
    }

    private static void registerFeatureAugments() {
        ItemGroup group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("rs_control_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().mod("RSCtl", 1.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_RS_CONTROL_AUGMENT)));
        RegistrationHelper.registerItem("side_config_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().mod("SideCfg", 1.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_SIDE_CONFIG_AUGMENT)));
        RegistrationHelper.registerItem("xp_storage_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().mod("XpStr", 1.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_XP_STORAGE_AUGMENT)));
    }

    private static void registerStorageAugments() {
        ItemGroup group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("rf_coil_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().type("RF").mod("RFMax", 4.0f).mod("RFXfer", 4.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_STORAGE_AUGMENTS)));
        RegistrationHelper.registerItem("rf_coil_storage_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().type("RF").mod("RFMax", 6.0f).mod("RFXfer", 2.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_STORAGE_AUGMENTS)));
        RegistrationHelper.registerItem("rf_coil_xfer_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().type("RF").mod("RFMax", 2.0f).mod("RFXfer", 6.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_STORAGE_AUGMENTS)));
        RegistrationHelper.registerItem("rf_coil_creative_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group).func_208103_a(Rarity.EPIC), AugmentDataHelper.builder().type("RF").mod("RFMax", 16.0f).mod("RFXfer", 16.0f).mod("RFCre", 1.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_CREATIVE_STORAGE_AUGMENTS)));
        RegistrationHelper.registerItem("fluid_tank_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().type("Fluid").mod("FluidMax", 4.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_STORAGE_AUGMENTS)));
        RegistrationHelper.registerItem("fluid_tank_creative_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group).func_208103_a(Rarity.EPIC), AugmentDataHelper.builder().type("Fluid").mod("FluidMax", 16.0f).mod("FluidCre", 1.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_CREATIVE_STORAGE_AUGMENTS)));
    }

    private static void registerFilterAugments() {
        ItemGroup group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("item_filter_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().type("Filter").feature("FilterType", "item").build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_FILTER_AUGMENTS)));
    }

    private static void registerMachineAugments() {
        ItemGroup group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("machine_speed_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().type("Machine").mod("MachinePower", 1.0f).mod("MachineEnergy", 1.1f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_MACHINE_AUGMENTS)));
        RegistrationHelper.registerItem("machine_efficiency_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().type("Machine").mod("MachineSpeed", -0.1f).mod("MachineEnergy", 0.9f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_MACHINE_AUGMENTS)));
        RegistrationHelper.registerItem("machine_efficiency_creative_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group).func_208103_a(Rarity.EPIC), AugmentDataHelper.builder().type("Machine").mod("MachineEnergy", 0.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_CREATIVE_MACHINE_AUGMENTS)));
        RegistrationHelper.registerItem("machine_output_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().type("Machine").mod("MachineSec", 0.15f).mod("MachineEnergy", 1.25f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_MACHINE_AUGMENTS)));
        RegistrationHelper.registerItem("machine_catalyst_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().type("Machine").mod("MachineCat", 0.8f).mod("MachineEnergy", 1.25f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_MACHINE_AUGMENTS)));
        RegistrationHelper.registerItem("machine_catalyst_creative_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group).func_208103_a(Rarity.EPIC), AugmentDataHelper.builder().type("Machine").mod("MachineCat", 0.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_CREATIVE_MACHINE_AUGMENTS)));
        RegistrationHelper.registerItem("machine_cycle_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().type("Machine").mod("CycProc", 1.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_MACHINE_AUGMENTS)));
    }

    private static void registerDynamoAugments() {
        ItemGroup group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("dynamo_output_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().type("Dynamo").mod("DynamoPower", 1.0f).mod("DynamoEnergy", 0.9f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_DYNAMO_AUGMENTS)));
        RegistrationHelper.registerItem("dynamo_fuel_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().type("Dynamo").mod("DynamoEnergy", 1.1f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_DYNAMO_AUGMENTS)));
    }

    private static void registerAreaAugments() {
        ItemGroup group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("area_radius_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().type("Area").mod("Radius", 1.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_AREA_AUGMENTS)));
    }

    private static void registerPotionAugments() {
        ItemGroup group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("potion_amplifier_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().type("Potion").mod("PotionAmp", 1.0f).mod("PotionDur", -0.25f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_POTION_AUGMENTS)));
        RegistrationHelper.registerItem("potion_duration_augment", () -> new AugmentItem(new Item.Properties().func_200916_a(group), AugmentDataHelper.builder().type("Potion").mod("PotionDur", 1.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_POTION_AUGMENTS)));
    }

    private static void registerSpawnEggs() {
        ItemGroup group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("basalz_spawn_egg", () -> new SpawnEggItemCoFH(() -> TCoreReferences.BASALZ_ENTITY, 3553344, 525319, new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_MOB_BASALZ)));
        RegistrationHelper.registerItem("blizz_spawn_egg", () -> new SpawnEggItemCoFH(() -> TCoreReferences.BLIZZ_ENTITY, 14212069, 9558524, new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_MOB_BLIZZ)));
        RegistrationHelper.registerItem("blitz_spawn_egg", () -> new SpawnEggItemCoFH(() -> TCoreReferences.BLITZ_ENTITY, 13233919, 16767358, new Item.Properties().func_200916_a(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_MOB_BLITZ)));
    }
}

