/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.crt.device;

import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.device.PotionDiffuserBoost;
import cofh.thermal.lib.compat.crt.base.CRTHelper;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipe;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.thermal.PotionDiffuserBoost")
@IRecipeHandler.For(value=PotionDiffuserBoost.class)
public class CRTPotionDiffuserBoostManager
implements IRecipeManager,
IRecipeHandler<PotionDiffuserBoost> {
    @ZenCodeType.Method
    public void addBoost(String name, IIngredientWithAmount inputItem, int amplifier, float durationMod, int cycles) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        PotionDiffuserBoost mapping = new PotionDiffuserBoost(resourceLocation, CRTHelper.mapIIngredientWithAmount(inputItem), amplifier, durationMod, cycles);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)mapping));
    }

    public IRecipeType<PotionDiffuserBoost> getRecipeType() {
        return TCoreRecipeTypes.BOOST_POTION_DIFFUSER;
    }

    public void removeRecipe(IItemStack input) {
        this.removeBoost(input);
    }

    @ZenCodeType.Method
    public void removeBoost(IItemStack input) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)this, recipe -> {
            if (recipe instanceof PotionDiffuserBoost) {
                return ((PotionDiffuserBoost)((Object)recipe)).getIngredient().test(input.getInternal());
            }
            return false;
        }));
    }

    public String dumpToCommandString(IRecipeManager manager, PotionDiffuserBoost recipe) {
        return String.format("<recipetype:%s>.addBoost(\"%s\", %s, %s, %s, %s);", recipe.func_222127_g(), recipe.func_199560_c(), IIngredient.fromIngredient((Ingredient)recipe.getIngredient()).getCommandString(), recipe.getAmplifier(), Float.valueOf(recipe.getDurationMod()), recipe.getCycles());
    }

    public Optional<Function<ResourceLocation, PotionDiffuserBoost>> replaceIngredients(IRecipeManager manager, PotionDiffuserBoost recipe, List<IReplacementRule> rules) {
        Optional ingredient = IRecipeHandler.attemptReplacing((Object)recipe.getIngredient(), Ingredient.class, (IRecipe)recipe, rules);
        return ingredient.map(value -> id -> new PotionDiffuserBoost((ResourceLocation)id, (Ingredient)value, recipe.getAmplifier(), recipe.getDurationMod(), recipe.getCycles()));
    }
}

