/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.crt.device;

import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.device.HiveExtractorMapping;
import cofh.thermal.lib.compat.crt.base.CRTHelper;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipe;
import com.blamejared.crafttweaker.impl.fluid.MCFluidStackMutable;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker.impl_native.blocks.ExpandBlock;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.thermal.HiveExtractor")
@IRecipeHandler.For(value=HiveExtractorMapping.class)
public class CRTHiveExtractorManager
implements IRecipeManager,
IRecipeHandler<HiveExtractorMapping> {
    @ZenCodeType.Method
    public void addMapping(String name, Block hive, IItemStack item, IFluidStack fluid) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        if (!hive.func_176194_O().func_177623_d().contains(BeehiveBlock.field_226873_c_)) {
            throw new IllegalArgumentException(String.format("Cannot add Hive Extractor Mapping as provided provided block: '%s' does not have a 'honey_level' Block Property!", ExpandBlock.getCommandString((Block)hive)));
        }
        HiveExtractorMapping mapping = new HiveExtractorMapping(resourceLocation, hive, item.getInternal(), fluid.getInternal());
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)mapping));
    }

    public IRecipeType<HiveExtractorMapping> getRecipeType() {
        return TCoreRecipeTypes.MAPPING_HIVE_EXTRACTOR;
    }

    public void removeRecipe(IIngredient output) {
        this.removeMapping(output);
    }

    @ZenCodeType.Method
    public void removeMapping(IIngredient output) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)this, recipe -> {
            if (recipe instanceof HiveExtractorMapping) {
                return output.matches((IItemStack)new MCItemStackMutable(((HiveExtractorMapping)((Object)recipe)).getItem()));
            }
            return false;
        }));
    }

    @ZenCodeType.Method
    public void removeMapping(Block hive) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)this, recipe -> {
            if (recipe instanceof HiveExtractorMapping) {
                return hive == ((HiveExtractorMapping)((Object)recipe)).getHive();
            }
            return false;
        }));
    }

    @ZenCodeType.Method
    public void removeMapping(CTFluidIngredient fluid) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)this, recipe -> {
            if (recipe instanceof HiveExtractorMapping) {
                return CRTHelper.mapFluidIngredient(fluid).test(((HiveExtractorMapping)((Object)recipe)).getFluid());
            }
            return false;
        }));
    }

    public String dumpToCommandString(IRecipeManager manager, HiveExtractorMapping recipe) {
        return String.format("<recipetype:%s>.addMapping(\"%s\", %s, %s, %s);", recipe.func_222127_g(), recipe.func_199560_c(), ExpandBlock.getCommandString((Block)recipe.getHive()), new MCItemStackMutable(recipe.getItem()).getCommandString(), new MCFluidStackMutable(recipe.getFluid()).getCommandString());
    }

    public Optional<Function<ResourceLocation, HiveExtractorMapping>> replaceIngredients(IRecipeManager manager, HiveExtractorMapping recipe, List<IReplacementRule> rules) {
        return Optional.empty();
    }
}

