/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core;

import cofh.core.init.CoreEnchantments;
import cofh.lib.capability.CapabilityRedstoneFlux;
import cofh.lib.client.renderer.entity.SpriteRendererCoFH;
import cofh.lib.client.renderer.entity.TNTRendererCoFH;
import cofh.lib.util.DeferredRegisterCoFH;
import cofh.thermal.core.client.gui.ChargeBenchScreen;
import cofh.thermal.core.client.gui.TinkerBenchScreen;
import cofh.thermal.core.client.gui.device.DeviceCollectorScreen;
import cofh.thermal.core.client.gui.device.DeviceFisherScreen;
import cofh.thermal.core.client.gui.device.DeviceHiveExtractorScreen;
import cofh.thermal.core.client.gui.device.DeviceNullifierScreen;
import cofh.thermal.core.client.gui.device.DevicePotionDiffuserScreen;
import cofh.thermal.core.client.gui.device.DeviceRockGenScreen;
import cofh.thermal.core.client.gui.device.DeviceSoilInfuserScreen;
import cofh.thermal.core.client.gui.device.DeviceTreeExtractorScreen;
import cofh.thermal.core.client.gui.device.DeviceWaterGenScreen;
import cofh.thermal.core.client.gui.storage.EnergyCellScreen;
import cofh.thermal.core.client.gui.storage.FluidCellScreen;
import cofh.thermal.core.client.gui.storage.SatchelScreen;
import cofh.thermal.core.client.renderer.entity.BasalzProjectileRenderer;
import cofh.thermal.core.client.renderer.entity.BasalzRenderer;
import cofh.thermal.core.client.renderer.entity.BlitzProjectileRenderer;
import cofh.thermal.core.client.renderer.entity.BlitzRenderer;
import cofh.thermal.core.client.renderer.entity.BlizzProjectileRenderer;
import cofh.thermal.core.client.renderer.entity.BlizzRenderer;
import cofh.thermal.core.entity.monster.BasalzEntity;
import cofh.thermal.core.init.TCoreBlocks;
import cofh.thermal.core.init.TCoreContainers;
import cofh.thermal.core.init.TCoreEntities;
import cofh.thermal.core.init.TCoreFluids;
import cofh.thermal.core.init.TCoreItems;
import cofh.thermal.core.init.TCoreRecipeManagers;
import cofh.thermal.core.init.TCoreRecipeSerializers;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.init.TCoreSounds;
import cofh.thermal.core.world.gen.feature.ThermalFeatures;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.common.ThermalFlags;
import cofh.thermal.lib.common.ThermalProxy;
import cofh.thermal.lib.common.ThermalProxyClient;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="thermal")
public class ThermalCore {
    public static final Logger LOG = LogManager.getLogger((String)"thermal");
    public static final ThermalProxy PROXY = (ThermalProxy)DistExecutor.unsafeRunForDist(() -> ThermalProxyClient::new, () -> ThermalProxy::new);
    public static final DeferredRegisterCoFH<Block> BLOCKS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"thermal");
    public static final DeferredRegisterCoFH<Item> ITEMS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"thermal");
    public static final DeferredRegisterCoFH<Fluid> FLUIDS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"thermal");
    public static final DeferredRegisterCoFH<ContainerType<?>> CONTAINERS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"thermal");
    public static final DeferredRegisterCoFH<EntityType<?>> ENTITIES = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"thermal").preventDataFixers(true);
    public static final DeferredRegisterCoFH<GlobalLootModifierSerializer<?>> LOOT_SERIALIZERS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.LOOT_MODIFIER_SERIALIZERS, (String)"thermal");
    public static final DeferredRegisterCoFH<IRecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"thermal");
    public static final DeferredRegisterCoFH<SoundEvent> SOUND_EVENTS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"thermal");
    public static final DeferredRegisterCoFH<TileEntityType<?>> TILE_ENTITIES = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"thermal");

    public ThermalCore() {
        this.setFeatureFlags();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::entitySetup);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        FLUIDS.register(modEventBus);
        CONTAINERS.register(modEventBus);
        ENTITIES.register(modEventBus);
        LOOT_SERIALIZERS.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        ThermalConfig.register();
        CoreEnchantments.registerHoldingEnchantment();
    }

    private void setFeatureFlags() {
        ThermalFlags.setFlag(ThermalFlags.FLAG_AREA_AUGMENTS, true);
        ThermalFlags.setFlag(ThermalFlags.FLAG_FILTER_AUGMENTS, true);
        ThermalFlags.setFlag(ThermalFlags.FLAG_STORAGE_AUGMENTS, true);
        ThermalFlags.setFlag(ThermalFlags.FLAG_UPGRADE_AUGMENTS, true);
        ThermalFlags.setFlag(ThermalFlags.FLAG_CREATIVE_AUGMENTS, true);
        ThermalFlags.setFlag("tinker_bench", true);
    }

    private void entitySetup(EntityAttributeCreationEvent event) {
        event.put(TCoreReferences.BASALZ_ENTITY, BasalzEntity.registerAttributes().func_233813_a_());
        event.put(TCoreReferences.BLITZ_ENTITY, BasalzEntity.registerAttributes().func_233813_a_());
        event.put(TCoreReferences.BLIZZ_ENTITY, BasalzEntity.registerAttributes().func_233813_a_());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        CapabilityRedstoneFlux.register();
        ThermalConfig.setup();
        event.enqueueWork(TCoreBlocks::setup);
        event.enqueueWork(TCoreItems::setup);
        event.enqueueWork(TCoreEntities::setup);
        event.enqueueWork(ThermalFeatures::setup);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        this.registerGuiFactories();
        this.registerRenderLayers();
        this.registerEntityRenderingHandlers();
        this.registerTileEntityRenderers();
    }

    private void registerGuiFactories() {
        ScreenManager.func_216911_a(TCoreReferences.DEVICE_HIVE_EXTRACTOR_CONTAINER, DeviceHiveExtractorScreen::new);
        ScreenManager.func_216911_a(TCoreReferences.DEVICE_TREE_EXTRACTOR_CONTAINER, DeviceTreeExtractorScreen::new);
        ScreenManager.func_216911_a(TCoreReferences.DEVICE_SOIL_INFUSER_CONTAINER, DeviceSoilInfuserScreen::new);
        ScreenManager.func_216911_a(TCoreReferences.DEVICE_FISHER_CONTAINER, DeviceFisherScreen::new);
        ScreenManager.func_216911_a(TCoreReferences.DEVICE_WATER_GEN_CONTAINER, DeviceWaterGenScreen::new);
        ScreenManager.func_216911_a(TCoreReferences.DEVICE_ROCK_GEN_CONTAINER, DeviceRockGenScreen::new);
        ScreenManager.func_216911_a(TCoreReferences.DEVICE_COLLECTOR_CONTAINER, DeviceCollectorScreen::new);
        ScreenManager.func_216911_a(TCoreReferences.DEVICE_POTION_DIFFUSER_CONTAINER, DevicePotionDiffuserScreen::new);
        ScreenManager.func_216911_a(TCoreReferences.DEVICE_NULLIFIER_CONTAINER, DeviceNullifierScreen::new);
        ScreenManager.func_216911_a(TCoreReferences.TINKER_BENCH_CONTAINER, TinkerBenchScreen::new);
        ScreenManager.func_216911_a(TCoreReferences.CHARGE_BENCH_CONTAINER, ChargeBenchScreen::new);
        ScreenManager.func_216911_a(TCoreReferences.SATCHEL_CONTAINER, SatchelScreen::new);
        ScreenManager.func_216911_a(TCoreReferences.ENERGY_CELL_CONTAINER, EnergyCellScreen::new);
        ScreenManager.func_216911_a(TCoreReferences.FLUID_CELL_CONTAINER, FluidCellScreen::new);
    }

    private void registerRenderLayers() {
        RenderType cutout = RenderType.func_228643_e_();
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("obsidian_glass")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("signalum_glass")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("lumium_glass")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("enderium_glass")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("machine_frame")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("energy_cell_frame")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("energy_cell")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("fluid_cell_frame")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("fluid_cell")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("device_tree_extractor")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("device_water_gen")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("device_rock_gen")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("device_collector")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("device_potion_diffuser")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("device_nullifier")), (RenderType)cutout);
    }

    private void registerEntityRenderingHandlers() {
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.BASALZ_ENTITY, BasalzRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.BLITZ_ENTITY, BlitzRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.BLIZZ_ENTITY, BlizzRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.BASALZ_PROJECTILE_ENTITY, BasalzProjectileRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.BLITZ_PROJECTILE_ENTITY, BlitzProjectileRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.BLIZZ_PROJECTILE_ENTITY, BlizzProjectileRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.EXPLOSIVE_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.SLIME_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.REDSTONE_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.GLOWSTONE_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.ENDER_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.PHYTO_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.FIRE_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.EARTH_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.ICE_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.LIGHTNING_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.NUKE_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.SLIME_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.REDSTONE_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.GLOWSTONE_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.ENDER_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.PHYTO_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.FIRE_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.EARTH_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.ICE_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.LIGHTNING_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.NUKE_TNT_ENTITY, TNTRendererCoFH::new);
    }

    private void registerTileEntityRenderers() {
    }

    static {
        TCoreBlocks.register();
        TCoreItems.register();
        TCoreFluids.register();
        TCoreContainers.register();
        TCoreEntities.register();
        TCoreSounds.register();
        TCoreRecipeManagers.register();
        TCoreRecipeSerializers.register();
        TCoreRecipeTypes.register();
    }
}

