/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.catalogue.Catalogue;
import com.mrcrayfish.catalogue.client.ScreenUtil;
import com.mrcrayfish.catalogue.client.screen.widget.CatalogueCheckBoxButton;
import com.mrcrayfish.catalogue.client.screen.widget.CatalogueIconButton;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.common.util.Size2i;
import net.minecraftforge.fml.ForgeI18n;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.client.ConfigGuiHandler;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.fml.packs.ResourcePackLoader;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class CatalogueModListScreen
extends Screen {
    private static final Comparator<ModEntry> SORT = Comparator.comparing(o -> o.getInfo().getDisplayName());
    private static final ResourceLocation MISSING_BANNER = new ResourceLocation("catalogue", "textures/gui/missing_banner.png");
    private static final ResourceLocation VERSION_CHECK_ICONS = new ResourceLocation("forge", "textures/gui/version_check_icons.png");
    private static final Map<String, Pair<ResourceLocation, Size2i>> LOGO_CACHE = new HashMap<String, Pair<ResourceLocation, Size2i>>();
    private static final Map<String, Pair<ResourceLocation, Size2i>> ICON_CACHE = new HashMap<String, Pair<ResourceLocation, Size2i>>();
    private static final Map<String, Item> ITEM_CACHE = new HashMap<String, Item>();
    private TextFieldWidget searchTextField;
    private ModList modList;
    private IModInfo selectedModInfo;
    private Button modFolderButton;
    private Button configButton;
    private Button websiteButton;
    private Button issueButton;
    private CheckboxButton updatesButton;
    private StringList descriptionList;
    private int tooltipYOffset;
    private List<IReorderingProcessor> activeTooltip;

    public CatalogueModListScreen() {
        super(StringTextComponent.field_240750_d_);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.searchTextField = new TextFieldWidget(this.field_230712_o_, 11, 25, 148, 20, StringTextComponent.field_240750_d_);
        this.searchTextField.func_212954_a(s -> {
            this.updateSearchField((String)s);
            this.modList.filterAndUpdateList((String)s);
            this.updateSelectedModList();
        });
        this.field_230705_e_.add(this.searchTextField);
        this.modList = new ModList();
        this.modList.func_230959_g_(10);
        this.modList.func_244606_c(false);
        this.field_230705_e_.add(this.modList);
        this.func_230480_a_((Widget)new Button(10, this.modList.getBottom() + 8, 127, 20, DialogTexts.field_240637_h_, onPress -> this.getMinecraft().func_147108_a(null)));
        this.modFolderButton = (Button)this.func_230480_a_((Widget)new CatalogueIconButton(140, this.modList.getBottom() + 8, 0, 0, onPress -> Util.func_110647_a().func_195641_a(FMLPaths.MODSDIR.get().toFile())));
        int padding = 10;
        int contentLeft = this.modList.getRight() + 12 + padding;
        int contentWidth = this.field_230708_k_ - contentLeft - padding;
        int buttonWidth = (contentWidth - padding) / 3;
        this.configButton = (Button)this.func_230480_a_((Widget)new CatalogueIconButton(contentLeft, 105, 10, 0, buttonWidth, (ITextComponent)new TranslationTextComponent("fml.menu.mods.config"), onPress -> {
            if (this.selectedModInfo != null) {
                ConfigGuiHandler.getGuiFactoryFor((ModInfo)((ModInfo)this.selectedModInfo)).map(f -> (Screen)f.apply(this.field_230706_i_, this)).ifPresent(newScreen -> this.getMinecraft().func_147108_a(newScreen));
            }
        }));
        this.configButton.field_230694_p_ = false;
        this.websiteButton = (Button)this.func_230480_a_((Widget)new CatalogueIconButton(contentLeft + buttonWidth + 5, 105, 20, 0, buttonWidth, (ITextComponent)new StringTextComponent("Website"), onPress -> this.openLink("displayURL", (IConfigurable)this.selectedModInfo)));
        this.websiteButton.field_230694_p_ = false;
        this.issueButton = (Button)this.func_230480_a_((Widget)new CatalogueIconButton(contentLeft + buttonWidth + buttonWidth + 10, 105, 30, 0, buttonWidth, (ITextComponent)new StringTextComponent("Submit Bug"), onPress -> this.openLink("issueTrackerURL", (IConfigurable)(this.selectedModInfo != null ? (ModFileInfo)this.selectedModInfo.getOwningFile() : null))));
        this.issueButton.field_230694_p_ = false;
        this.descriptionList = new StringList(contentWidth, this.field_230709_l_ - 135 - 55, contentLeft, 130);
        this.descriptionList.func_244606_c(false);
        this.descriptionList.func_244605_b(false);
        this.field_230705_e_.add(this.descriptionList);
        this.updatesButton = (CheckboxButton)this.func_230480_a_((Widget)new CatalogueCheckBoxButton(this.modList.getRight() - 14, 7, button -> {
            this.modList.filterAndUpdateList(this.searchTextField.func_146179_b());
            this.updateSelectedModList();
        }));
        this.modList.filterAndUpdateList(this.searchTextField.func_146179_b());
        if (this.selectedModInfo != null) {
            this.setSelectedModInfo(this.selectedModInfo);
            this.updateSelectedModList();
            ModEntry entry = this.modList.getEntryFromInfo(this.selectedModInfo);
            if (entry != null) {
                this.modList.centerScrollOn(entry);
            }
        }
        this.updateSearchField(this.searchTextField.func_146179_b());
    }

    private void openLink(String key, @Nullable IConfigurable configurable) {
        if (configurable != null) {
            configurable.getConfigElement(new String[]{key}).ifPresent(o -> this.openLink(o.toString()));
        }
    }

    private void openLink(String url) {
        Style style = Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        this.func_230455_a_(style);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.func_230446_a_(matrixStack);
        this.drawModList(matrixStack, mouseX, mouseY, partialTicks);
        this.drawModInfo(matrixStack, mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        Optional optional = net.minecraftforge.fml.ModList.get().getModContainerById("catalogue");
        optional.ifPresent(container -> this.loadAndCacheLogo(container.getModInfo()));
        Pair<ResourceLocation, Size2i> pair = LOGO_CACHE.get("catalogue");
        if (pair != null && pair.getLeft() != null) {
            ResourceLocation textureId = (ResourceLocation)pair.getLeft();
            Size2i size = (Size2i)pair.getRight();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(textureId);
            AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)10, (int)9, (int)10, (int)10, (float)0.0f, (float)0.0f, (int)size.width, (int)size.height, (int)size.width, (int)size.height);
        }
        if (ScreenUtil.isMouseWithin(10, 9, 10, 10, mouseX, mouseY)) {
            this.setActiveTooltip(new TranslationTextComponent("catalogue.gui.info").getString());
            this.tooltipYOffset = 10;
        }
        if (this.modFolderButton.func_231047_b_((double)mouseX, (double)mouseY)) {
            this.setActiveTooltip(new TranslationTextComponent("fml.button.open.mods.folder").getString());
        }
        if (this.activeTooltip != null) {
            this.renderToolTip(matrixStack, this.activeTooltip, mouseX, mouseY + this.tooltipYOffset, this.field_230712_o_);
            this.tooltipYOffset = 0;
        }
    }

    private void updateSelectedModList() {
        ModEntry selectedEntry = this.modList.getEntryFromInfo(this.selectedModInfo);
        if (selectedEntry != null) {
            this.modList.func_241215_a_(selectedEntry);
        }
    }

    private void updateSearchField(String value) {
        if (value.isEmpty()) {
            this.searchTextField.func_195612_c(new TranslationTextComponent("fml.menu.mods.search").func_230529_a_((ITextComponent)new StringTextComponent("...")).getString());
        } else {
            Optional<ModInfo> optional = net.minecraftforge.fml.ModList.get().getMods().stream().filter(info -> info.getDisplayName().toLowerCase(Locale.ENGLISH).startsWith(value.toLowerCase(Locale.ENGLISH))).min(Comparator.comparing(ModInfo::getDisplayName));
            if (optional.isPresent()) {
                int length = value.length();
                String displayName = optional.get().getDisplayName();
                this.searchTextField.func_195612_c(displayName.substring(length));
            } else {
                this.searchTextField.func_195612_c("");
            }
        }
    }

    private void drawModList(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(VERSION_CHECK_ICONS);
        CatalogueModListScreen.func_238463_a_((MatrixStack)matrixStack, (int)(this.modList.getRight() - 24), (int)10, (float)24.0f, (float)0.0f, (int)8, (int)8, (int)64, (int)16);
        this.modList.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        CatalogueModListScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent(ForgeI18n.parseMessage((String)"fml.menu.mods.title", (Object[])new Object[0])).func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.WHITE), (int)70, (int)10, (int)0xFFFFFF);
        this.searchTextField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (ScreenUtil.isMouseWithin(this.modList.getRight() - 14, 7, 14, 14, mouseX, mouseY)) {
            this.setActiveTooltip(I18n.func_135052_a((String)"fml.menu.mods.filter_updates", (Object[])new Object[0]));
            this.tooltipYOffset = 10;
        }
    }

    private void drawModInfo(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_238473_b_(matrixStack, this.modList.getRight() + 11, -1, this.field_230709_l_, -9408400);
        CatalogueModListScreen.func_238467_a_((MatrixStack)matrixStack, (int)(this.modList.getRight() + 12), (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)0x66000000);
        this.descriptionList.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        int contentLeft = this.modList.getRight() + 12 + 10;
        int contentWidth = this.field_230708_k_ - contentLeft - 10;
        if (this.selectedModInfo != null) {
            Optional authors;
            this.drawLogo(matrixStack, contentWidth, contentLeft, 10, this.field_230708_k_ - (this.modList.getRight() + 12 + 10) - 10, 50);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)contentLeft, 70.0, 0.0);
            matrixStack.func_227862_a_(2.0f, 2.0f, 2.0f);
            CatalogueModListScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.selectedModInfo.getDisplayName(), (int)0, (int)0, (int)0xFFFFFF);
            matrixStack.func_227865_b_();
            IFormattableTextComponent modId = new StringTextComponent("Mod ID: " + this.selectedModInfo.getModId()).func_240699_a_(TextFormatting.DARK_GRAY);
            int modIdWidth = this.field_230712_o_.func_238414_a_((ITextProperties)modId);
            CatalogueModListScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)modId, (int)(contentLeft + contentWidth - modIdWidth), (int)92, (int)0xFFFFFF);
            this.field_230712_o_.getClass();
            if (ScreenUtil.isMouseWithin(contentLeft + contentWidth - modIdWidth, 92, modIdWidth, 9, mouseX, mouseY)) {
                if (FMLEnvironment.secureJarsEnabled) {
                    this.setActiveTooltip(ForgeI18n.parseMessage((String)"fml.menu.mods.info.signature", (Object[])new Object[]{((ModInfo)this.selectedModInfo).getOwningFile().getCodeSigningFingerprint().orElse(ForgeI18n.parseMessage((String)"fml.menu.mods.info.signature.unsigned", (Object[])new Object[0]))}));
                    this.setActiveTooltip(ForgeI18n.parseMessage((String)"fml.menu.mods.info.trust", (Object[])new Object[]{((ModInfo)this.selectedModInfo).getOwningFile().getTrustData().orElse(ForgeI18n.parseMessage((String)"fml.menu.mods.info.trust.noauthority", (Object[])new Object[0]))}));
                } else {
                    this.setActiveTooltip(ForgeI18n.parseMessage((String)"fml.menu.mods.info.securejardisabled", (Object[])new Object[0]));
                }
            }
            this.drawStringWithLabel(matrixStack, "fml.menu.mods.info.version", this.selectedModInfo.getVersion().toString(), contentLeft, 92, contentWidth, mouseX, mouseY, TextFormatting.GRAY, TextFormatting.WHITE);
            VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)this.selectedModInfo);
            if (result.status.shouldDraw() && result.url != null) {
                String version = ForgeI18n.parseMessage((String)"fml.menu.mods.info.version", (Object[])new Object[]{this.selectedModInfo.getVersion().toString()});
                int versionWidth = this.field_230712_o_.func_78256_a(version);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(VERSION_CHECK_ICONS);
                int vOffset = result.status.isAnimated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8 : 0;
                AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(contentLeft + versionWidth + 5), (int)92, (float)(result.status.getSheetOffset() * 8), (float)vOffset, (int)8, (int)8, (int)64, (int)16);
                if (ScreenUtil.isMouseWithin(contentLeft + versionWidth + 5, 92, 8, 8, mouseX, mouseY)) {
                    this.setActiveTooltip(ForgeI18n.parseMessage((String)"fml.menu.mods.info.updateavailable", (Object[])new Object[]{result.url}));
                }
            }
            int labelOffset = this.field_230709_l_ - 20;
            String license = this.selectedModInfo.getOwningFile().getLicense();
            this.drawStringWithLabel(matrixStack, "fml.menu.mods.info.license", license, contentLeft, labelOffset, contentWidth, mouseX, mouseY, TextFormatting.GRAY, TextFormatting.WHITE);
            labelOffset -= 15;
            Optional credits = ((ModInfo)this.selectedModInfo).getConfigElement(new String[]{"credits"});
            if (credits.isPresent()) {
                this.drawStringWithLabel(matrixStack, "fml.menu.mods.info.credits", credits.get().toString(), contentLeft, labelOffset, contentWidth, mouseX, mouseY, TextFormatting.GRAY, TextFormatting.WHITE);
                labelOffset -= 15;
            }
            if ((authors = ((ModInfo)this.selectedModInfo).getConfigElement(new String[]{"authors"})).isPresent()) {
                this.drawStringWithLabel(matrixStack, "fml.menu.mods.info.authors", authors.get().toString(), contentLeft, labelOffset, contentWidth, mouseX, mouseY, TextFormatting.GRAY, TextFormatting.WHITE);
            }
        } else {
            IFormattableTextComponent message = new TranslationTextComponent("catalogue.gui.no_selection").func_240699_a_(TextFormatting.GRAY);
            CatalogueModListScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)message, (int)(contentLeft + contentWidth / 2), (int)(this.field_230709_l_ / 2 - 5), (int)0xFFFFFF);
        }
    }

    private void drawStringWithLabel(MatrixStack matrixStack, String format, String text, int x, int y, int maxWidth, int mouseX, int mouseY, TextFormatting labelColor, TextFormatting contentColor) {
        String formatted = ForgeI18n.parseMessage((String)format, (Object[])new Object[]{text});
        String label = formatted.substring(0, formatted.indexOf(":") + 1);
        String content = formatted.substring(formatted.indexOf(":") + 1);
        if (this.field_230712_o_.func_78256_a(formatted) > maxWidth) {
            content = this.field_230712_o_.func_238412_a_(content, maxWidth - this.field_230712_o_.func_78256_a(label) - 7) + "...";
            IFormattableTextComponent credits = new StringTextComponent(label).func_240699_a_(labelColor);
            credits.func_230529_a_((ITextComponent)new StringTextComponent(content).func_240699_a_(contentColor));
            CatalogueModListScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)credits, (int)x, (int)y, (int)0xFFFFFF);
            if (ScreenUtil.isMouseWithin(x, y, maxWidth, 9, mouseX, mouseY)) {
                this.setActiveTooltip(text);
            }
        } else {
            CatalogueModListScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent(label).func_240699_a_(labelColor).func_230529_a_((ITextComponent)new StringTextComponent(content).func_240699_a_(contentColor)), (int)x, (int)y, (int)0xFFFFFF);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        String version;
        int versionWidth;
        int contentLeft;
        if (ScreenUtil.isMouseWithin(10, 9, 10, 10, (int)mouseX, (int)mouseY) && button == 0) {
            this.openLink("https://www.curseforge.com/minecraft/mc-mods/catalogue");
            return true;
        }
        if (this.selectedModInfo != null && ScreenUtil.isMouseWithin((contentLeft = this.modList.getRight() + 12 + 10) + (versionWidth = this.field_230712_o_.func_78256_a(version = ForgeI18n.parseMessage((String)"fml.menu.mods.info.version", (Object[])new Object[]{this.selectedModInfo.getVersion().toString()}))) + 5, 92, 8, 8, (int)mouseX, (int)mouseY)) {
            VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)this.selectedModInfo);
            if (result.status.shouldDraw() && result.url != null) {
                Style style = Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, result.url));
                this.func_230455_a_(style);
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    private void setActiveTooltip(String content) {
        this.activeTooltip = this.field_230712_o_.func_238425_b_((ITextProperties)new StringTextComponent(content), Math.min(200, this.field_230708_k_));
        this.tooltipYOffset = 0;
    }

    private void setSelectedModInfo(IModInfo selectedModInfo) {
        this.selectedModInfo = selectedModInfo;
        this.loadAndCacheLogo(selectedModInfo);
        this.configButton.field_230694_p_ = true;
        this.websiteButton.field_230694_p_ = true;
        this.issueButton.field_230694_p_ = true;
        this.configButton.field_230693_o_ = ConfigGuiHandler.getGuiFactoryFor((ModInfo)((ModInfo)selectedModInfo)).isPresent();
        this.websiteButton.field_230693_o_ = ((ModInfo)selectedModInfo).getConfigElement(new String[]{"displayURL"}).isPresent();
        this.issueButton.field_230693_o_ = ((ModInfo)selectedModInfo).getOwningFile().getConfigElement(new String[]{"issueTrackerURL"}).isPresent();
        int contentLeft = this.modList.getRight() + 12 + 10;
        int contentWidth = this.field_230708_k_ - contentLeft - 10;
        int labelCount = this.getLabelCount(selectedModInfo);
        this.descriptionList.func_230940_a_(contentWidth, this.field_230709_l_ - 135 - 10 - labelCount * 15, 130, this.field_230709_l_ - 10 - labelCount * 15);
        this.descriptionList.func_230959_g_(contentLeft);
        this.descriptionList.setTextFromInfo(selectedModInfo);
        this.descriptionList.func_230932_a_(0.0);
    }

    private int getLabelCount(IModInfo selectedModInfo) {
        int count = 1;
        if (((ModInfo)selectedModInfo).getConfigElement(new String[]{"credits"}).isPresent()) {
            ++count;
        }
        if (((ModInfo)selectedModInfo).getConfigElement(new String[]{"authors"}).isPresent()) {
            ++count;
        }
        return count;
    }

    private void drawLogo(MatrixStack matrixStack, int contentWidth, int x, int y, int maxWidth, int maxHeight) {
        if (this.selectedModInfo != null) {
            Pair<ResourceLocation, Size2i> logoInfo;
            ResourceLocation logoResource = MISSING_BANNER;
            Size2i size = new Size2i(600, 120);
            if (LOGO_CACHE.containsKey(this.selectedModInfo.getModId()) && (logoInfo = LOGO_CACHE.get(this.selectedModInfo.getModId())).getLeft() != null) {
                logoResource = (ResourceLocation)logoInfo.getLeft();
                size = (Size2i)logoInfo.getRight();
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(logoResource);
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int width = size.width;
            int height = size.height;
            if (size.width > maxWidth) {
                width = maxWidth;
                height = width * size.height / size.width;
            }
            if (height > maxHeight) {
                height = maxHeight;
                width = height * size.width / size.height;
            }
            AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)(x += (contentWidth - width) / 2), (int)(y += (maxHeight - height) / 2), (int)width, (int)height, (float)0.0f, (float)0.0f, (int)size.width, (int)size.height, (int)size.width, (int)size.height);
        }
    }

    private void loadAndCacheLogo(IModInfo info) {
        if (LOGO_CACHE.containsKey(info.getModId())) {
            return;
        }
        LOGO_CACHE.put(info.getModId(), (Pair<ResourceLocation, Size2i>)Pair.of(null, (Object)new Size2i(0, 0)));
        ModInfo modInfo = (ModInfo)info;
        modInfo.getLogoFile().ifPresent(s -> {
            if (s.isEmpty()) {
                return;
            }
            if (s.contains("/") || s.contains("\\")) {
                Catalogue.LOGGER.warn("Skipped loading logo file from {}. The file name '{}' contained illegal characters '/' or '\\'", (Object)info.getDisplayName(), s);
                return;
            }
            ModFileResourcePack resourcePack = (ModFileResourcePack)ResourcePackLoader.getResourcePackFor((String)info.getModId()).orElse(ResourcePackLoader.getResourcePackFor((String)"forge").orElseThrow(() -> new RuntimeException("Can't find forge, WHAT!")));
            try (InputStream is = resourcePack.func_195763_b(s);
                 NativeImage logo = NativeImage.func_195713_a((InputStream)is);){
                TextureManager textureManager = this.getMinecraft().func_110434_K();
                LOGO_CACHE.put(info.getModId(), (Pair<ResourceLocation, Size2i>)Pair.of((Object)textureManager.func_110578_a("modlogo", this.createLogoTexture(logo, modInfo.getLogoBlur())), (Object)new Size2i(logo.func_195702_a(), logo.func_195714_b())));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    /*
     * Exception decompiling
     */
    private void loadAndCacheIcon(IModInfo info) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private DynamicTexture createLogoTexture(final NativeImage image, final boolean smooth) {
        return new DynamicTexture(image){

            public void func_110564_a() {
                this.func_229148_d_();
                image.func_227789_a_(0, 0, 0, 0, 0, image.func_195702_a(), image.func_195714_b(), smooth, false, false, false);
            }
        };
    }

    private /* synthetic */ void lambda$loadAndCacheIcon$17(IModInfo info, ModInfo modInfo, String s) {
        if (s.isEmpty()) {
            return;
        }
        if (s.contains("/") || s.contains("\\")) {
            Catalogue.LOGGER.warn("Skipped loading logo file from {}. The file name '{}' contained illegal characters '/' or '\\'", (Object)info.getDisplayName(), (Object)s);
            return;
        }
        ModFileResourcePack resourcePack = (ModFileResourcePack)ResourcePackLoader.getResourcePackFor((String)info.getModId()).orElse(ResourcePackLoader.getResourcePackFor((String)"forge").orElseThrow(() -> new RuntimeException("Can't find forge, WHAT!")));
        try (InputStream is = resourcePack.func_195763_b(s);
             NativeImage logo = NativeImage.func_195713_a((InputStream)is);){
            if (logo.func_195702_a() == logo.func_195714_b()) {
                TextureManager textureManager = this.getMinecraft().func_110434_K();
                String modId = info.getModId();
                if (LOGO_CACHE.containsKey(modId) && LOGO_CACHE.get(modId).getLeft() != null) {
                    ICON_CACHE.put(modId, LOGO_CACHE.get(modId));
                    return;
                }
                DynamicTexture texture = this.createLogoTexture(logo, modInfo.getLogoBlur());
                Size2i size = new Size2i(logo.func_195702_a(), logo.func_195714_b());
                ResourceLocation textureId = textureManager.func_110578_a("catalogueicon", texture);
                ICON_CACHE.put(modId, (Pair<ResourceLocation, Size2i>)Pair.of((Object)textureId, (Object)size));
                LOGO_CACHE.put(modId, (Pair<ResourceLocation, Size2i>)Pair.of((Object)textureId, (Object)size));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static /* synthetic */ RuntimeException lambda$loadAndCacheIcon$15() {
        return new RuntimeException("Can't find forge, WHAT!");
    }

    private class StringEntry
    extends AbstractList.AbstractListEntry<StringEntry> {
        private String line;

        public StringEntry(String line) {
            this.line = line;
        }

        public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)CatalogueModListScreen.this.field_230712_o_, (String)this.line, (int)left, (int)top, (int)0xFFFFFF);
        }
    }

    private class StringList
    extends ExtendedList<StringEntry> {
        public StringList(int width, int height, int left, int top) {
            super(CatalogueModListScreen.this.field_230706_i_, width, CatalogueModListScreen.this.field_230709_l_, top, top + height, 10);
            this.func_230959_g_(left);
        }

        public void setTextFromInfo(IModInfo info) {
            this.func_230963_j_();
            CatalogueModListScreen.this.field_230712_o_.func_238420_b_().func_238365_g_(info.getDescription().trim(), this.func_230949_c_(), Style.field_240709_b_).forEach(text -> this.func_230513_b_(new StringEntry(text.getString().replace("\n", "").replace("\r", "").trim())));
        }

        public void setSelected(@Nullable StringEntry entry) {
        }

        protected int func_230952_d_() {
            return this.getLeft() + this.field_230670_d_ - 7;
        }

        public int func_230968_n_() {
            return this.getLeft();
        }

        public int func_230949_c_() {
            return this.field_230670_d_ - 10;
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            ScreenUtil.scissor(this.func_230968_n_(), this.getTop(), this.getWidth(), this.getBottom() - this.getTop());
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            RenderSystem.disableScissor();
        }
    }

    private class ModEntry
    extends AbstractList.AbstractListEntry<ModEntry> {
        private final IModInfo info;
        private final ModList list;

        public ModEntry(IModInfo info, ModList list) {
            this.info = info;
            this.list = list;
        }

        public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            AbstractGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)CatalogueModListScreen.this.field_230712_o_, (ITextComponent)this.getFormattedModName(), (int)(left + 24), (int)(top + 2), (int)0xFFFFFF);
            AbstractGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)CatalogueModListScreen.this.field_230712_o_, (ITextComponent)new StringTextComponent(this.info.getVersion().toString()).func_240699_a_(TextFormatting.GRAY), (int)(left + 24), (int)(top + 12), (int)0xFFFFFF);
            CatalogueModListScreen.this.loadAndCacheIcon(this.info);
            if (ICON_CACHE.containsKey(this.info.getModId()) && ((Pair)ICON_CACHE.get(this.info.getModId())).getLeft() != null) {
                ResourceLocation logoResource = TextureManager.field_194008_a;
                Size2i size = new Size2i(16, 16);
                Pair logoInfo = (Pair)ICON_CACHE.get(this.info.getModId());
                if (logoInfo != null && logoInfo.getLeft() != null) {
                    logoResource = (ResourceLocation)logoInfo.getLeft();
                    size = (Size2i)logoInfo.getRight();
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(logoResource);
                RenderSystem.enableBlend();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)(left + 4), (int)(top + 2), (int)16, (int)16, (float)0.0f, (float)0.0f, (int)size.width, (int)size.height, (int)size.width, (int)size.height);
            } else {
                CatalogueModListScreen.this.getMinecraft().func_175599_af().func_175042_a(new ItemStack((IItemProvider)this.getItemIcon()), left + 4, top + 2);
            }
            VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)this.info);
            if (result.status.shouldDraw()) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(VERSION_CHECK_ICONS);
                int vOffset = result.status.isAnimated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8 : 0;
                AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(left + rowWidth - 8 - 10), (int)(top + 6), (float)(result.status.getSheetOffset() * 8), (float)vOffset, (int)8, (int)8, (int)64, (int)16);
            }
        }

        private Item getItemIcon() {
            Item item2;
            ResourceLocation resource;
            if (ITEM_CACHE.containsKey(this.info.getModId())) {
                return (Item)ITEM_CACHE.get(this.info.getModId());
            }
            ITEM_CACHE.put(this.info.getModId(), Items.field_221581_i);
            if (this.info.getModId().equals("forge")) {
                ITEM_CACHE.put("forge", Items.field_221844_ef);
                return Items.field_221844_ef;
            }
            String itemIcon = (String)this.info.getModProperties().get("catalogueItemIcon");
            if (itemIcon == null) {
                itemIcon = ((ModInfo)this.info).getConfigElement(new String[]{"itemIcon"}).orElse("");
            }
            if (!itemIcon.isEmpty() && (resource = ResourceLocation.func_208304_a((String)itemIcon)) != null && (item2 = (Item)ForgeRegistries.ITEMS.getValue(resource)) != null) {
                ITEM_CACHE.put(this.info.getModId(), item2);
                return item2;
            }
            Optional<Item> optional = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.getRegistryName().func_110624_b().equals(this.info.getModId())).findFirst();
            if (optional.isPresent() && (item2 = optional.get()) != Items.field_190931_a) {
                ITEM_CACHE.put(this.info.getModId(), item2);
                return item2;
            }
            return Items.field_221581_i;
        }

        private ITextComponent getFormattedModName() {
            String name = this.info.getDisplayName();
            int width = this.list.func_230949_c_() - (this.list.func_230955_e_() > 0 ? 30 : 24);
            if (CatalogueModListScreen.this.field_230712_o_.func_78256_a(name) > width) {
                name = CatalogueModListScreen.this.field_230712_o_.func_238412_a_(name, width - 10) + "...";
            }
            StringTextComponent title = new StringTextComponent(name);
            if (this.info.getModId().equals("forge") || this.info.getModId().equals("minecraft")) {
                title.func_240699_a_(TextFormatting.DARK_GRAY);
            }
            return title;
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            CatalogueModListScreen.this.setSelectedModInfo(this.info);
            this.list.func_241215_a_(this);
            return false;
        }

        public IModInfo getInfo() {
            return this.info;
        }
    }

    private class ModList
    extends ExtendedList<ModEntry> {
        public ModList() {
            super(CatalogueModListScreen.this.field_230706_i_, 150, CatalogueModListScreen.this.field_230709_l_, 46, CatalogueModListScreen.this.field_230709_l_ - 35, 26);
        }

        protected int func_230952_d_() {
            return super.getLeft() + this.field_230670_d_ - 6;
        }

        public int func_230968_n_() {
            return super.getLeft();
        }

        public int func_230949_c_() {
            return this.field_230670_d_;
        }

        public void filterAndUpdateList(String text) {
            List entries = net.minecraftforge.fml.ModList.get().getMods().stream().filter(info -> info.getDisplayName().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH))).filter(info -> !CatalogueModListScreen.this.updatesButton.func_212942_a() || VersionChecker.getResult((IModInfo)info).status.shouldDraw()).map(info -> new ModEntry((IModInfo)info, this)).sorted(SORT).collect(Collectors.toList());
            this.func_230942_a_(entries);
            this.func_230932_a_(0.0);
        }

        @Nullable
        public ModEntry getEntryFromInfo(IModInfo info) {
            return this.func_231039_at__().stream().filter(entry -> ((ModEntry)entry).info == info).findFirst().orElse(null);
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            ScreenUtil.scissor(this.func_230968_n_(), this.getTop(), this.getWidth(), this.getBottom() - this.getTop());
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            RenderSystem.disableScissor();
        }

        public boolean func_231046_a_(int key, int scanCode, int modifiers) {
            if (key == 257 && this.func_230958_g_() != null) {
                CatalogueModListScreen.this.setSelectedModInfo(((ModEntry)this.func_230958_g_()).info);
                SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
                handler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                return true;
            }
            return super.func_231046_a_(key, scanCode, modifiers);
        }

        public void centerScrollOn(ModEntry entry) {
            super.func_230951_c_((AbstractList.AbstractListEntry)entry);
        }
    }
}

