/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.network.packet;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.ingredient.storage.IngredientComponentStorageWrapperHandlerItemStack;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemStackCraftingGridClear;

public class TerminalStorageIngredientItemStackCraftingGridSetRecipe
extends PacketCodec {
    @CodecField
    private String tabId;
    @CodecField
    private int channel;
    @CodecField
    private boolean maxTransfer;
    private Map<Integer, Pair<ItemStack, Integer>> slottedIngredientsFromPlayer;
    private Map<Integer, List<Pair<ItemStack, Integer>>> slottedIngredientsFromStorage;

    public TerminalStorageIngredientItemStackCraftingGridSetRecipe() {
    }

    public TerminalStorageIngredientItemStackCraftingGridSetRecipe(String tabId, int channel, boolean maxTransfer, Map<Integer, Pair<ItemStack, Integer>> slottedIngredientsFromPlayer, Map<Integer, List<Pair<ItemStack, Integer>>> slottedIngredientsFromStorage) {
        this.tabId = tabId;
        this.channel = channel;
        this.maxTransfer = maxTransfer;
        this.slottedIngredientsFromPlayer = slottedIngredientsFromPlayer;
        this.slottedIngredientsFromStorage = slottedIngredientsFromStorage;
    }

    public void encode(PacketBuffer output) {
        super.encode(output);
        output.writeInt(this.slottedIngredientsFromPlayer.size());
        for (Map.Entry<Integer, Pair<ItemStack, Integer>> entry : this.slottedIngredientsFromPlayer.entrySet()) {
            output.writeInt(entry.getKey().intValue());
            output.func_150788_a((ItemStack)entry.getValue().getLeft());
            output.writeInt(((Integer)entry.getValue().getRight()).intValue());
        }
        output.writeInt(this.slottedIngredientsFromStorage.size());
        for (Map.Entry<Integer, Object> entry : this.slottedIngredientsFromStorage.entrySet()) {
            output.writeInt(entry.getKey().intValue());
            output.writeInt(((List)entry.getValue()).size());
            for (Pair subEntry : (List)entry.getValue()) {
                output.func_150788_a((ItemStack)subEntry.getLeft());
                output.writeInt(((Integer)subEntry.getRight()).intValue());
            }
        }
    }

    public void decode(PacketBuffer input) {
        super.decode(input);
        int entriesSlottedIngredientsFromPlayer = input.readInt();
        this.slottedIngredientsFromPlayer = Maps.newHashMap();
        for (int i = 0; i < entriesSlottedIngredientsFromPlayer; ++i) {
            this.slottedIngredientsFromPlayer.put(input.readInt(), (Pair<ItemStack, Integer>)Pair.of((Object)input.func_150791_c(), (Object)input.readInt()));
        }
        int entriesSlottedIngredientsFromStorage = input.readInt();
        this.slottedIngredientsFromStorage = Maps.newHashMap();
        for (int i = 0; i < entriesSlottedIngredientsFromStorage; ++i) {
            int key = input.readInt();
            int entries = input.readInt();
            ArrayList alternatives = Lists.newArrayListWithExpectedSize((int)entries);
            for (int j = 0; j < entries; ++j) {
                alternatives.add(Pair.of((Object)input.func_150791_c(), (Object)input.readInt()));
            }
            this.slottedIngredientsFromStorage.put(key, alternatives);
        }
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(World world, PlayerEntity player) {
    }

    public void actionServer(World world, ServerPlayerEntity player) {
        ContainerTerminalStorageBase container;
        ITerminalStorageTabCommon tabCommon;
        if (player.field_71070_bA instanceof ContainerTerminalStorageBase && (tabCommon = (container = (ContainerTerminalStorageBase)player.field_71070_bA).getTabCommon(this.tabId)) instanceof TerminalStorageTabIngredientComponentItemStackCraftingCommon) {
            Slot slot;
            TerminalStorageTabIngredientComponentServer tabServerCrafting = (TerminalStorageTabIngredientComponentServer)container.getTabServer(this.tabId);
            TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommonCrafting = (TerminalStorageTabIngredientComponentItemStackCraftingCommon)tabCommon;
            int slotOffset = tabCommonCrafting.getSlotCrafting().field_75222_d;
            TerminalStorageIngredientItemStackCraftingGridClear.clearGrid(tabCommonCrafting, tabServerCrafting, this.channel, true, (PlayerEntity)player);
            IngredientComponentStorageWrapperHandlerItemStack.ComponentStorageWrapper playerInventory = new IngredientComponentStorageWrapperHandlerItemStack.ComponentStorageWrapper(IngredientComponent.ITEMSTACK, (IItemHandler)new InvWrapper((IInventory)player.field_71071_by));
            for (Map.Entry<Integer, Pair<ItemStack, Integer>> entry : this.slottedIngredientsFromPlayer.entrySet()) {
                Integer matchCondition = (Integer)entry.getValue().getRight();
                ItemStack extracted = playerInventory.extract((ItemStack)entry.getValue().getLeft(), matchCondition, false);
                slot = container.func_75139_a(entry.getKey() + slotOffset);
                slot.func_75215_d(extracted);
            }
            IIngredientComponentStorage storage = tabServerCrafting.getIngredientNetwork().getChannel(this.channel);
            for (Map.Entry<Integer, List<Pair<ItemStack, Integer>>> entry : this.slottedIngredientsFromStorage.entrySet()) {
                int slotId = entry.getKey() + slotOffset;
                slot = container.func_75139_a(slotId);
                if (slot.func_75216_d()) continue;
                ItemStack extracted = ItemStack.field_190927_a;
                for (Pair<ItemStack, Integer> stackEntry : entry.getValue()) {
                    int matchCondition = (Integer)stackEntry.getRight();
                    extracted = (ItemStack)storage.extract(stackEntry.getLeft(), (Object)matchCondition, false);
                    if (extracted.func_190926_b()) continue;
                    break;
                }
                if (extracted.func_190926_b()) continue;
                slot.func_75215_d(extracted);
            }
        }
    }
}

