/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.api.terminalstorage.TerminalClickType;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class TerminalStorageIngredientSlotClickPacket<T>
extends PacketCodec {
    @CodecField
    private String tabId;
    @CodecField
    private String ingredientName;
    @CodecField
    private int clickType;
    @CodecField
    private int channel;
    @CodecField
    private CompoundNBT hoveringStorageInstanceData;
    @CodecField
    private int hoveredContainerSlot;
    @CodecField
    private long moveQuantityPlayerSlot;
    @CodecField
    private CompoundNBT activeStorageInstanceData;
    @CodecField
    private boolean transferFullSelection;

    public TerminalStorageIngredientSlotClickPacket() {
    }

    public TerminalStorageIngredientSlotClickPacket(String tabId, IngredientComponent<T, ?> component, TerminalClickType clickType, int channel, T hoveringStorageInstance, int hoveredContainerSlot, long moveQuantityPlayerSlot, T activeStorageInstance, boolean transferFullSelection) {
        this.tabId = tabId;
        this.clickType = clickType.ordinal();
        this.ingredientName = component.getName().toString();
        this.channel = channel;
        this.hoveringStorageInstanceData = new CompoundNBT();
        IIngredientSerializer serializer = this.getComponent().getSerializer();
        this.hoveringStorageInstanceData.func_218657_a("i", serializer.serializeInstance(hoveringStorageInstance));
        this.hoveredContainerSlot = hoveredContainerSlot;
        this.moveQuantityPlayerSlot = moveQuantityPlayerSlot;
        this.activeStorageInstanceData = new CompoundNBT();
        this.activeStorageInstanceData.func_218657_a("i", serializer.serializeInstance(activeStorageInstance));
        this.transferFullSelection = transferFullSelection;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(World world, PlayerEntity player) {
    }

    public void actionServer(World world, ServerPlayerEntity player) {
        if (player.field_71070_bA instanceof ContainerTerminalStorageBase) {
            ContainerTerminalStorageBase container = (ContainerTerminalStorageBase)player.field_71070_bA;
            TerminalStorageTabIngredientComponentServer tab = (TerminalStorageTabIngredientComponentServer)container.getTabServer(this.tabId);
            IIngredientSerializer serializer = this.getComponent().getSerializer();
            Object hoveringStorageInstance = serializer.deserializeInstance(this.hoveringStorageInstanceData.func_74781_a("i"));
            Object activeInstance = serializer.deserializeInstance(this.activeStorageInstanceData.func_74781_a("i"));
            tab.handleStorageSlotClick((Container)container, player, this.getClickType(), this.getChannel(), hoveringStorageInstance, this.hoveredContainerSlot, this.moveQuantityPlayerSlot, activeInstance, this.transferFullSelection);
        }
    }

    public TerminalClickType getClickType() {
        return TerminalClickType.values()[this.clickType];
    }

    public IngredientComponent<T, ?> getComponent() {
        IngredientComponent ingredientComponent = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(this.ingredientName));
        if (ingredientComponent == null) {
            throw new IllegalArgumentException("No ingredient component with the given name was found: " + this.ingredientName);
        }
        return ingredientComponent;
    }

    public int getChannel() {
        return this.channel;
    }
}

