/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.core.client.gui.CraftingJobGuiData;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingPlan;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalCraftingJobsPlan;
import org.cyclops.integratedterminals.part.PartTypeTerminalCraftingJob;
import org.cyclops.integratedterminals.part.PartTypes;

public class OpenCraftingJobsPlanGuiPacket
extends PacketCodec {
    @CodecField
    private BlockPos pos;
    @CodecField
    private Direction side;
    @CodecField
    private int channel;
    @CodecField
    private String craftingPlanHandler;
    @CodecField
    private CompoundNBT craftingJobId;

    public OpenCraftingJobsPlanGuiPacket() {
    }

    public OpenCraftingJobsPlanGuiPacket(CraftingJobGuiData craftingPlanGuiData) {
        this.pos = craftingPlanGuiData.getPos();
        this.side = craftingPlanGuiData.getSide();
        this.channel = craftingPlanGuiData.getChannel();
        this.craftingPlanHandler = craftingPlanGuiData.getHandler().getId().toString();
        this.craftingJobId = new CompoundNBT();
        this.craftingJobId.func_218657_a("id", craftingPlanGuiData.getHandler().serializeCraftingJobId(craftingPlanGuiData.getCraftingJob()));
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(World world, PlayerEntity player) {
    }

    public void actionServer(World world, ServerPlayerEntity player) {
        ITerminalStorageTabIngredientCraftingHandler handler = this.getHandler();
        final CraftingJobGuiData craftingJobGuiData = new CraftingJobGuiData(this.pos, this.side, this.channel, handler, handler.deserializeCraftingJobId(this.craftingJobId.func_74781_a("id")));
        final PartPos partPos = PartPos.of((World)world, (BlockPos)this.pos, (Direction)this.side);
        INamedContainerProvider containerProvider = new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("");
            }

            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)partPos);
                return new ContainerTerminalCraftingJobsPlan(id, playerInventory, (PartTarget)data.getRight(), Optional.of(data.getLeft()), (PartTypeTerminalCraftingJob)((Object)data.getMiddle()), craftingJobGuiData);
            }
        };
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)containerProvider, packetBuffer -> {
            PacketCodec.write((PacketBuffer)packetBuffer, (Object)partPos);
            packetBuffer.func_180714_a(PartTypes.TERMINAL_CRAFTING_JOB.getUniqueName().toString());
            craftingJobGuiData.writeToPacketBuffer((PacketBuffer)packetBuffer);
        });
    }

    protected ITerminalStorageTabIngredientCraftingHandler getHandler() {
        return TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandler(new ResourceLocation(this.craftingPlanHandler));
    }

    public static void send(BlockPos pos, Direction side, int channel, HandlerWrappedTerminalCraftingPlan craftingPlan) {
        CraftingJobGuiData data = new CraftingJobGuiData(pos, side, channel, craftingPlan.getHandler(), craftingPlan.getCraftingPlan().getId());
        IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new OpenCraftingJobsPlanGuiPacket(data));
    }
}

