/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.quantumstorage.tiles.chests;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gigabit101.quantumstorage.init.QSBlocks;
import net.gigabit101.quantumstorage.util.inventory.ItemUtils;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileChestBase
extends TileEntity
implements INamedContainerProvider {
    public ItemStackHandler inventory;
    int slots;

    public TileChestBase(TileEntityType<?> tileEntityTypeIn, int slots) {
        super(tileEntityTypeIn);
        this.slots = slots;
        this.inventory = new ItemStackHandler(slots);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("inv")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inv"));
            if (this.inventory.getSlots() != this.slots) {
                this.fixInventory();
            }
        }
    }

    private void fixInventory() {
        ItemStackHandler oldInventory = this.inventory;
        this.inventory = new ItemStackHandler(this.slots);
        for (int slot = 0; slot < oldInventory.getSlots(); ++slot) {
            if (slot < this.inventory.getSlots()) {
                this.inventory.setStackInSlot(slot, oldInventory.getStackInSlot(slot));
                continue;
            }
            if (this.func_145831_w() != null) {
                ItemUtils.dropItem(oldInventory.getStackInSlot(slot), this.func_145831_w(), this.func_174877_v(), true, 10);
                continue;
            }
            System.out.println("[quantumstorage] couldn't drop stack which was exceded crate limit");
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void writeToNBTWithoutCoords(CompoundNBT tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        if (this.inventory != null) {
            tagCompound.func_197643_a(this.inventory.serializeNBT());
        }
    }

    public void readFromNBTWithoutCoords(CompoundNBT compound) {
        this.inventory.deserializeNBT(compound);
    }

    public ItemStack getDropWithNBT() {
        CompoundNBT tileEntityNBT = new CompoundNBT();
        ItemStack dropStack = new ItemStack((IItemProvider)QSBlocks.CHEST_IRON.get(), 1);
        this.writeToNBTWithoutCoords(tileEntityNBT);
        dropStack.func_196082_o().func_218657_a("tileEntity", (INBT)tileEntityNBT);
        return dropStack;
    }
}

