/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.quantumstorage.tiles;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gigabit101.quantumstorage.containers.ContainerQSU;
import net.gigabit101.quantumstorage.init.QSBlocks;
import net.gigabit101.quantumstorage.inventory.DsuInventoryHandler;
import net.gigabit101.quantumstorage.network.VanillaPacketDispatcher;
import net.gigabit101.quantumstorage.util.inventory.ItemUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class TileQsu
extends TileEntity
implements INamedContainerProvider,
ITickableTileEntity {
    int INPUT = 0;
    int STORAGE = 1;
    int OUTPUT = 2;
    public ItemStack lockedStack = ItemStack.field_190927_a;
    public DsuInventoryHandler inventory = new DsuInventoryHandler(this.lockedStack);
    public boolean isLocked = false;

    public TileQsu() {
        super((TileEntityType)QSBlocks.QSU_TILE.get());
    }

    public void onLoad() {
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
    }

    public void func_73660_a() {
        try {
            if (!this.inventory.getStackInSlot(this.INPUT).func_190926_b()) {
                if (this.inventory.getStackInSlot(this.STORAGE).func_190926_b() && (this.inventory.getStackInSlot(this.OUTPUT).func_190926_b() || ItemUtils.isItemEqual(this.inventory.getStackInSlot(this.INPUT), this.inventory.getStackInSlot(this.OUTPUT), true))) {
                    this.inventory.setStackInSlot(this.STORAGE, this.inventory.getStackInSlot(this.INPUT).func_77946_l());
                    this.inventory.setStackInSlot(this.INPUT, ItemStack.field_190927_a);
                } else if (!this.inventory.getStackInSlot(this.STORAGE).func_190926_b() && ItemUtils.isItemEqual(this.inventory.getStackInSlot(this.INPUT), this.inventory.getStackInSlot(this.STORAGE), true)) {
                    this.inventory.getStackInSlot(this.STORAGE).func_190917_f(this.inventory.getStackInSlot(this.INPUT).func_190916_E());
                    this.inventory.setStackInSlot(this.INPUT, ItemStack.field_190927_a);
                }
            }
            if (!this.inventory.getStackInSlot(this.STORAGE).func_190926_b()) {
                int size = this.inventory.getStackInSlot(this.STORAGE).func_77976_d();
                if (this.inventory.getStackInSlot(this.OUTPUT) == ItemStack.field_190927_a || this.inventory.getStackInSlot(this.OUTPUT).func_190916_E() == 0) {
                    if (this.inventory.getStackInSlot(this.STORAGE).func_190916_E() >= size) {
                        this.inventory.setStackInSlot(this.OUTPUT, this.inventory.getStackInSlot(this.STORAGE).func_77946_l());
                        this.inventory.getStackInSlot(this.OUTPUT).func_190920_e(size);
                        this.inventory.getStackInSlot(this.STORAGE).func_190918_g(size);
                    } else {
                        this.inventory.setStackInSlot(this.OUTPUT, this.inventory.getStackInSlot(this.STORAGE));
                        this.inventory.setStackInSlot(this.STORAGE, ItemStack.field_190927_a);
                    }
                }
                if (this.inventory.getStackInSlot(this.STORAGE).func_190916_E() != 0 && ItemUtils.isItemEqual(this.inventory.getStackInSlot(this.STORAGE), this.inventory.getStackInSlot(this.OUTPUT), true) && this.inventory.getStackInSlot(this.OUTPUT).func_190916_E() <= size - 1) {
                    this.inventory.getStackInSlot(this.OUTPUT).func_190917_f(1);
                    this.inventory.getStackInSlot(this.STORAGE).func_190918_g(1);
                }
            }
            if (this.field_145850_b.func_175625_s(this.field_174879_c) != null) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        this.deserializeNBT(packet.func_148857_g());
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.inventory.deserializeNBT(compound);
        this.isLocked = compound.func_74767_n("locked");
        if (!compound.func_74775_l("lockeditem").isEmpty()) {
            ItemStack stack;
            this.lockedStack = stack = TileQsu.readItemStack(compound.func_74775_l("lockeditem"));
            this.inventory.updateLockedStack(stack);
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound.func_197643_a(this.inventory.serializeNBT());
        compound.func_74757_a("locked", this.isLocked);
        compound.func_218657_a("lockeditem", (INBT)TileQsu.writeItemStack(this.lockedStack));
        return compound;
    }

    private static CompoundNBT writeItemStack(ItemStack i) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("count", i.func_190916_E());
        nbt.func_74778_a("item", i.func_77973_b().getRegistryName().toString());
        nbt.func_74774_a("type", (byte)0);
        return nbt;
    }

    private static ItemStack readItemStack(CompoundNBT compound) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.func_74779_i("item")));
        int count = compound.func_74762_e("count");
        return new ItemStack((IItemProvider)item, count);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("tile.qsu.name");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerQSU(id, playerEntity.field_71071_by, this);
    }

    public boolean isLocked(TileQsu tileQsu) {
        return tileQsu.isLocked;
    }

    public void setLocked(TileQsu tileQsu) {
        tileQsu.isLocked = true;
        tileQsu.lockedStack = tileQsu.inventory.getStackInSlot(2);
        this.inventory.updateLockedStack(tileQsu.lockedStack);
    }

    public void setUnlocked(TileQsu tileQsu) {
        tileQsu.isLocked = false;
        tileQsu.lockedStack = ItemStack.field_190927_a;
    }

    public void writeToNBTWithoutCoords(CompoundNBT tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        if (this.inventory != null) {
            tagCompound.func_197643_a(this.inventory.serializeNBT());
        }
        tagCompound.func_74757_a("locked", this.isLocked);
    }

    public void readFromNBTWithoutCoords(CompoundNBT compound) {
        this.inventory.deserializeNBT(compound);
        this.isLocked = compound.func_74767_n("locked");
    }

    public ItemStack getDropWithNBT() {
        CompoundNBT tileEntity = new CompoundNBT();
        ItemStack dropStack = new ItemStack((IItemProvider)QSBlocks.QSU.get(), 1);
        this.writeToNBTWithoutCoords(tileEntity);
        dropStack.func_77982_d(new CompoundNBT());
        dropStack.func_77978_p().func_218657_a("tileEntity", (INBT)tileEntity);
        return dropStack;
    }
}

