/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.quantumstorage.tiles;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gigabit101.quantumstorage.init.QSBlocks;
import net.gigabit101.quantumstorage.inventory.ControllerItemHandler;
import net.gigabit101.quantumstorage.network.VanillaPacketDispatcher;
import net.gigabit101.quantumstorage.tiles.TileQsu;
import net.gigabit101.quantumstorage.util.inventory.ItemUtils;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileController
extends TileEntity {
    List<BlockPos> connectedTiles = new ArrayList<BlockPos>();
    public ControllerItemHandler inventory = new ControllerItemHandler(this);
    public int maxConnections = 180;

    public TileController() {
        super((TileEntityType)QSBlocks.CONTROLLER_TILE.get());
    }

    public void onLoad() {
        this.inventory.setSize(this.connectedTiles.size());
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
    }

    public boolean connectTileToController(BlockPos connectPos) {
        if (this.field_145850_b.func_175625_s(connectPos) != null && this.field_145850_b.func_175625_s(connectPos) instanceof TileQsu && this.connectedTiles.size() < this.maxConnections) {
            for (BlockPos blockPos : this.connectedTiles) {
                if (!this.blockPosMatches(connectPos, blockPos)) continue;
                return false;
            }
            this.connectedTiles.add(connectPos);
            this.inventory.setSize(this.connectedTiles.size());
            return true;
        }
        return false;
    }

    public boolean removeConnection(BlockPos connectPos) {
        if (!this.connectedTiles.isEmpty()) {
            for (int i = 0; i < this.connectedTiles.size(); ++i) {
                BlockPos posi = this.connectedTiles.get(i);
                if (!this.blockPosMatches(connectPos, posi)) continue;
                this.connectedTiles.remove(i);
                return true;
            }
        }
        return false;
    }

    public boolean blockPosMatches(BlockPos pos1, BlockPos pos2) {
        return pos1.func_177958_n() == pos2.func_177958_n() && pos1.func_177956_o() == pos2.func_177956_o() && pos1.func_177952_p() == pos2.func_177952_p();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.deserializeNBT(compound);
        this.inventory.deserializeNBT(compound);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound.func_197643_a(this.serializeNBT());
        compound.func_197643_a(this.inventory.serializeNBT());
        return compound;
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return stack;
        }
        if (this.connectedTiles.isEmpty()) {
            return stack;
        }
        for (BlockPos pos1 : this.getConnectedTiles()) {
            if (pos1 == null || !this.validateConnection(pos1)) continue;
            TileQsu tileQsu = (TileQsu)this.field_145850_b.func_175625_s(pos1);
            ItemStack insert = ItemHandlerHelper.insertItem((IItemHandler)tileQsu.inventory, (ItemStack)stack, (boolean)simulate);
            if (ItemUtils.isItemEqual(insert, stack, false)) continue;
            return insert;
        }
        return stack;
    }

    public ItemStack extractItem(int slotID, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        if (this.connectedTiles == null) {
            return ItemStack.field_190927_a;
        }
        if (this.connectedTiles.get(slotID) == null) {
            return ItemStack.field_190927_a;
        }
        if (this.validateConnection(this.connectedTiles.get(slotID))) {
            TileQsu tileQsu = (TileQsu)this.field_145850_b.func_175625_s(this.connectedTiles.get(slotID));
            return tileQsu.inventory.extractItem(2, amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getStackInSlot(int slotID) {
        if (this.connectedTiles == null) {
            return ItemStack.field_190927_a;
        }
        if (this.connectedTiles.get(slotID) == null) {
            return ItemStack.field_190927_a;
        }
        if (this.validateConnection(this.connectedTiles.get(slotID))) {
            TileQsu tileQsu = (TileQsu)this.field_145850_b.func_175625_s(this.connectedTiles.get(slotID));
            int amount = tileQsu.inventory.getStackInSlot(0).func_190916_E() + tileQsu.inventory.getStackInSlot(1).func_190916_E() + tileQsu.inventory.getStackInSlot(2).func_190916_E();
            ItemStack stackOut = tileQsu.inventory.getStackInSlot(2).func_77946_l();
            stackOut.func_190920_e(amount);
            return stackOut;
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        if (this.connectedTiles.isEmpty()) {
            return 0;
        }
        if (this.connectedTiles.get(slot) == null) {
            return 0;
        }
        if (this.validateConnection(this.connectedTiles.get(slot))) {
            TileQsu tileQsu = (TileQsu)this.field_145850_b.func_175625_s(this.connectedTiles.get(slot));
            return tileQsu.inventory.getSlotLimit(2);
        }
        return 0;
    }

    public boolean validateConnection(BlockPos blockPos) {
        if (blockPos == null) {
            return false;
        }
        if (!this.field_145850_b.func_175667_e(blockPos)) {
            return false;
        }
        if (this.field_145850_b.func_175625_s(blockPos) == null) {
            return false;
        }
        return this.field_145850_b.func_175625_s(blockPos) instanceof TileQsu;
    }

    public CompoundNBT serializeNBT() {
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < this.connectedTiles.size(); ++i) {
            if (this.connectedTiles.get(i) == null) continue;
            CompoundNBT posTag = new CompoundNBT();
            posTag.func_74768_a("X", this.connectedTiles.get(i).func_177958_n());
            posTag.func_74768_a("Y", this.connectedTiles.get(i).func_177956_o());
            posTag.func_74768_a("Z", this.connectedTiles.get(i).func_177952_p());
            nbtTagList.add((Object)posTag);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("connections", (INBT)nbtTagList);
        nbt.func_74768_a("Size", this.connectedTiles.size());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        ListNBT tagList = nbt.func_150295_c("connections", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT itemTags = tagList.func_150305_b(i);
            BlockPos pos = new BlockPos(itemTags.func_74762_e("X"), itemTags.func_74762_e("Y"), itemTags.func_74762_e("Z"));
            this.connectedTiles.add(pos);
        }
        this.onLoad();
    }

    public List<BlockPos> getConnectedTiles() {
        return this.connectedTiles;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        return super.getCapability(cap, side);
    }
}

