/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.quantumstorage.items.backpack;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.gigabit101.quantumstorage.api.IColorable;
import net.gigabit101.quantumstorage.client.CreativeTabQuantumStorage;
import net.gigabit101.quantumstorage.containers.ContainerBag;
import net.gigabit101.quantumstorage.items.prefab.ItemBase;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemStackHandler;

public class ItemQuantumBag
extends ItemBase
implements IColorable,
INamedContainerProvider {
    private static final Map<DyeColor, ItemQuantumBag> COLOR_DYE_ITEM_MAP = Maps.newEnumMap(DyeColor.class);
    private final DyeColor dyeColor;
    protected final int colour;

    public ItemQuantumBag(DyeColor dyeColor) {
        super(new Item.Properties().func_200917_a(1).func_200916_a((ItemGroup)CreativeTabQuantumStorage.INSTANCE));
        int value;
        this.dyeColor = dyeColor;
        this.setRegistryName("quantumstorage", "quantum_bag_" + dyeColor.func_176762_d());
        float[] vals = dyeColor.func_193349_f();
        int[] rgb = new int[3];
        for (int i = 0; i < 3; ++i) {
            rgb[i] = (int)(255.0f * vals[i]);
        }
        this.colour = value = 0xFF000000 | (rgb[0] & 0xFF) << 16 | (rgb[1] & 0xFF) << 8 | (rgb[2] & 0xFF) << 0;
    }

    @Override
    public int getColor(ItemStack stack, int tint) {
        return this.colour;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K && player.func_225608_bj_()) {
            ItemStack bagStack = player.func_184586_b(hand);
            ItemQuantumBag bag = (ItemQuantumBag)bagStack.func_77973_b();
            this.toggleActive(bagStack);
            player.func_146105_b((ITextComponent)new StringTextComponent("AutoPickup is " + this.format(bag.isActive(bagStack))), true);
            return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
        }
        if (!world.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this);
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    public void toggleActive(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74757_a("active", false);
        }
        if (stack.func_77942_o()) {
            boolean current = stack.func_77978_p().func_74767_n("active");
            stack.func_77978_p().func_74757_a("active", !current);
        }
    }

    public boolean isActive(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        return stack.func_77978_p().func_74767_n("active");
    }

    public static ItemStackHandler getHandlerForContainer(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        ItemStackHandler handler = new ItemStackHandler(104);
        if (stack.func_77942_o()) {
            handler.deserializeNBT(stack.func_77978_p().func_74775_l("inv"));
        }
        return handler;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o()) {
            tooltip.add((ITextComponent)new StringTextComponent("Auto-Pickup: " + this.format(stack.func_77978_p().func_74767_n("active"))));
        }
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerBag(id, inv);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_77658_a());
    }

    public String format(boolean b) {
        if (b) {
            return TextFormatting.GREEN + "Enabled";
        }
        return TextFormatting.RED + "Disabled";
    }
}

