/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.quantumstorage.items;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.annotation.Nullable;
import net.gigabit101.quantumstorage.items.ItemQuantumBattery;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class RfUtils {
    public static final DecimalFormat QUANTITY_FORMATTER = new DecimalFormat("####0.#", DecimalFormatSymbols.getInstance(Locale.US));

    public static int transferPower(@Nullable IEnergyStorage source, @Nullable IEnergyStorage destination, int maxAmount, boolean simulate) {
        if (source == null || destination == null) {
            return 0;
        }
        int amount = source.extractEnergy(destination.receiveEnergy(maxAmount, true), true);
        return destination.receiveEnergy(source.extractEnergy(amount, simulate), simulate);
    }

    public static boolean isPoweredItem(ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY, null).isPresent();
    }

    public static double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY).orElse((Object)((IEnergyStorage)new ItemQuantumBattery.EnergyCapabilityProvider(stack, (ItemQuantumBattery)stack.func_77973_b())));
        double max = storage.getMaxEnergyStored();
        double diff = max - (double)storage.getEnergyStored();
        return diff / max;
    }

    public static String formatQuantity(int qty) {
        if (qty >= 1000000) {
            return QUANTITY_FORMATTER.format((float)qty / 1000000.0f) + "M";
        }
        if (qty >= 1000) {
            return QUANTITY_FORMATTER.format((float)qty / 1000.0f) + "K";
        }
        return String.valueOf(qty);
    }

    public static String addPowerTooltip(IEnergyStorage iEnergyStorage) {
        return RfUtils.formatQuantity(iEnergyStorage.getEnergyStored()) + " / " + RfUtils.formatQuantity(iEnergyStorage.getMaxEnergyStored());
    }

    public static boolean isItemFull(ItemStack stack) {
        if (RfUtils.isPoweredItem(stack)) {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            return storage.getEnergyStored() == storage.getMaxEnergyStored();
        }
        return false;
    }

    public static void chargeItem(ItemStack stack, IEnergyStorage storage) {
        if (RfUtils.isPoweredItem(stack) && !RfUtils.isItemFull(stack)) {
            IEnergyStorage storageItem = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            int amount2send = storageItem.receiveEnergy(1000, true);
            if (storage.getEnergyStored() >= amount2send) {
                storageItem.receiveEnergy(amount2send, false);
                storage.extractEnergy(amount2send, false);
            }
        }
    }

    public static int dischargeItem(IEnergyStorage iEnergyStorage, ItemStack stack, int amount, boolean sim) {
        if (RfUtils.isPoweredItem(stack)) {
            return iEnergyStorage.extractEnergy(amount, sim);
        }
        return 0;
    }
}

