/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.quantumstorage.inventory;

import javax.annotation.Nonnull;
import net.gigabit101.quantumstorage.util.inventory.ItemUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.items.ItemStackHandler;

public class DsuInventoryHandler
extends ItemStackHandler {
    int STORAGE = 0;
    ItemStack lockedStack;
    public boolean requestUpdate = false;

    public DsuInventoryHandler(ItemStack lockedStack) {
        super(3);
        this.lockedStack = lockedStack;
    }

    protected int getStackLimit(int slot, ItemStack stack) {
        if (slot == this.STORAGE) {
            return Integer.MAX_VALUE;
        }
        return 64;
    }

    public CompoundNBT serializeNBT() {
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (this.stacks.get(i) == null) continue;
            CompoundNBT itemTag = new CompoundNBT();
            itemTag.func_74768_a("Slot", i);
            itemTag.func_74768_a("SizeSpecial", ((ItemStack)this.stacks.get(i)).func_190916_E());
            ((ItemStack)this.stacks.get(i)).func_77955_b(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Items", (INBT)nbtTagList);
        nbt.func_74768_a("Size", this.stacks.size());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setSize(nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stacks.size());
        ListNBT tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)ItemStack.func_199557_a((CompoundNBT)itemTags));
            ((ItemStack)this.stacks.get(slot)).func_190920_e(itemTags.func_74762_e("SizeSpecial"));
        }
        this.onLoad();
    }

    public void updateLockedStack(ItemStack itemStack) {
        this.lockedStack = itemStack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.lockedStack.func_190926_b() && ItemUtils.isItemEqual(this.lockedStack, stack, false)) {
            return super.insertItem(slot, stack, simulate);
        }
        if (this.lockedStack.func_190926_b() && this.getStackInSlot(2).func_190926_b() || this.lockedStack.func_190926_b() && !this.getStackInSlot(2).func_190926_b() && ItemUtils.isItemEqual(this.getStackInSlot(2), stack, false)) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }

    public void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.requestUpdate = true;
    }
}

