/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.quantumstorage;

import java.util.EnumMap;
import net.gigabit101.quantumstorage.config.ConfigQuantumStorage;
import net.gigabit101.quantumstorage.containers.ContainerBag;
import net.gigabit101.quantumstorage.containers.ContainerChestDiamond;
import net.gigabit101.quantumstorage.containers.ContainerChestGold;
import net.gigabit101.quantumstorage.containers.ContainerChestIron;
import net.gigabit101.quantumstorage.containers.ContainerQSU;
import net.gigabit101.quantumstorage.containers.ContainerTank;
import net.gigabit101.quantumstorage.containers.ContainerTrashcan;
import net.gigabit101.quantumstorage.init.QSBlocks;
import net.gigabit101.quantumstorage.init.QSItems;
import net.gigabit101.quantumstorage.init.recipe.RecipeBagColour;
import net.gigabit101.quantumstorage.items.backpack.ItemQuantumBag;
import net.gigabit101.quantumstorage.proxy.ClientProxy;
import net.gigabit101.quantumstorage.proxy.CommonProxy;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="quantumstorage")
public class QuantumStorage {
    public static final String MOD_ID = "quantumstorage";
    public static Logger LOGGER = LogManager.getLogger();
    public static QuantumStorage INSTANCE;
    @ObjectHolder(value="quantumstorage:chestdiamond")
    public static ContainerType<ContainerChestDiamond> containerChestDiamondContainerType;
    @ObjectHolder(value="quantumstorage:chestgold")
    public static ContainerType<ContainerChestGold> containerChestGoldContainerType;
    @ObjectHolder(value="quantumstorage:chestiron")
    public static ContainerType<ContainerChestIron> containerChestIronContainerType;
    @ObjectHolder(value="quantumstorage:trashcan")
    public static ContainerType<ContainerTrashcan> containerTrashcanContainerType;
    @ObjectHolder(value="quantumstorage:qsu")
    public static ContainerType<ContainerQSU> containerQsuContainerType;
    @ObjectHolder(value="quantumstorage:tank")
    public static ContainerType<ContainerTank> containerTankContainerType;
    @ObjectHolder(value="quantumstorage:bag")
    public static final ContainerType<ContainerBag> quantumBag;
    public static final EnumMap<DyeColor, ItemQuantumBag> BAGS;
    private static CommonProxy proxy;

    public QuantumStorage() {
        INSTANCE = this;
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        QSItems.ITEMS.register(eventBus);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, QuantumStorage::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(IRecipeSerializer.class, QuantumStorage::serializers);
        QSBlocks.BLOCKS.register(eventBus);
        QSBlocks.TILES_ENTITIES.register(eventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ConfigQuantumStorage.CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigQuantumStorage.COMMON_CONFIG);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(ContainerType.class, QuantumStorage::registerContainers);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ConfigQuantumStorage.loadConfig(ConfigQuantumStorage.CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("quantumstorage-client.toml"));
        ConfigQuantumStorage.loadConfig(ConfigQuantumStorage.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("quantumstorage-common.toml"));
    }

    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (DyeColor color : DyeColor.values()) {
            ItemQuantumBag s = new ItemQuantumBag(color);
            BAGS.put(color, s);
            event.getRegistry().register((IForgeRegistryEntry)s);
        }
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().register(IForgeContainerType.create(ContainerChestDiamond::new).setRegistryName(MOD_ID, "chestdiamond"));
        event.getRegistry().register(IForgeContainerType.create(ContainerChestGold::new).setRegistryName(MOD_ID, "chestgold"));
        event.getRegistry().register(IForgeContainerType.create(ContainerChestIron::new).setRegistryName(MOD_ID, "chestiron"));
        event.getRegistry().register(IForgeContainerType.create(ContainerTrashcan::new).setRegistryName(MOD_ID, "trashcan"));
        event.getRegistry().register(IForgeContainerType.create(ContainerQSU::new).setRegistryName(MOD_ID, "qsu"));
        event.getRegistry().register(IForgeContainerType.create(ContainerTank::new).setRegistryName(MOD_ID, "tank"));
        event.getRegistry().register(new ContainerType(ContainerBag::new).setRegistryName("bag"));
    }

    @SubscribeEvent
    public static void serializers(RegistryEvent.Register<IRecipeSerializer<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)RecipeBagColour.SERIALIZER.setRegistryName(new ResourceLocation(MOD_ID, "bag_colour")));
    }

    void doClientStuff(FMLClientSetupEvent event) {
        proxy.registerGuis();
        proxy.registerRenders();
        proxy.registerColors();
        proxy.registerKeybindings();
    }

    static {
        containerChestDiamondContainerType = null;
        containerChestGoldContainerType = null;
        containerChestIronContainerType = null;
        containerTrashcanContainerType = null;
        containerQsuContainerType = null;
        containerTankContainerType = null;
        quantumBag = null;
        BAGS = new EnumMap(DyeColor.class);
        proxy = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    }
}

