/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

@ParametersAreNonnullByDefault
public class RegionCache
implements IBlockReader {
    private final BlockPos center;
    private final int radius;
    private WeakReference<IBlockReader> passthrough;
    private final Long2ObjectMap<BlockState> stateCache = new Long2ObjectOpenHashMap();

    public RegionCache(BlockPos center, int radius, @Nullable IBlockReader passthrough) {
        this.center = center;
        this.radius = radius;
        this.passthrough = new WeakReference<IBlockReader>(passthrough);
    }

    private IBlockReader getPassthrough() {
        IBlockReader ret = (IBlockReader)this.passthrough.get();
        Preconditions.checkNotNull((Object)ret);
        return ret;
    }

    @Nonnull
    public RegionCache updateWorld(IBlockReader passthrough) {
        if (this.passthrough.get() != passthrough) {
            this.stateCache.clear();
        }
        this.passthrough = new WeakReference<IBlockReader>(passthrough);
        return this;
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return this.getPassthrough().func_175625_s(pos);
    }

    public BlockState func_180495_p(BlockPos pos) {
        long address = pos.func_218275_a();
        BlockState ret = (BlockState)this.stateCache.get(address);
        if (ret == null) {
            ret = this.getPassthrough().func_180495_p(pos);
            this.stateCache.put(address, (Object)ret);
        }
        return ret;
    }

    public FluidState func_204610_c(BlockPos pos) {
        return this.getPassthrough().func_204610_c(pos);
    }
}

