/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.api.util;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenCustomHashMap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.client.util.IdentityStrategy;
import team.chisel.ctm.client.util.ProfileUtil;
import team.chisel.ctm.client.util.RegionCache;

@ParametersAreNonnullByDefault
public class RenderContextList {
    private static final ThreadLocal<RegionCache> regionMetaCache = ThreadLocal.withInitial(() -> new RegionCache(BlockPos.field_177992_a, 0, null));
    private final Map<ICTMTexture<?>, ITextureContext> contextMap = Maps.newIdentityHashMap();
    private final Object2LongMap<ICTMTexture<?>> serialized = new Object2LongOpenCustomHashMap(new IdentityStrategy());

    public RenderContextList(BlockState state, Collection<ICTMTexture<?>> textures, IBlockReader world, BlockPos pos) {
        ProfileUtil.start("ctm_region_cache_update");
        RegionCache cachedWorld = regionMetaCache.get().updateWorld(world);
        ProfileUtil.endAndStart("ctm_context_gather");
        for (ICTMTexture<?> iCTMTexture : textures) {
            Object type = iCTMTexture.getType();
            ITextureContext ctx = type.getBlockRenderContext(state, cachedWorld, pos, iCTMTexture);
            if (ctx == null) continue;
            this.contextMap.put(iCTMTexture, ctx);
        }
        ProfileUtil.endAndStart("ctm_context_serialize");
        for (Map.Entry entry : this.contextMap.entrySet()) {
            this.serialized.put(entry.getKey(), ((ITextureContext)entry.getValue()).getCompressedData());
        }
        ProfileUtil.end();
    }

    @Nullable
    public ITextureContext getRenderContext(ICTMTexture<?> tex) {
        return this.contextMap.get(tex);
    }

    public boolean contains(ICTMTexture<?> tex) {
        return this.getRenderContext(tex) != null;
    }

    public Object2LongMap<ICTMTexture<?>> serialized() {
        return this.serialized;
    }
}

