/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.ui;

import architectury_inject_KubeJSUI1164_common_71e66f4146a1476b9a48d22144c8a82b.PlatformMethods;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.ui.RegisterActionsEvent;
import dev.latvian.kubejs.ui.RegisterScreensEvent;
import dev.latvian.kubejs.ui.VanillaActions;
import dev.latvian.kubejs.util.UtilsJS;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import me.shedaniel.architectury.annotations.ExpectPlatform;
import me.shedaniel.architectury.event.Event;
import me.shedaniel.architectury.event.EventFactory;
import me.shedaniel.architectury.platform.Platform;
import net.minecraft.client.gui.AccessibilityScreen;
import net.minecraft.client.gui.screen.LanguageScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.OptionsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WinGameScreen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.realms.RealmsBridgeScreen;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public enum UIData implements IResourceManagerReloadListener
{
    INSTANCE;

    Event<RegisterScreensEvent> REGISTER_SCREENS = EventFactory.createLoop((Object[])new RegisterScreensEvent[0]);
    Event<RegisterActionsEvent> REGISTER_ACTIONS = EventFactory.createLoop((Object[])new RegisterActionsEvent[0]);
    private final Map<Class<?>, String> screenIds = new HashMap();
    private final Map<ResourceLocation, Consumer<Screen>> actions = new HashMap<ResourceLocation, Consumer<Screen>>();

    public void func_195410_a(IResourceManager resourceManager) {
        this.screenIds.clear();
        this.actions.clear();
        this.screenIds.put(MainMenuScreen.class, "main_menu");
        this.screenIds.put(RealmsBridgeScreen.class, "realms");
        this.screenIds.put(LanguageScreen.class, "language");
        this.screenIds.put(OptionsScreen.class, "options");
        this.screenIds.put(AccessibilityScreen.class, "accessibility");
        this.screenIds.put(WorldSelectionScreen.class, "select_world");
        this.screenIds.put(WinGameScreen.class, "credits");
        this.actions.put(new ResourceLocation("minecraft:singleplayer"), VanillaActions.SINGLEPLAYER);
        this.actions.put(new ResourceLocation("minecraft:multiplayer"), VanillaActions.MULTIPLAYER);
        this.actions.put(new ResourceLocation("minecraft:realms"), VanillaActions.REALMS);
        this.actions.put(new ResourceLocation("minecraft:language"), VanillaActions.LANGUAGE);
        this.actions.put(new ResourceLocation("minecraft:options"), VanillaActions.OPTIONS);
        this.actions.put(new ResourceLocation("minecraft:quit"), VanillaActions.QUIT);
        this.actions.put(new ResourceLocation("minecraft:accessibility"), VanillaActions.ACCESSIBILITY);
        this.actions.put(new ResourceLocation("kubejsui:toggle_shaders"), VanillaActions.KUBEJSUI_TOGGLE_SHADERS);
        ((RegisterScreensEvent)this.REGISTER_SCREENS.invoker()).registerScreens(this.screenIds::put);
        ((RegisterActionsEvent)this.REGISTER_ACTIONS.invoker()).registerActions(this.actions::put);
        UIData.registerPlatformScreensAndActions(this.screenIds, this.actions);
        Gson gson = new GsonBuilder().create();
        for (String namespace : resourceManager.func_199001_a()) {
            try {
                for (IResource resource : resourceManager.func_199004_b(new ResourceLocation(namespace, "kubejsui.json"))) {
                    InputStream stream = resource.func_199027_b();
                    try {
                        JsonObject json = (JsonObject)gson.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), JsonObject.class);
                        if (json.has("actions")) {
                            for (Map.Entry entry : json.get("actions").getAsJsonObject().entrySet()) {
                                String s = ((JsonElement)entry.getValue()).getAsString();
                                try {
                                    int i = s.lastIndexOf(46);
                                    Class<?> clazz = Class.forName(s.substring(0, i));
                                    Field field = clazz.getDeclaredField(s.substring(i + 1));
                                    field.setAccessible(true);
                                    Consumer consumer = Objects.requireNonNull((Consumer)field.get(null));
                                    this.actions.put(new ResourceLocation(namespace, (String)entry.getKey()), consumer);
                                }
                                catch (Throwable ex) {
                                    KubeJS.LOGGER.error("UI: Failed to load action " + (String)entry.getKey() + ":" + entry.getValue() + ": " + ex);
                                }
                            }
                        }
                        if (!json.has("screens")) continue;
                        for (Map.Entry entry : json.get("screens").getAsJsonObject().entrySet()) {
                            if (Platform.isFabric()) {
                                UIData.addMappedScreen(this.screenIds, entry);
                            }
                            try {
                                this.screenIds.put(Class.forName((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsString());
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
            }
            catch (Exception exception) {
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void addMappedScreen(Map<Class<?>, String> screenIds, Map.Entry<String, JsonElement> entry) {
        void var1_1;
        PlatformMethods.platform("addMappedScreen", screenIds, (Map.Entry)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerPlatformScreensAndActions(Map<Class<?>, String> screenIds, Map<ResourceLocation, Consumer<Screen>> actions) {
        void var1_1;
        PlatformMethods.platform("registerPlatformScreensAndActions", screenIds, (Map)var1_1);
    }

    @Nullable
    public Consumer<Screen> getAction(String id) {
        return this.actions.get(UtilsJS.getMCID((Object)id));
    }

    public String getScreenId(Class<?> c) {
        return this.screenIds.getOrDefault(c, "");
    }

    @Deprecated
    public static UIData get() {
        return INSTANCE;
    }
}

