/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.text;

import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.command.text.TableBuilder;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;

public interface TableFormatter {
    public static final ITextComponent SEPARATOR = ChatHelpers.coloured("| ", TextFormatting.GRAY);
    public static final ITextComponent HEADER = ChatHelpers.coloured("=", TextFormatting.GRAY);

    @Nullable
    public ITextComponent getPadding(ITextComponent var1, int var2);

    public int getColumnPadding();

    public int getWidth(ITextComponent var1);

    public void writeLine(int var1, ITextComponent var2);

    default public int display(TableBuilder table) {
        int width;
        int i;
        if (table.getColumns() <= 0) {
            return 0;
        }
        int rowId = table.getId();
        int columns = table.getColumns();
        int[] maxWidths = new int[columns];
        ITextComponent[] headers = table.getHeaders();
        if (headers != null) {
            for (int i2 = 0; i2 < columns; ++i2) {
                maxWidths[i2] = this.getWidth(headers[i2]);
            }
        }
        for (ITextComponent[] row : table.getRows()) {
            for (i = 0; i < row.length; ++i) {
                width = this.getWidth(row[i]);
                if (width <= maxWidths[i]) continue;
                maxWidths[i] = width;
            }
        }
        int padding = this.getColumnPadding();
        int i22 = 0;
        while (i22 < maxWidths.length - 1) {
            int n = i22++;
            maxWidths[n] = maxWidths[n] + padding;
        }
        int totalWidth = (columns - 1) * this.getWidth(SEPARATOR);
        int[] i22 = maxWidths;
        i = i22.length;
        for (width = 0; width < i; ++width) {
            int x = i22[width];
            totalWidth += x;
        }
        if (headers != null) {
            StringTextComponent line = new StringTextComponent("");
            for (i = 0; i < columns - 1; ++i) {
                line.func_230529_a_(headers[i]);
                ITextComponent padding2 = this.getPadding(headers[i], maxWidths[i]);
                if (padding2 != null) {
                    line.func_230529_a_(padding2);
                }
                line.func_230529_a_(SEPARATOR);
            }
            line.func_230529_a_(headers[columns - 1]);
            this.writeLine(rowId++, (ITextComponent)line);
            int rowCharWidth = this.getWidth(HEADER);
            int rowWidth = totalWidth / rowCharWidth + (totalWidth % rowCharWidth == 0 ? 0 : 1);
            this.writeLine(rowId++, (ITextComponent)ChatHelpers.coloured(StringUtils.repeat((String)HEADER.getString(), (int)rowWidth), TextFormatting.GRAY));
        }
        for (ITextComponent[] row : table.getRows()) {
            StringTextComponent line = new StringTextComponent("");
            for (int i3 = 0; i3 < columns - 1; ++i3) {
                line.func_230529_a_(row[i3]);
                ITextComponent padding3 = this.getPadding(row[i3], maxWidths[i3]);
                if (padding3 != null) {
                    line.func_230529_a_(padding3);
                }
                line.func_230529_a_(SEPARATOR);
            }
            line.func_230529_a_(row[columns - 1]);
            this.writeLine(rowId++, (ITextComponent)line);
        }
        if (table.getAdditional() > 0) {
            this.writeLine(rowId++, (ITextComponent)ChatHelpers.coloured(ChatHelpers.translate("commands.computercraft.generic.additional_rows", table.getAdditional()), TextFormatting.AQUA));
        }
        return rowId - table.getId();
    }
}

