/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.misc.EquatableItemStack;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.network.NetworkItem;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.NetworkLock;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.packets.PacketNetworkItems;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Stack;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class ItemTerminalTileEntity
extends TileEntity
implements INamedContainerProvider,
ITickableTileEntity,
IPipeConnectable {
    public final ItemStackHandler items = new ItemStackHandler(12){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    };
    protected Map<EquatableItemStack, NetworkItem> networkItems;
    private final Queue<NetworkLock> existingRequests = new LinkedList<NetworkLock>();
    private final LazyOptional<IPipeConnectable> lazyThis = LazyOptional.of(() -> this);

    protected ItemTerminalTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public ItemTerminalTileEntity() {
        this(Registry.itemTerminalTileEntity);
    }

    public void func_73660_a() {
        PlayerEntity[] lookingPlayers;
        int interval;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        PipeNetwork network = PipeNetwork.get(this.field_145850_b);
        PipeTileEntity pipe = this.getConnectedPipe();
        if (pipe == null) {
            return;
        }
        boolean update = false;
        int n = interval = pipe.pressurizer != null ? 2 : 10;
        if (this.field_145850_b.func_82737_E() % (long)interval == 0L) {
            for (int i = 6; i < 12; ++i) {
                ItemStack remain;
                ItemStack extracted = this.items.extractItem(i, Integer.MAX_VALUE, true);
                if (extracted.func_190926_b() || (remain = network.routeItem(pipe.func_174877_v(), this.field_174879_c, extracted, true)).func_190916_E() == extracted.func_190916_E()) continue;
                this.items.extractItem(i, extracted.func_190916_E() - remain.func_190916_E(), false);
                break;
            }
            if (!this.existingRequests.isEmpty()) {
                NetworkLock request = this.existingRequests.remove();
                network.resolveNetworkLock(request);
                network.requestExistingItem(request.location, pipe.func_174877_v(), this.field_174879_c, request, request.stack, ItemEquality.NBT);
                update = true;
            }
        }
        if ((this.field_145850_b.func_82737_E() % 100L == 0L || update) && (lookingPlayers = this.getLookingPlayers()).length > 0) {
            this.updateItems(lookingPlayers);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        PipeNetwork network = PipeNetwork.get(this.field_145850_b);
        for (NetworkLock lock : this.existingRequests) {
            network.resolveNetworkLock(lock);
        }
        this.lazyThis.invalidate();
    }

    public String getInvalidTerminalReason() {
        PipeNetwork network = PipeNetwork.get(this.field_145850_b);
        long pipes = Arrays.stream(Direction.values()).map(d -> network.getPipe(this.field_174879_c.func_177972_a(d))).filter(Objects::nonNull).count();
        if (pipes <= 0L) {
            return "info.prettypipes.no_pipe_connected";
        }
        if (pipes > 1L) {
            return "info.prettypipes.too_many_pipes_connected";
        }
        return null;
    }

    public PipeTileEntity getConnectedPipe() {
        PipeNetwork network = PipeNetwork.get(this.field_145850_b);
        for (Direction dir : Direction.values()) {
            PipeTileEntity pipe = network.getPipe(this.field_174879_c.func_177972_a(dir));
            if (pipe == null) continue;
            return pipe;
        }
        return null;
    }

    public void updateItems(PlayerEntity ... playersToSync) {
        PipeTileEntity pipe = this.getConnectedPipe();
        if (pipe == null) {
            return;
        }
        this.networkItems = this.collectItems(ItemEquality.NBT);
        if (playersToSync.length > 0) {
            List<ItemStack> clientItems = this.networkItems.values().stream().map(NetworkItem::asStack).collect(Collectors.toList());
            List<ItemStack> clientCraftables = PipeNetwork.get(this.field_145850_b).getAllCraftables(pipe.func_174877_v()).stream().map(Pair::getRight).collect(Collectors.toList());
            List<ItemStack> currentlyCrafting = this.getCurrentlyCrafting().stream().sorted(Comparator.comparingInt(ItemStack::func_190916_E).reversed()).collect(Collectors.toList());
            for (PlayerEntity player : playersToSync) {
                ItemTerminalTileEntity tile;
                if (!(player.field_71070_bA instanceof ItemTerminalContainer) || (tile = ((ItemTerminalContainer)player.field_71070_bA).tile) != this) continue;
                PacketHandler.sendTo(player, new PacketNetworkItems(clientItems, clientCraftables, currentlyCrafting));
            }
        }
    }

    public void requestItem(PlayerEntity player, ItemStack stack) {
        PipeNetwork network = PipeNetwork.get(this.field_145850_b);
        network.startProfile("terminal_request_item");
        this.updateItems(new PlayerEntity[0]);
        int requested = this.requestItemImpl(stack, ItemTerminalTileEntity.onItemUnavailable(player));
        if (requested > 0) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("info.prettypipes.sending", new Object[]{requested, stack.func_200301_q()}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), UUID.randomUUID());
        } else {
            ItemTerminalTileEntity.onItemUnavailable(player).accept(stack);
        }
        network.endProfile();
    }

    public int requestItemImpl(ItemStack stack, Consumer<ItemStack> unavailableConsumer) {
        NetworkItem item = this.networkItems.get(new EquatableItemStack(stack, ItemEquality.NBT));
        List<NetworkLocation> locations = item == null ? Collections.emptyList() : item.getLocations();
        Pair<List<NetworkLock>, ItemStack> ret = ItemTerminalTileEntity.requestItemLater(this.field_145850_b, this.getConnectedPipe().func_174877_v(), locations, unavailableConsumer, stack, new Stack<ItemStack>(), ItemEquality.NBT);
        this.existingRequests.addAll((Collection)ret.getLeft());
        return stack.func_190916_E() - ((ItemStack)ret.getRight()).func_190916_E();
    }

    protected PlayerEntity[] getLookingPlayers() {
        return (PlayerEntity[])this.field_145850_b.func_217369_A().stream().filter(p -> p.field_71070_bA instanceof ItemTerminalContainer).filter(p -> ((ItemTerminalContainer)p.field_71070_bA).tile == this).toArray(PlayerEntity[]::new);
    }

    private Map<EquatableItemStack, NetworkItem> collectItems(ItemEquality ... equalityTypes) {
        PipeNetwork network = PipeNetwork.get(this.field_145850_b);
        network.startProfile("terminal_collect_items");
        PipeTileEntity pipe = this.getConnectedPipe();
        HashMap<EquatableItemStack, NetworkItem> items = new HashMap<EquatableItemStack, NetworkItem>();
        for (NetworkLocation location : network.getOrderedNetworkItems(pipe.func_174877_v())) {
            for (Map.Entry<Integer, ItemStack> entry : location.getItems(this.field_145850_b).entrySet()) {
                if (!location.canExtract(this.field_145850_b, entry.getKey())) continue;
                EquatableItemStack equatable = new EquatableItemStack(entry.getValue(), equalityTypes);
                NetworkItem item = items.computeIfAbsent(equatable, NetworkItem::new);
                item.add(location, entry.getValue());
            }
        }
        network.endProfile();
        return items;
    }

    private List<ItemStack> getCurrentlyCrafting() {
        PipeNetwork network = PipeNetwork.get(this.field_145850_b);
        PipeTileEntity pipe = this.getConnectedPipe();
        if (pipe == null) {
            return Collections.emptyList();
        }
        List<Pair<BlockPos, ItemStack>> crafting = network.getCurrentlyCrafting(pipe.func_174877_v(), new ItemEquality[0]);
        return crafting.stream().map(Pair::getRight).collect(Collectors.toList());
    }

    public void cancelCrafting() {
        PipeNetwork network = PipeNetwork.get(this.field_145850_b);
        PipeTileEntity pipe = this.getConnectedPipe();
        if (pipe == null) {
            return;
        }
        for (Pair<BlockPos, ItemStack> craftable : network.getAllCraftables(pipe.func_174877_v())) {
            PipeTileEntity otherPipe = network.getPipe((BlockPos)craftable.getLeft());
            if (otherPipe == null) continue;
            for (NetworkLock lock : otherPipe.craftIngredientRequests) {
                network.resolveNetworkLock(lock);
            }
            otherPipe.craftIngredientRequests.clear();
            otherPipe.craftResultRequests.clear();
        }
        PlayerEntity[] lookingPlayers = this.getLookingPlayers();
        if (lookingPlayers.length > 0) {
            this.updateItems(lookingPlayers);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("items", (INBT)this.items.serializeNBT());
        compound.func_218657_a("requests", (INBT)Utility.serializeAll(this.existingRequests));
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.items.deserializeNBT(compound.func_74775_l("items"));
        this.existingRequests.clear();
        this.existingRequests.addAll(Utility.deserializeAll(compound.func_150295_c("requests", 10), NetworkLock::new));
        super.func_230337_a_(state, compound);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.prettypipes.item_terminal");
    }

    @Nullable
    public Container createMenu(int window, PlayerInventory inv, PlayerEntity player) {
        return new ItemTerminalContainer(Registry.itemTerminalContainer, window, player, this.field_174879_c);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Registry.pipeConnectableCapability) {
            return this.lazyThis.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public ConnectionType getConnectionType(BlockPos pipePos, Direction direction) {
        return ConnectionType.CONNECTED;
    }

    @Override
    public ItemStack insertItem(BlockPos pipePos, Direction direction, ItemStack stack, boolean simulate) {
        BlockPos pos = pipePos.func_177972_a(direction);
        ItemTerminalTileEntity tile = Utility.getTileEntity(ItemTerminalTileEntity.class, (IBlockReader)this.field_145850_b, pos);
        if (tile != null) {
            return ItemHandlerHelper.insertItemStacked((IItemHandler)tile.items, (ItemStack)stack, (boolean)simulate);
        }
        return stack;
    }

    @Override
    public boolean allowsModules(BlockPos pipePos, Direction direction) {
        return true;
    }

    public static Pair<List<NetworkLock>, ItemStack> requestItemLater(World world, BlockPos destPipe, Collection<NetworkLocation> locations, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain, ItemEquality ... equalityTypes) {
        ArrayList<NetworkLock> requests = new ArrayList<NetworkLock>();
        ItemStack remain = stack.func_77946_l();
        PipeNetwork network = PipeNetwork.get(world);
        for (NetworkLocation location : locations) {
            int amount = location.getItemAmount(world, stack, equalityTypes);
            if (amount <= 0 || (amount -= network.getLockedAmount(location.getPos(), stack, null, equalityTypes)) <= 0) continue;
            if (remain.func_190916_E() < amount) {
                amount = remain.func_190916_E();
            }
            remain.func_190918_g(amount);
            while (amount > 0) {
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(Math.min(stack.func_77976_d(), amount));
                NetworkLock lock = new NetworkLock(location, copy);
                network.createNetworkLock(lock);
                requests.add(lock);
                amount -= copy.func_190916_E();
            }
            if (!remain.func_190926_b()) continue;
            break;
        }
        if (!remain.func_190926_b()) {
            remain = network.requestCraftedItem(destPipe, unavailableConsumer, remain, dependencyChain, equalityTypes);
        }
        return Pair.of(requests, (Object)remain);
    }

    public static Consumer<ItemStack> onItemUnavailable(PlayerEntity player) {
        return s -> player.func_145747_a((ITextComponent)new TranslationTextComponent("info.prettypipes.not_found", new Object[]{s.func_200301_q()}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), UUID.randomUUID());
    }
}

