/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.podium.event;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.WritableBookItem;
import net.minecraft.item.WrittenBookItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.LecternTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.brassgoggledcoders.podium.Podium;
import xyz.brassgoggledcoders.podium.api.PodiumCaps;
import xyz.brassgoggledcoders.podium.api.bookholder.LecternBookHolder;
import xyz.brassgoggledcoders.podium.api.event.CopyBookEvent;
import xyz.brassgoggledcoders.podium.api.event.GetPageContentsEvent;
import xyz.brassgoggledcoders.podium.api.event.GetPodiumBehaviorEvent;
import xyz.brassgoggledcoders.podium.capability.BasicCapabilityProvider;
import xyz.brassgoggledcoders.podium.podiumbehavior.BookPodiumBehavior;

@Mod.EventBusSubscriber(modid="podium", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventHandler {
    public static final ResourceLocation BOOK_HOLDER = Podium.rl("book_holder");

    @SubscribeEvent
    public static void onAttachTileEntityCapabilities(AttachCapabilitiesEvent<TileEntity> attachCapabilitiesEvent) {
        if (attachCapabilitiesEvent.getObject() instanceof LecternTileEntity) {
            BasicCapabilityProvider<LecternBookHolder> lecternBookHolder = new BasicCapabilityProvider<LecternBookHolder>(PodiumCaps.BOOK_HOLDER, new LecternBookHolder((LecternTileEntity)attachCapabilitiesEvent.getObject()));
            attachCapabilitiesEvent.addCapability(BOOK_HOLDER, lecternBookHolder);
            attachCapabilitiesEvent.addListener(lecternBookHolder::invalidate);
        }
    }

    @SubscribeEvent
    public static void handleGetPodiumBehavior(GetPodiumBehaviorEvent event) {
        Item item = event.getItemStack().func_77973_b();
        if (item == Items.field_151099_bA || item == Items.field_151164_bB) {
            event.setPodiumBehavior(new BookPodiumBehavior(event.getPodium(), WrittenBookItem::func_220049_j));
        }
    }

    @SubscribeEvent
    public static void handleGetPageContents(GetPageContentsEvent event) {
        ItemStack bookStack = event.getBookHolder().getItemStack();
        Item item = bookStack.func_77973_b();
        int page = -1;
        String pageString = event.getBookHolder().getOpenPage();
        if (pageString != null) {
            try {
                page = Integer.parseInt(pageString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (item == Items.field_151164_bB && page >= 0) {
            CompoundNBT bookNBT;
            ListNBT pagesNBT;
            String currentPage;
            IFormattableTextComponent textComponent;
            if (WrittenBookItem.func_77828_a((CompoundNBT)bookStack.func_77978_p()) && (textComponent = ITextComponent.Serializer.func_240643_a_((String)(currentPage = (pagesNBT = (bookNBT = bookStack.func_77978_p()).func_150295_c("pages", 8)).func_150307_f(page)))) != null) {
                event.setPageContent(textComponent.getString());
            }
        } else if (item == Items.field_151099_bA && page >= 0 && WritableBookItem.func_150930_a((CompoundNBT)bookStack.func_77978_p())) {
            CompoundNBT bookNBT = bookStack.func_77978_p();
            ListNBT pagesNBT = bookNBT.func_150295_c("pages", 8);
            event.setPageContent(pagesNBT.func_150307_f(page));
        }
    }

    @SubscribeEvent
    public static void copyBook(CopyBookEvent event) {
        ItemStack bookStack = event.getBookHolder().getItemStack();
        Item bookItem = bookStack.func_77973_b();
        Hand otherHand = event.getWritingHand() == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND;
        ItemStack otherHandStack = event.getCopier().func_184586_b(otherHand);
        if (bookItem == Items.field_151099_bA) {
            if (otherHandStack.func_77973_b() == Items.field_151099_bA && bookStack.func_77978_p() != null) {
                otherHandStack.func_77982_d(bookStack.func_77978_p().func_74737_b());
                event.useInk();
            }
        } else if (bookItem == Items.field_151164_bB && otherHandStack.func_77973_b() == Items.field_151099_bA && bookStack.func_77978_p() != null) {
            CompoundNBT nbt = bookStack.func_77978_p().func_74737_b();
            ItemStack newBookStack = new ItemStack((IItemProvider)Items.field_151164_bB);
            nbt.func_74768_a("generation", WrittenBookItem.func_179230_h((ItemStack)bookStack) + 1);
            newBookStack.func_77982_d(nbt);
            event.getCopier().func_184611_a(otherHand, newBookStack);
            event.useInk();
        }
    }
}

