/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe;

import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.IFluidizerRecipe;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.datagen.provider.recipe.OneToOneRecipeBuilder;
import it.zerono.mods.zerocore.lib.recipe.AbstractOneToOneRecipe;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.AbstractHeldRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.IRecipeHolder;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredientSource;
import it.zerono.mods.zerocore.lib.recipe.ingredient.ItemStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.FluidStackRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResultTarget;
import it.zerono.mods.zerocore.lib.recipe.serializer.OneToOneRecipeSerializer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FluidizerSolidRecipe
extends AbstractOneToOneRecipe<ItemStack, FluidStack, ItemStackRecipeIngredient, FluidStackRecipeResult>
implements IFluidizerRecipe {
    private static long s_maxResultAmount = 0L;

    protected FluidizerSolidRecipe(ResourceLocation id, ItemStackRecipeIngredient ingredient, FluidStackRecipeResult result) {
        super(id, (IRecipeIngredient)ingredient, (IRecipeResult)result);
        s_maxResultAmount = Math.max(s_maxResultAmount, result.getAmount());
    }

    public static boolean lookup(ModRecipe recipe, IRecipeIngredientSource<ItemStack> source) {
        return recipe instanceof FluidizerSolidRecipe && ((FluidizerSolidRecipe)recipe).test(source.getIngredient());
    }

    public static long getMaxResultAmount() {
        return s_maxResultAmount;
    }

    @Override
    public IFluidizerRecipe.Type getRecipeType() {
        return IFluidizerRecipe.Type.Solid;
    }

    public boolean match(ItemStack stack) {
        return ((ItemStackRecipeIngredient)this.getIngredient()).test((Object)stack);
    }

    public static IRecipeSerializer<FluidizerSolidRecipe> serializer() {
        return new OneToOneRecipeSerializer(FluidizerSolidRecipe::new, ItemStackRecipeIngredient::from, ItemStackRecipeIngredient::from, FluidStackRecipeResult::from, FluidStackRecipeResult::from);
    }

    public static OneToOneRecipeBuilder<ItemStack, FluidStack> builder(IRecipeIngredient<ItemStack> ingredient, IRecipeResult<FluidStack> result) {
        return new OneToOneRecipeBuilder(IFluidizerRecipe.Type.Solid.getRecipeId(), ingredient, result);
    }

    @Override
    public int getEnergyUsageMultiplier() {
        return this.getEnergyUsageMultiplier(((FluidStackRecipeResult)this.getResult()).getResult());
    }

    public IRecipeSerializer<FluidizerSolidRecipe> func_199559_b() {
        return (IRecipeSerializer)Content.Recipes.FLUIDIZER_SOLID_RECIPE_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return Content.Recipes.FLUIDIZER_RECIPE_TYPE;
    }

    public static class HeldRecipe
    extends AbstractHeldRecipe<FluidizerSolidRecipe>
    implements IFluidizerRecipe.Held<FluidizerSolidRecipe> {
        private final IRecipeIngredientSource<ItemStack> _itemSource;
        private final IRecipeResultTarget<FluidStackRecipeResult> _outputTarget;

        public <Holder extends IRecipeHolder<FluidizerSolidRecipe>> HeldRecipe(FluidizerSolidRecipe recipe, Holder holder, IRecipeIngredientSource<ItemStack> itemSource, IRecipeResultTarget<FluidStackRecipeResult> outputTarget) {
            super((ModRecipe)recipe, holder);
            this._itemSource = itemSource;
            this._outputTarget = outputTarget;
        }

        public void onRecipeProcessed() {
            FluidizerSolidRecipe recipe = (FluidizerSolidRecipe)this.getRecipe();
            ItemStack item = (ItemStack)this._itemSource.getMatchFrom(recipe.getIngredient());
            if (!item.func_190926_b()) {
                this._itemSource.consumeIngredient((Object)item);
                this._outputTarget.setResult(recipe.getResult(), OperationMode.Execute);
            }
        }
    }
}

