/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.AbstractFluidizerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactantHelper;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.DebuggableHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.data.nbt.IConditionallySyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolder;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.fluid.FluidStackHolder;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredientSource;
import it.zerono.mods.zerocore.lib.recipe.ingredient.RecipeIngredientSourceWrapper;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.LogicalSide;

public class FluidizerFluidInjectorEntity
extends AbstractFluidizerEntity
implements INamedContainerProvider,
INeighborChangeListener,
IConditionallySyncableEntity {
    public static int MAX_CAPACITY = 8000;
    @CapabilityInject(value=IFluidHandler.class)
    private static Capability<IFluidHandler> FLUID_HANDLER_CAPABILITY = null;
    private static final ResourceLocation SYNC_DATA_ID = ExtremeReactors.newID("fluidinjector");
    private final FluidStackHolder _fluids = (FluidStackHolder)((FluidStackHolder)new FluidStackHolder(1, FluidizerFluidInjectorEntity::isFluidValid).setOnLoadListener(this::onFluidsChanged)).setOnContentsChangedListener(this::onFluidsChanged);
    private final LazyOptional<IFluidHandler> _capability;
    private boolean _shouldSync;

    public FluidizerFluidInjectorEntity() {
        super((TileEntityType)Content.TileEntityTypes.FLUIDIZER_FLUIDINJECTOR.get());
        this._fluids.setMaxCapacity(MAX_CAPACITY);
        this._capability = LazyOptional.of(() -> this._fluids);
    }

    public IRecipeIngredientSource<FluidStack> asRecipeSource() {
        return RecipeIngredientSourceWrapper.wrap((IFluidHandler)this._fluids, (int)0);
    }

    public IFluidHandler getFluidHandler() {
        return this._fluids;
    }

    public FluidStack getStack() {
        return this._fluids.getStackAt(0);
    }

    public static void itemTooltipBuilder(ItemStack stack, CompoundNBT data, @Nullable IBlockReader world, NonNullConsumer<ITextComponent> appender, boolean isAdvancedTooltip) {
        if (data.func_74764_b("inv")) {
            FluidStackHolder holder = new FluidStackHolder(1);
            holder.syncDataFrom(data.func_74775_l("inv"), ISyncableEntity.SyncReason.FullSync);
            TranslationTextComponent text = holder.isEmpty(0) ? new TranslationTextComponent("gui.bigreactors.generic.empty") : new TranslationTextComponent("gui.bigreactors.reactor.fluidaccessport.item.reactant", new Object[]{FluidHelper.getFluidName((FluidStack)holder.getFluidInTank(0)), holder.getAmount(0)});
            appender.accept((Object)new TranslationTextComponent("gui.bigreactors.generic.fuel.label").func_230529_a_((ITextComponent)text.func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE)));
        }
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        return this.isMachineAssembled() && this.getNeighborCapability().isPresent() ? 1 : 0;
    }

    public void onNeighborBlockChanged(BlockState state, BlockPos neighborPosition, boolean isMoving) {
        this.requestClientRenderUpdate();
    }

    public void onNeighborTileChanged(BlockState state, BlockPos neighborPosition) {
        this.requestClientRenderUpdate();
    }

    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        this.syncChildDataEntityFrom((ISyncableEntity)this._fluids, "inv", data, syncReason);
        if (syncReason.isFullSync()) {
            this._shouldSync = true;
        }
    }

    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        this.syncChildDataEntityTo((ISyncableEntity)this._fluids, "inv", data, syncReason);
        return data;
    }

    public ResourceLocation getSyncableEntityId() {
        return SYNC_DATA_ID;
    }

    public boolean shouldSyncEntity() {
        boolean result = this._shouldSync;
        this._shouldSync = false;
        return result;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        messages.add((Object)this._fluids, DebuggableHelper::getDebugMessagesFor, "Fluids");
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return null;
    }

    public ITextComponent func_145748_c_() {
        return super.getPartDisplayName();
    }

    public boolean canOpenGui(World world, BlockPos position, BlockState state) {
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return FLUID_HANDLER_CAPABILITY == cap ? this._capability.cast() : super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this._capability.invalidate();
    }

    private static boolean isFluidValid(int ignore, FluidStack stack) {
        return ReactantHelper.isValidSource(ReactantType.Fuel, stack) || ReactantHelper.isValidSource(ReactantType.Waste, stack);
    }

    private LazyOptional<IFluidHandler> getNeighborCapability() {
        return CodeHelper.optionalFlatMap((Optional)this.getPartWorld(), (Optional)this.getOutwardDirection(), (world, direction) -> WorldHelper.getTile((World)world, (BlockPos)this.getWorldPosition().func_177972_a(direction)).map(te -> te.getCapability(FLUID_HANDLER_CAPABILITY, direction.func_176734_d()))).orElse(LazyOptional.empty());
    }

    private void onFluidsChanged(IStackHolder.ChangeType changeType, int slot) {
        this.onFluidsChanged();
    }

    private void onFluidsChanged() {
        this.func_70296_d();
        this.onIngredientsChanged();
        this._shouldSync = true;
    }
}

