/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part;

import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.FluidizerPartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.MultiblockFluidizer;
import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType2;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartTypeProvider;
import it.zerono.mods.zerocore.lib.client.model.data.multiblock.CuboidPartVariantsModelData;
import it.zerono.mods.zerocore.lib.client.model.data.multiblock.CuboidPartVariantsModelDataCache;
import it.zerono.mods.zerocore.lib.energy.IWideEnergyStorage2;
import it.zerono.mods.zerocore.lib.energy.NullEnergyHandlers;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import java.util.Objects;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class AbstractFluidizerEntity
extends AbstractMultiblockEntity<MultiblockFluidizer>
implements IMultiblockPartTypeProvider<MultiblockFluidizer, FluidizerPartType> {
    private static final CuboidPartVariantsModelDataCache s_modelDataCaches = new CuboidPartVariantsModelDataCache();

    public AbstractFluidizerEntity(TileEntityType<?> type) {
        super(type);
    }

    protected boolean isFluidizerActive() {
        return this.getMultiblockController().filter(AbstractMultiblockController::isAssembled).map(MultiblockFluidizer::isMachineActive).orElse(false);
    }

    protected void setFluidizerActive(boolean active) {
        this.getMultiblockController().filter(AbstractMultiblockController::isAssembled).ifPresent(c -> c.setMachineActive(active));
    }

    protected void onIngredientsChanged() {
        this.executeOnController(MultiblockFluidizer::onIngredientsChanged);
    }

    public IFluidHandler getFluidOutput() {
        return (IFluidHandler)this.evalOnController(MultiblockFluidizer::getFluidHandler, FluidHelper.EMPTY_FLUID_HANDLER);
    }

    public IWideEnergyStorage2 getEnergyStorage() {
        return (IWideEnergyStorage2)this.evalOnController(MultiblockFluidizer::getEnergyStorage, NullEnergyHandlers.WIDE_STORAGE);
    }

    public ITextComponent getPartDisplayName() {
        return new TranslationTextComponent(this.getPartType().map(IMultiblockPartType2::getTranslationKey).orElse("unknown"));
    }

    protected IModelData getUpdatedModelData() {
        return this.getPartType().map(this::getUpdatedModelData).orElse((IModelData)EmptyModelData.INSTANCE);
    }

    protected int getUpdatedModelVariantIndex() {
        return 0;
    }

    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        if (position.isFrame()) {
            validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.fluidizer.invalid_frame_block", new Object[0]);
            return false;
        }
        if (PartPosition.Interior == position) {
            validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.fluidizer.invalid_part_for_interior", new Object[0]);
            return false;
        }
        return true;
    }

    public MultiblockFluidizer createController() {
        return new MultiblockFluidizer(Objects.requireNonNull(this.func_145831_w(), "Trying to create a Controller from a Part without a World"));
    }

    public Class<MultiblockFluidizer> getControllerType() {
        return MultiblockFluidizer.class;
    }

    public void onMachineActivated() {
    }

    public void onMachineDeactivated() {
    }

    protected IModelData getUpdatedModelData(FluidizerPartType partType) {
        return s_modelDataCaches.computeIfAbsent(partType.ordinal(), this.getUpdatedModelVariantIndex(), this.getOutwardFacings(), () -> new CuboidPartVariantsModelData(partType.ordinal(), this.getUpdatedModelVariantIndex(), this.getOutwardFacings()));
    }
}

