/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor;

import com.google.common.collect.ImmutableList;
import it.zerono.mods.extremereactors.gamecontent.multiblock.IMachineReader;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.ISensorType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.SensorBehavior;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import java.util.List;
import net.minecraftforge.common.util.NonNullFunction;

public final class SensorTypeData<Reader extends IMachineReader>
implements ISensorType<Reader> {
    private final IoDirection _direction;
    private final List<SensorBehavior> _validBehaviors;
    private final NonNullFunction<Reader, Integer> _outputTestSupplier;

    public static <Reader extends IMachineReader> SensorTypeData<Reader> input(SensorBehavior ... behaviors) {
        return new SensorTypeData<Reader>(IoDirection.Input, SensorTypeData::inputSensorTest, behaviors);
    }

    public static <Reader extends IMachineReader> SensorTypeData<Reader> output(NonNullFunction<Reader, Integer> outputSupplier, SensorBehavior ... behaviors) {
        return new SensorTypeData<Reader>(IoDirection.Output, outputSupplier, behaviors);
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    public boolean isInput() {
        return this._direction.isInput();
    }

    @Override
    public boolean isOutput() {
        return this._direction.isOutput();
    }

    @Override
    public List<SensorBehavior> getBehaviors() {
        return this._validBehaviors;
    }

    public Integer apply(Reader reader) {
        return (Integer)this._outputTestSupplier.apply(reader);
    }

    @Override
    public String getTranslationBaseName() {
        return "";
    }

    private SensorTypeData(IoDirection direction, NonNullFunction<Reader, Integer> outputSupplier, SensorBehavior ... behaviors) {
        this._direction = direction;
        this._outputTestSupplier = outputSupplier;
        this._validBehaviors = ImmutableList.copyOf((Object[])behaviors);
    }

    private static <Reader extends IMachineReader> Integer inputSensorTest(Reader reader) {
        return 0;
    }
}

