/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.reactor.FuelProperties;
import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.api.reactor.ReactantsRegistry;
import it.zerono.mods.extremereactors.api.reactor.Reaction;
import it.zerono.mods.extremereactors.api.reactor.ReactionsRegistry;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import java.lang.reflect.Field;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public final class ExtremeReactorsCommand {
    private static final String PARAM_NAME = "name";
    private static final String PARAM_VALUE = "value";

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"er").requires(cs -> cs.func_197034_c(2))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"reactants").then(Commands.func_197057_a((String)"get").then(ExtremeReactorsCommand.nameParam().executes(ExtremeReactorsCommand::getReactant)))).then(Commands.func_197057_a((String)"set").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)ExtremeReactorsCommand.nameParam().then(ExtremeReactorsCommand.stringCommand("colour", (Command<CommandSource>)((Command)ExtremeReactorsCommand::setReactantColour)))).then(ExtremeReactorsCommand.floatCommand("moderation", 0.0f, (Command<CommandSource>)((Command)context -> ExtremeReactorsCommand.setReactantFuelValue((CommandContext<CommandSource>)context, r -> Float.valueOf(r.getFuelData().getModerationFactor()), (r, v) -> r.getFuelData().setModerationFactor(v.floatValue())))))).then(ExtremeReactorsCommand.floatCommand("absorption", 0.0f, 1.0f, (Command<CommandSource>)((Command)context -> ExtremeReactorsCommand.setReactantFuelValue((CommandContext<CommandSource>)context, r -> Float.valueOf(r.getFuelData().getAbsorptionCoefficient()), (r, v) -> r.getFuelData().setAbsorptionCoefficient(v.floatValue())))))).then(ExtremeReactorsCommand.floatCommand("hardness", 1.0f, (Command<CommandSource>)((Command)context -> ExtremeReactorsCommand.setReactantFuelValue((CommandContext<CommandSource>)context, r -> Float.valueOf(r.getFuelData().getHardnessDivisor()), (r, v) -> r.getFuelData().setHardnessDivisor(v.floatValue())))))).then(ExtremeReactorsCommand.floatCommand("fissionevents", 0.0f, (Command<CommandSource>)((Command)context -> ExtremeReactorsCommand.setReactantFuelValue((CommandContext<CommandSource>)context, r -> Float.valueOf(r.getFuelData().getFissionEventsPerFuelUnit()), (r, v) -> r.getFuelData().setFissionEventsPerFuelUnit(v.floatValue())))))).then(ExtremeReactorsCommand.floatCommand("fuelunits", 0.0f, (Command<CommandSource>)((Command)context -> ExtremeReactorsCommand.setReactantFuelValue((CommandContext<CommandSource>)context, r -> Float.valueOf(r.getFuelData().getFuelUnitsPerFissionEvent()), (r, v) -> r.getFuelData().setFuelUnitsPerFissionEvent(v.floatValue()))))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"reaction").then(Commands.func_197057_a((String)"get").then(ExtremeReactorsCommand.nameParam().executes(ExtremeReactorsCommand::getReaction)))).then(Commands.func_197057_a((String)"set").then(((RequiredArgumentBuilder)ExtremeReactorsCommand.nameParam().then(ExtremeReactorsCommand.floatCommand("reactivity", 1.0f, (Command<CommandSource>)((Command)context -> ExtremeReactorsCommand.setReactionValue((CommandContext<CommandSource>)context, "_reactivity", ExtremeReactorsCommand.getFloat((CommandContext<CommandSource>)context)))))).then(ExtremeReactorsCommand.floatCommand("fissionRate", 1.0E-4f, (Command<CommandSource>)((Command)context -> ExtremeReactorsCommand.setReactionValue((CommandContext<CommandSource>)context, "_fissionRate", ExtremeReactorsCommand.getFloat((CommandContext<CommandSource>)context)))))))));
    }

    private ExtremeReactorsCommand() {
    }

    private static ArgumentBuilder<CommandSource, LiteralArgumentBuilder<CommandSource>> stringCommand(String propertyName, Command<CommandSource> cmd) {
        return Commands.func_197057_a((String)propertyName).then(Commands.func_197056_a((String)PARAM_VALUE, (ArgumentType)StringArgumentType.string()).executes(cmd));
    }

    private static ArgumentBuilder<CommandSource, LiteralArgumentBuilder<CommandSource>> floatCommand(String propertyName, float min, Command<CommandSource> cmd) {
        return Commands.func_197057_a((String)propertyName).then(Commands.func_197056_a((String)PARAM_VALUE, (ArgumentType)FloatArgumentType.floatArg((float)min)).executes(cmd));
    }

    private static ArgumentBuilder<CommandSource, LiteralArgumentBuilder<CommandSource>> floatCommand(String propertyName, float min, float max, Command<CommandSource> cmd) {
        return Commands.func_197057_a((String)propertyName).then(Commands.func_197056_a((String)PARAM_VALUE, (ArgumentType)FloatArgumentType.floatArg((float)min, (float)max)).executes(cmd));
    }

    private static RequiredArgumentBuilder<CommandSource, String> nameParam() {
        return Commands.func_197056_a((String)PARAM_NAME, (ArgumentType)StringArgumentType.string());
    }

    private static String getName(CommandContext<CommandSource> context) {
        return StringArgumentType.getString(context, (String)PARAM_NAME);
    }

    private static String getString(CommandContext<CommandSource> context) {
        return StringArgumentType.getString(context, (String)PARAM_VALUE);
    }

    private static float getFloat(CommandContext<CommandSource> context) {
        return FloatArgumentType.getFloat(context, (String)PARAM_VALUE);
    }

    private static int getReactant(CommandContext<CommandSource> context) {
        ((CommandSource)context.getSource()).func_197030_a(ReactantsRegistry.get(ExtremeReactorsCommand.getName(context)).map(ExtremeReactorsCommand::getTextFrom).orElse((ITextComponent)new StringTextComponent("Reactant not found")), true);
        return 0;
    }

    private static int setReactantColour(CommandContext<CommandSource> context) {
        ((CommandSource)context.getSource()).func_197030_a(ReactantsRegistry.get(ExtremeReactorsCommand.getName(context)).map(r -> ExtremeReactorsCommand.setReactantColour(r, (int)Long.parseLong(ExtremeReactorsCommand.getString(context), 16))).orElse((ITextComponent)new StringTextComponent("Reactant not found")), true);
        return 0;
    }

    private static ITextComponent setReactantColour(Reactant reactant, int colour) {
        try {
            Field f = reactant.getClass().getDeclaredField("_colour");
            f.setAccessible(true);
            f.set(reactant, Colour.fromRGBA((int)colour));
            return new StringTextComponent(String.format("Reactant %s colour set to 0x%08X", reactant.getName(), colour));
        }
        catch (Exception ex) {
            Log.LOGGER.error((Object)ex);
            return new StringTextComponent("Exception raised while setting colour field");
        }
    }

    private static int setReactantFuelValue(CommandContext<CommandSource> context, Function<Reactant, Float> getter, BiConsumer<Reactant, Float> setter) {
        ((CommandSource)context.getSource()).func_197030_a(ReactantsRegistry.get(ExtremeReactorsCommand.getName(context)).filter(r -> r.test(ReactantType.Fuel)).map(r -> ExtremeReactorsCommand.setReactantFuelValue(r, ExtremeReactorsCommand.getFloat(context), getter, setter)).orElse((ITextComponent)new StringTextComponent("Fuel Reactant not found")), true);
        return 0;
    }

    private static ITextComponent setReactantFuelValue(Reactant reactant, float value, Function<Reactant, Float> getter, BiConsumer<Reactant, Float> setter) {
        setter.accept(reactant, Float.valueOf(value));
        return new StringTextComponent(String.format("Value set to %f", getter.apply(reactant)));
    }

    private static ITextComponent getTextFrom(Reactant reactant) {
        StringTextComponent text = new StringTextComponent(String.format("[" + TextFormatting.BOLD + "%s" + TextFormatting.RESET + "] " + TextFormatting.GOLD + "%s; " + TextFormatting.RESET + TextFormatting.ITALIC + "color: " + TextFormatting.RESET + "%08X", new Object[]{reactant.getType(), reactant.getName(), reactant.getColour().toRGBA()}));
        if (reactant.test(ReactantType.Fuel)) {
            FuelProperties properties = reactant.getFuelData();
            text.func_230529_a_((ITextComponent)new StringTextComponent(String.format("; " + TextFormatting.ITALIC + "moderation: " + TextFormatting.RESET + "%f; " + TextFormatting.ITALIC + "absorption: " + TextFormatting.RESET + "%f; " + TextFormatting.ITALIC + "hardness: " + TextFormatting.RESET + "%f; " + TextFormatting.ITALIC + "fissionEventsPerFuelUnit: " + TextFormatting.RESET + "%f; " + TextFormatting.ITALIC + "fuelUnitsPerFissionEvent: " + TextFormatting.RESET + "%f", Float.valueOf(properties.getModerationFactor()), Float.valueOf(properties.getAbsorptionCoefficient()), Float.valueOf(properties.getHardnessDivisor()), Float.valueOf(properties.getFissionEventsPerFuelUnit()), Float.valueOf(properties.getFuelUnitsPerFissionEvent()))));
        }
        return text;
    }

    private static int getReaction(CommandContext<CommandSource> context) {
        ((CommandSource)context.getSource()).func_197030_a(ReactantsRegistry.get(ExtremeReactorsCommand.getName(context)).flatMap(ReactionsRegistry::get).map(ExtremeReactorsCommand::getTextFrom).orElse((ITextComponent)new StringTextComponent("Reactant or reaction not found")), true);
        return 0;
    }

    private static ITextComponent getTextFrom(Reaction reaction) {
        return new StringTextComponent(String.format("[" + TextFormatting.BOLD + "%s" + TextFormatting.RESET + " -> " + TextFormatting.BOLD + "%s" + TextFormatting.RESET + "] " + TextFormatting.ITALIC + "reactivity: " + TextFormatting.RESET + "%f; " + TextFormatting.ITALIC + "fissionRate: " + TextFormatting.RESET + "%f", reaction.getSource(), reaction.getProduct(), Float.valueOf(reaction.getReactivity()), Float.valueOf(reaction.getFissionRate())));
    }

    private static int setReactionValue(CommandContext<CommandSource> context, String fieldName, float value) {
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)ReactantsRegistry.get(ExtremeReactorsCommand.getName(context)).flatMap(ReactionsRegistry::get).map(reaction -> {
            try {
                Field f = reaction.getClass().getDeclaredField(fieldName);
                f.setAccessible(true);
                f.set(reaction, Float.valueOf(value));
                return new StringTextComponent(String.format("Reaction %s parameter %s set to %f", reaction.getSource(), fieldName, Float.valueOf(value)));
            }
            catch (Exception ex) {
                Log.LOGGER.error((Object)ex);
                return new StringTextComponent(String.format("Exception raised while setting Reaction field %s", fieldName));
            }
        }).orElse(new StringTextComponent("Reactant or reaction not found")), true);
        return 0;
    }
}

