/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.coolant;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.ExtremeReactorsAPI;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.coolant.Coolant;
import it.zerono.mods.extremereactors.api.coolant.FluidsRegistry;
import it.zerono.mods.extremereactors.api.coolant.Vapor;
import it.zerono.mods.extremereactors.api.internal.InternalDispatcher;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.ApiWrapper;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class TransitionsRegistry {
    public static final IMapping<Coolant, Vapor> EMPTY_VAPORIZATION = IMapping.of(Coolant.EMPTY, 0, Vapor.EMPTY, 0);
    public static final IMapping<Vapor, Coolant> EMPTY_CONDENSATION = IMapping.of(Vapor.EMPTY, 0, Coolant.EMPTY, 0);
    private static final Map<Coolant, IMapping<Coolant, Vapor>> s_vaporizations = new Object2ObjectArrayMap(2);
    private static final Map<Vapor, IMapping<Vapor, Coolant>> s_condensations = new Object2ObjectArrayMap(2);
    private static final Marker MARKER = MarkerManager.getMarker((String)"API/TransitionsRegistry").addParents(new Marker[]{ExtremeReactorsAPI.MARKER});
    private static final Marker WRAPPER = MarkerManager.getMarker((String)"ModPack API Wrapper").addParents(new Marker[]{MARKER});

    public static boolean contains(Coolant coolant) {
        return s_vaporizations.containsKey(coolant);
    }

    public static boolean contains(Vapor vapor) {
        return s_condensations.containsKey(vapor);
    }

    public static Optional<IMapping<Coolant, Vapor>> get(Coolant coolant) {
        return Optional.ofNullable(s_vaporizations.get(coolant));
    }

    public static Optional<IMapping<Vapor, Coolant>> get(Vapor vapor) {
        return Optional.ofNullable(s_condensations.get(vapor));
    }

    public static void register(String coolantName, String vaporName) {
        TransitionsRegistry.register(coolantName, 1, vaporName, 1);
    }

    public static void register(String coolantName, int coolantAmount, String vaporName, int vaporAmount) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)coolantName) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)vaporName) ? 1 : 0) != 0);
        InternalDispatcher.dispatch("fluid-transition-register", () -> {
            Coolant coolant = FluidsRegistry.getCoolant(coolantName).orElse(null);
            Vapor vapor = FluidsRegistry.getVapor(vaporName).orElse(null);
            if (null == coolant) {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Skipping registration of a transition for an unknown Coolant: {}", (Object)coolantName);
            } else if (null == vapor) {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Skipping registration of a transition for an unknown Vapor: {}", (Object)vaporName);
            } else {
                if (s_vaporizations.containsKey(coolant)) {
                    ExtremeReactorsAPI.LOGGER.warn(MARKER, "Overwriting {} => {} vaporization transition", (Object)coolantName, (Object)vaporName);
                }
                if (s_condensations.containsKey(vapor)) {
                    ExtremeReactorsAPI.LOGGER.warn(MARKER, "Overwriting {} => {} condensation transition", (Object)vaporName, (Object)coolantName);
                }
                IMapping<Coolant, Vapor> vaporization = IMapping.of(coolant, coolantAmount, vapor, vaporAmount);
                s_vaporizations.put(coolant, vaporization);
                s_condensations.put(vapor, vaporization.getReverse());
            }
        });
    }

    public static void remove(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        InternalDispatcher.dispatch("fluid-transition-remove", () -> {
            FluidsRegistry.getCoolant(name).ifPresent(coolant -> {
                IMapping<Coolant, Vapor> vaporization = s_vaporizations.get(coolant);
                if (null != vaporization) {
                    s_condensations.remove(vaporization.getProduct());
                }
                s_vaporizations.remove(coolant);
            });
            FluidsRegistry.getVapor(name).ifPresent(vapor -> {
                IMapping<Vapor, Coolant> condensation = s_condensations.get(vapor);
                if (null != condensation) {
                    s_vaporizations.remove(condensation.getProduct());
                }
                s_condensations.remove(vapor);
            });
        });
    }

    public static void processWrapper(ApiWrapper wrapper) {
        if (!wrapper.Enabled) {
            return;
        }
        if (wrapper.FluidTransitions.WipeExistingValuesBeforeAdding) {
            Log.LOGGER.info(WRAPPER, "Wiping all fluids transitions existing values");
            s_vaporizations.clear();
            s_condensations.clear();
        } else {
            Arrays.stream(wrapper.FluidTransitions.Remove).filter(name -> !Strings.isNullOrEmpty((String)name)).forEach(TransitionsRegistry::remove);
        }
        Arrays.stream(wrapper.FluidTransitions.Add).filter(Objects::nonNull).forEach(mapping -> TransitionsRegistry.register(mapping.Source, mapping.SourceQuantity, mapping.Product, mapping.ProductQuantity));
    }

    private TransitionsRegistry() {
    }
}

