/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators;

import com.supermartijn642.movingelevators.ElevatorBlockTile;
import com.supermartijn642.movingelevators.ElevatorGroup;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.base.ElevatorInputTile;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class ButtonBlockTile
extends ElevatorInputTile {
    private Direction facing;
    private Direction lastFacing;
    private BlockPos controllerPos;

    public ButtonBlockTile() {
        super(MovingElevators.button_tile);
        this.lastFacing = this.facing = Direction.NORTH;
        this.controllerPos = BlockPos.field_177992_a;
    }

    public void setValues(Direction facing, BlockPos controllerPos) {
        this.facing = facing;
        this.controllerPos = controllerPos;
        this.dataChanged();
    }

    @Override
    protected CompoundNBT getChangedData() {
        CompoundNBT data = super.getChangedData();
        if (this.lastFacing != this.facing) {
            data.func_74768_a("facing", this.facing.func_176745_a());
            this.lastFacing = this.facing;
        }
        return data;
    }

    @Override
    protected CompoundNBT getAllData() {
        CompoundNBT data = super.getAllData();
        data.func_74768_a("facing", this.facing.func_176745_a());
        data.func_74768_a("controllerX", this.controllerPos.func_177958_n());
        data.func_74768_a("controllerY", this.controllerPos.func_177956_o());
        data.func_74768_a("controllerZ", this.controllerPos.func_177952_p());
        return data;
    }

    @Override
    protected void handleData(CompoundNBT data) {
        super.handleData(data);
        if (data.func_74764_b("facing")) {
            this.facing = Direction.func_82600_a((int)data.func_74762_e("facing"));
        }
        if (data.func_74764_b("controllerX")) {
            this.controllerPos = new BlockPos(data.func_74762_e("controllerX"), data.func_74762_e("controllerY"), data.func_74762_e("controllerZ"));
        }
    }

    @Override
    public Direction getFacing() {
        return this.facing;
    }

    public ElevatorBlockTile getController() {
        if (this.field_145850_b == null || this.controllerPos == null) {
            return null;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.controllerPos);
        return tile instanceof ElevatorBlockTile ? (ElevatorBlockTile)tile : null;
    }

    @Override
    public boolean hasGroup() {
        ElevatorBlockTile controller = this.getController();
        return controller != null && controller.hasGroup();
    }

    @Override
    public ElevatorGroup getGroup() {
        ElevatorBlockTile controller = this.getController();
        return controller == null ? null : controller.getGroup();
    }

    @Override
    public String getFloorName() {
        ElevatorBlockTile controller = this.getController();
        return controller == null ? null : controller.getFloorName();
    }

    @Override
    public DyeColor getDisplayLabelColor() {
        ElevatorBlockTile controller = this.getController();
        return controller == null ? null : controller.getDisplayLabelColor();
    }

    @Override
    public int getFloorLevel() {
        return this.controllerPos.func_177956_o();
    }
}

