/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.items;

import javax.annotation.Nonnull;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolsstorage.RFToolsStorage;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerConfiguration;
import mcjty.rftoolsstorage.modules.scanner.items.DumpClientScreenModule;
import mcjty.rftoolsstorage.modules.scanner.items.DumpScreenModule;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class DumpModuleItem
extends GenericModuleItem {
    public DumpModuleItem() {
        super(new Item.Properties().func_200915_b(1).func_200916_a(RFToolsStorage.setup.getTab()));
    }

    protected int getUses(ItemStack stack) {
        return (Integer)StorageScannerConfiguration.DUMP_RFPERTICK.get();
    }

    protected boolean hasGoldMessage(ItemStack stack) {
        return !ModuleTools.hasModuleTarget((ItemStack)stack);
    }

    protected String getInfoString(ItemStack stack) {
        return ModuleTools.getTargetString((ItemStack)stack);
    }

    public Class<DumpScreenModule> getServerScreenModule() {
        return DumpScreenModule.class;
    }

    public Class<DumpClientScreenModule> getClientScreenModule() {
        return DumpClientScreenModule.class;
    }

    public String getModuleName() {
        return "Dump";
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        int index = 0;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 7; ++x) {
                guiBuilder.ghostStack("stack" + index);
                ++index;
            }
            guiBuilder.nl();
        }
        guiBuilder.label("Label:").text("text", new String[]{"Label text"}).color("color", new String[]{"Label color"}).nl().toggle("matchingTag", "Matching Tag", new String[]{"If enabled use common tags", "to match items"});
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos;
        ItemStack stack = context.func_195996_i();
        World world = context.func_195991_k();
        TileEntity te = world.func_175625_s(pos = context.func_195995_a());
        if (te instanceof IStorageScanner) {
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            String name = "<invalid>";
            if (!block.isAir(state, (IBlockReader)world, pos)) {
                name = Tools.getReadableName((World)world, (BlockPos)pos);
            }
            ModuleTools.setPositionInModule((ItemStack)stack, (RegistryKey)world.func_234923_W_(), (BlockPos)pos, (String)name);
            if (world.field_72995_K) {
                Logging.message((PlayerEntity)context.func_195999_j(), (String)("Storage module is set to block '" + name + "'"));
            }
        } else {
            ModuleTools.clearPositionInModule((ItemStack)stack);
            if (world.field_72995_K) {
                Logging.message((PlayerEntity)context.func_195999_j(), (String)"Storage module is cleared");
            }
        }
        return ActionResultType.SUCCESS;
    }
}

