/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsstorage.craftinggrid.CraftingGrid;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.CraftingRecipe;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketGridSync {
    protected BlockPos pos;
    protected RegistryKey<World> type;
    private List<ItemStack[]> recipes;

    public void convertFromBytes(PacketBuffer buf) {
        this.pos = buf.readBoolean() ? buf.func_179259_c() : null;
        this.type = LevelTools.getId((ResourceLocation)buf.func_192575_l());
        int s = buf.readInt();
        this.recipes = new ArrayList<ItemStack[]>(s);
        for (int i = 0; i < s; ++i) {
            int ss = buf.readInt();
            ItemStack[] stacks = new ItemStack[ss];
            for (int j = 0; j < ss; ++j) {
                stacks[j] = buf.func_150791_c();
            }
            this.recipes.add(stacks);
        }
    }

    public void convertToBytes(PacketBuffer buf) {
        if (this.pos != null) {
            buf.writeBoolean(true);
            buf.func_179255_a(this.pos);
        } else {
            buf.writeBoolean(false);
        }
        buf.func_192572_a(this.type.func_240901_a_());
        buf.writeInt(this.recipes.size());
        for (ItemStack[] recipe : this.recipes) {
            buf.writeInt(recipe.length);
            for (ItemStack stack : recipe) {
                buf.func_150788_a(stack);
            }
        }
    }

    protected void init(BlockPos pos, RegistryKey<World> type, CraftingGrid grid) {
        this.pos = pos;
        this.type = type;
        this.recipes = new ArrayList<ItemStack[]>();
        for (int i = 0; i < 6; ++i) {
            CraftingRecipe recipe = grid.getRecipe(i);
            CraftingInventory inventory = recipe.getInventory();
            ItemStack[] stacks = new ItemStack[10];
            stacks[0] = recipe.getResult();
            for (int j = 0; j < 9; ++j) {
                stacks[j + 1] = inventory.func_70301_a(j);
            }
            this.recipes.add(stacks);
        }
    }

    protected CraftingGridProvider handleMessage(World world, PlayerEntity player) {
        TileEntity te;
        CraftingGridProvider provider = null;
        if (this.pos == null) {
            GenericContainer container = PacketGridSync.getOpenContainer();
            if (container == null) {
                Logging.log((String)"Container is missing!");
                return null;
            }
            te = container.getTe();
        } else {
            te = world.func_175625_s(this.pos);
        }
        if (te instanceof CraftingGridProvider) {
            provider = (CraftingGridProvider)te;
        }
        if (provider != null) {
            for (int i = 0; i < this.recipes.size(); ++i) {
                provider.setRecipe(i, this.recipes.get(i));
            }
        }
        return provider;
    }

    private static GenericContainer getOpenContainer() {
        Container container = SafeClientTools.getClientPlayer().field_71070_bA;
        if (container instanceof GenericContainer) {
            return (GenericContainer)container;
        }
        return null;
    }
}

