/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.item.trinkets;

import java.util.HashMap;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import owmii.lib.util.Server;
import owmii.losttrinkets.api.LostTrinketsAPI;
import owmii.losttrinkets.api.trinket.Rarity;
import owmii.losttrinkets.api.trinket.Trinket;
import owmii.losttrinkets.api.trinket.Trinkets;
import owmii.losttrinkets.item.Itms;

@Mod.EventBusSubscriber
public class RubyHeartTrinket
extends Trinket<RubyHeartTrinket> {
    private static HashMap<UUID, Float> lastHealths = new HashMap();

    public RubyHeartTrinket(Rarity rarity, Item.Properties properties) {
        super(rarity, properties);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void saveHealthTickStart(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            lastHealths = Server.get().func_184103_al().func_181057_v().stream().collect(Collectors.toMap(Entity::func_110124_au, LivingEntity::func_110143_aJ, Math::max, HashMap::new));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void saveHealthHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof ServerPlayerEntity) {
            lastHealths.merge(entity.func_110124_au(), Float.valueOf(entity.func_110143_aJ()), Math::max);
        }
    }

    public static void onDeath(LivingDeathEvent event) {
        LivingEntity entity;
        if (!event.getSource().func_76357_e() && (entity = event.getEntityLiving()) instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            Trinkets trinkets = LostTrinketsAPI.getTrinkets(player);
            boolean flag = false;
            if (trinkets.isActive(Itms.RUBY_HEART) && lastHealths.getOrDefault(player.func_110124_au(), Float.valueOf(player.func_110143_aJ())).floatValue() > 6.0f) {
                player.func_70606_j(1.0f);
                event.setCanceled(true);
                flag = true;
            }
            if (!flag && trinkets.isActive(Itms.BROKEN_TOTEM) && player.field_70170_p.field_73012_v.nextInt(4) == 0) {
                if (player instanceof ServerPlayerEntity) {
                    ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)player;
                    serverplayerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)Items.field_190929_cY));
                    CriteriaTriggers.field_193130_A.func_193187_a(serverplayerentity, new ItemStack((IItemProvider)Items.field_190929_cY));
                }
                player.func_70606_j(1.0f);
                player.func_195061_cb();
                player.func_195064_c(new EffectInstance(Effects.field_76428_l, 900, 1));
                player.func_195064_c(new EffectInstance(Effects.field_76444_x, 100, 1));
                player.field_70170_p.func_72960_a((Entity)player, (byte)35);
                event.setCanceled(true);
            }
        }
    }
}

