/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.item.trinkets;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BlockEvent;
import owmii.losttrinkets.api.LostTrinketsAPI;
import owmii.losttrinkets.api.trinket.Rarity;
import owmii.losttrinkets.api.trinket.Trinket;
import owmii.losttrinkets.api.trinket.Trinkets;
import owmii.losttrinkets.item.Itms;

public class OctopickTrinket
extends Trinket<OctopickTrinket> {
    private static final ThreadLocal<ServerPlayerEntity> octoMiningPlayer = new ThreadLocal();

    public OctopickTrinket(Rarity rarity, Item.Properties properties) {
        super(rarity, properties);
    }

    public static void onBreak(BlockEvent.BreakEvent event) {
        if (octoMiningPlayer.get() != null) {
            return;
        }
        try {
            PlayerEntity player = event.getPlayer();
            if (player instanceof ServerPlayerEntity) {
                ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
                octoMiningPlayer.set(serverPlayer);
                if (OctopickTrinket.mine(serverPlayer, serverPlayer.func_71121_q(), event.getPos(), event.getState())) {
                    event.setCanceled(true);
                }
            }
        }
        finally {
            octoMiningPlayer.set(null);
        }
    }

    private static boolean mine(ServerPlayerEntity player, ServerWorld world, BlockPos pos, BlockState state) {
        Trinkets trinkets;
        if (ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos) && (trinkets = LostTrinketsAPI.getTrinkets((PlayerEntity)player)).isActive(Itms.OCTOPICK)) {
            LinkedHashSet toBreak = Sets.newLinkedHashSet();
            if (Tags.Blocks.ORES.func_230235_a_((Object)state.func_177230_c()) || state.func_177230_c() == Blocks.field_150343_Z) {
                toBreak.add(pos);
                for (BlockPos pos1 : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, -1, -1), (BlockPos)pos.func_177982_a(1, 1, 1))) {
                    if (toBreak.contains(pos1)) continue;
                    BlockState state1 = world.func_180495_p(pos1);
                    if (state.func_177230_c() != state1.func_177230_c()) continue;
                    toBreak.add(pos1.func_185334_h());
                    for (BlockPos pos2 : BlockPos.func_218278_a((BlockPos)pos1.func_177982_a(-1, -1, -1), (BlockPos)pos1.func_177982_a(1, 1, 1))) {
                        if (toBreak.contains(pos2)) continue;
                        BlockState state2 = world.func_180495_p(pos2);
                        if (state.func_177230_c() != state2.func_177230_c()) continue;
                        toBreak.add(pos2.func_185334_h());
                    }
                }
            }
            if (toBreak.size() > 1) {
                toBreak.forEach(breakPos -> {
                    BlockState breakState = world.func_180495_p(breakPos);
                    if (breakState.canHarvestBlock((IBlockReader)world, breakPos, (PlayerEntity)player) && player.field_71134_c.func_180237_b(breakPos)) {
                        world.func_217379_c(2001, breakPos, Block.func_196246_j((BlockState)breakState));
                    }
                });
                return true;
            }
        }
        return false;
    }

    public static void collectDrops(EntityJoinWorldEvent event) {
        Entity entity;
        ServerPlayerEntity player = octoMiningPlayer.get();
        if (player != null && (entity = event.getEntity()).func_70089_S() && entity.field_70170_p == player.field_70170_p) {
            boolean valid = true;
            if (entity instanceof ItemEntity) {
                ((ItemEntity)entity).func_174868_q();
            } else if (entity instanceof ExperienceOrbEntity) {
                ((ExperienceOrbEntity)entity).field_70532_c = 0;
                player.field_71090_bL = 0;
            } else {
                valid = false;
            }
            if (valid) {
                Vector3d pos = player.func_213303_ch();
                entity.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                entity.func_70100_b_((PlayerEntity)player);
                if (!entity.func_70089_S()) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

