/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import owmii.losttrinkets.api.ILostTrinketsAPI;
import owmii.losttrinkets.api.player.PlayerData;
import owmii.losttrinkets.api.trinket.ITrinket;
import owmii.losttrinkets.api.trinket.Trinkets;
import owmii.losttrinkets.handler.UnlockManager;

public class LostTrinketsAPIImpl
implements ILostTrinketsAPI {
    public static final Map<UUID, List<ITrinket>> UNLOCK_QUEUE = new HashMap<UUID, List<ITrinket>>();
    public static final List<UUID> WEIGHTED_UNLOCK_QUEUE = new ArrayList<UUID>();

    @Override
    public boolean unlock(PlayerEntity player, ITrinket trinket) {
        if (!player.field_70170_p.field_72995_K && this.isEnabled(trinket) && !this.getTrinkets(player).has(trinket)) {
            ArrayList trinketList = UNLOCK_QUEUE.get(player.func_110124_au());
            if (trinketList != null) {
                trinketList.add((ITrinket)trinket);
            } else {
                trinketList = Lists.newArrayList((Object[])new ITrinket[]{trinket});
            }
            UNLOCK_QUEUE.put(player.func_110124_au(), trinketList);
            return true;
        }
        return false;
    }

    @Override
    public void unlock(PlayerEntity player) {
        if (!player.field_70170_p.field_72995_K) {
            WEIGHTED_UNLOCK_QUEUE.add(player.func_110124_au());
        }
    }

    @Override
    public Trinkets getTrinkets(PlayerEntity player) {
        return this.getData(player).getTrinkets();
    }

    @Override
    public PlayerData getData(PlayerEntity player) {
        return (PlayerData)player.getCapability(PlayerData.CAP).orElse((Object)new PlayerData());
    }

    @Override
    public Set<ITrinket> getTrinkets() {
        return UnlockManager.getTrinkets();
    }

    @Override
    public Set<ITrinket> getRandomTrinkets() {
        return UnlockManager.getRandomTrinkets();
    }
}

